#include <gtk/gtk.h>
#include <hildon-widgets/hildon-note.h>
#include <string.h>
#include <stdlib.h>


static gboolean response(gpointer data)
{
  gtk_dialog_response(GTK_DIALOG ((GtkWidget*)data),GTK_RESPONSE_REJECT);
  return FALSE;
}

static int action(const char* msg)
{
  GtkWidget* note;
  
  note=hildon_note_new_confirmation_add_buttons(NULL,msg,
						GTK_STOCK_YES,
						GTK_RESPONSE_YES,
						GTK_STOCK_NO,
						GTK_RESPONSE_NO,
						NULL);
  if (note!=NULL) {
    gint result;
    guint timeout=g_timeout_add(10*1000,response,note);
    gtk_widget_show_all (note);
    result=gtk_dialog_run (GTK_DIALOG (note));

    if (result!=GTK_RESPONSE_REJECT) {
      g_source_remove(timeout);
    }
    return (result!=GTK_RESPONSE_YES);
  }
  return 0;
}



int main(int argc, char *argv[])
{
  int i;
  char* all=NULL;
  /* Initialize the GTK. */
  gtk_init(&argc, &argv);
  if (argc>1) {
    all=strdup(argv[1]);
    for(i=2;i<argc;i++) {
      char* tmp=malloc(strlen(all)+strlen(argv[i])+1+1);
      strcpy(tmp,all);
      strcat(tmp," ");
      strcat(tmp,argv[i]);
      free(all);
      all=tmp;
    }
  }
  
  
  return action(all);
  
}
