/*
 * This file is part of maemo-dm
 *
 * Copyright (C) 2006 Nokia Corporation.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

 * On Debian GNU/Linux systems, the complete text of the GNU General
 * Public License can be found in `/usr/share/common-licenses/LGPL'.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>

#include <glib.h>
#include <gtk/gtk.h>

#include "libmaemodm.h"

void *
hildon_home_applet_lib_initialize (void *state_data, 
				   int *state_size,
				   GtkWidget **applet_return)
{
  GtkWidget *button;

  fprintf (stderr, "maemo-dm initialize %p %d\n",
	   state_data, *state_size);

  button = maemo_dm_button_new ();
  g_signal_connect (button, "clicked",
		    G_CALLBACK (maemo_dm_dialog_show),
		    NULL);

  *applet_return = button;

  return NULL;
}

int
hildon_home_applet_lib_get_requested_width (void *raw_data)
{
  fprintf (stderr, "maemo-dm get width\n");

  return 40;
}

int
hildon_home_applet_lib_save_state (void *raw_data,
				   void **state_data, 
				   int *state_size)
{
  fprintf (stderr, "maemo-dm save_state\n");

  *state_data = NULL;
  *state_size = 0;
  return 0;
}

void
hildon_home_applet_lib_background (void *raw_data)
{
  fprintf (stderr, "maemo-dm background\n");
}

void
hildon_home_applet_lib_foreground (void *raw_data)
{
  fprintf (stderr, "maemo-dm foreground\n");
}

void
hildon_home_applet_lib_properties (void *raw_data, GtkWidget *parent)
{
  fprintf (stderr, "maemo-dm properties\n");
}

void
hildon_home_applet_lib_deinitialize (void *raw_data)
{
  fprintf (stderr, "maemo-dm deinitialize\n");
}
