/*
 * This file is part of maemo-dm
 *
 * Copyright (C) 2006 Nokia Corporation.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

 * On Debian GNU/Linux systems, the complete text of the GNU General
 * Public License can be found in `/usr/share/common-licenses/LGPL'.
 */

#include "libmaemodm.h"
#include <gtk/gtk.h>
#include <hildon-widgets/gtk-infoprint.h>
#include <glib.h>
#include <glib/gstdio.h>
/* Just because glib is broken.
   We won't have g_access unless we include unistd.h
 */
#include <unistd.h>

static gchar sbrshd_pidfile[]="/var/run/sbrshd.pid";
static gchar activate_storage_cmd[]="sudo "
"/usr/sbin/osso-usb-mass-storage-enable.sh";

struct app_data_t {
  GtkWidget* usbnet;
  GtkWidget* cputra;
};


static gboolean
get_current_usbnet(void)
{
  int status;
  if (g_spawn_command_line_sync("/sbin/ifconfig usb0",
				NULL,NULL,&status,NULL)) {
    return status == 0;
  }
  return FALSE;
}

static gboolean
get_current_sbrshd(void) 
{
  gchar* content;
  gsize content_len;
  if (g_file_get_contents(sbrshd_pidfile,&content,&content_len,NULL))
    {
      gboolean ret;
      gchar* filename=g_strdup_printf("/proc/%s",content);
      ret=g_access(filename,G_FILE_TEST_IS_DIR);
      g_free(content);
      g_free(filename);
      return ret;
    }
  return FALSE;
}

static gboolean
get_current_nfs(void) 
{
  gchar* content;
  gsize content_len;
  if (g_file_get_contents("/proc/filesystems",&content,&content_len,NULL))
    {
      gboolean ret=g_strstr_len(content,content_len,"nodev\tnfs\n")!=NULL||
	g_strstr_len(content,content_len,"nodev\tnfs4\n")!=NULL;
      g_free(content);
      return ret;
    }
  return FALSE;
}

static gboolean
get_current_cputransparency(void)
{
  return get_current_nfs()&&get_current_sbrshd();
}

static void
start_nfs(void)
{
  if (!get_current_nfs()) {
    /* We don't have nfs running */
    g_spawn_command_line_sync("sudo /usr/bin/maemo-dm an",NULL,NULL,NULL,NULL);
  }  
}

static void
stop_nfs(void)
{
  if (!get_current_nfs()) {
    /* We do have nfs running */
    g_spawn_command_line_sync("sudo /usr/bin/maemo-dm sn",NULL,NULL,NULL,NULL);
  }  
}

static void
start_sbrshd(void)
{
  if (!get_current_sbrshd()) {
    /* We don't have sbrshd running */
    g_spawn_command_line_sync("sudo /usr/bin/maemo-dm as",NULL,NULL,NULL,NULL);
  }
}

static void
stop_sbrshd(void)
{
  if (get_current_sbrshd()) {
    /* We do have sbrshd running */
    g_spawn_command_line_sync("sudo /usr/bin/maemo-dm ss",NULL,NULL,NULL,NULL);
  }  
}

static void
set_cputransparency(gboolean active)
{
  if (active) {
    start_nfs();
    start_sbrshd();
  } else {
    stop_sbrshd();
    stop_nfs();
  }
}

static void
window_destroy (GtkWidget* widget, gpointer data)
{
  gtk_main_quit ();
}

static void
button_clicked (GtkButton* button, gpointer data)
{
  gtk_widget_destroy (GTK_WIDGET (data));
}

GtkWindow *
maemo_dm_new (void)
{
  GtkWidget *window, *vbox, *label, *button;

  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);

  gtk_container_set_border_width (GTK_CONTAINER (window), 20);
    
  gtk_window_set_title (GTK_WINDOW (window), "Maemo dm");

  g_signal_connect (G_OBJECT (window), "destroy",
		    G_CALLBACK (window_destroy), NULL);

  vbox = gtk_vbox_new (FALSE, 10);
  label = gtk_label_new ("Maemo dm changer!");
  button = gtk_button_new_with_label("Close");

  g_signal_connect (G_OBJECT (button), "clicked",
		    G_CALLBACK (button_clicked), window);
    
  gtk_box_pack_start (GTK_BOX(vbox), label, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX(vbox), button, FALSE, FALSE, 0);
  
  gtk_container_add (GTK_CONTAINER (window), vbox);
  
  gtk_widget_show_all (window);

  return GTK_WINDOW (window);
}

static void activate_mmc(void) {
  
  g_spawn_command_line_sync("sudo /sbin/rmmod g_ether",
			    NULL,NULL,NULL,NULL);
  
  if (g_spawn_command_line_sync(activate_storage_cmd,
				NULL,NULL,NULL,NULL)) {
    gtk_infoprint(NULL, "MMC activated");
    return;
  }
  
  gtk_infoprint(NULL, "MMC activation error");
}

void activate_usbnet(void) {
  int status;

  if (!get_current_usbnet()) {
    if (g_spawn_command_line_sync("sudo /usr/bin/maemo-dm",NULL,NULL,&status,NULL)) {
      if (status == 0) {
	gtk_infoprint(NULL,"UsbNet activated");
	return;
      }
    }
    gtk_infoprint(NULL,"UsbNet activation error");  
  }
}
static void dialog_response(GtkDialog* dialog, gint response,
			    gpointer user_data) {
  
  struct app_data_t* appdata=(struct app_data_t*)user_data;
  
  if (response == GTK_RESPONSE_OK) {
    gboolean cputra=gtk_toggle_button_get_active
      (GTK_TOGGLE_BUTTON(appdata->cputra));
    if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(appdata->usbnet))) {
      /* MMC */
      activate_mmc();
    } else {
      /* UsbNet */
      activate_usbnet();
    }
    set_cputransparency(cputra);
    return;
  }
  gtk_infoprint(NULL,"No change to MMC/UsbNet state");
}

GtkDialog *
maemo_dm_dialog_new ()
{
  GtkWidget *dialog;
  GtkWidget *button1,*button2,*checkbox;
  GtkBox *box;
  static struct app_data_t appdata;

  dialog = gtk_dialog_new_with_buttons ("UsbNet/MMC changer",
                                        NULL,
                                        GTK_DIALOG_DESTROY_WITH_PARENT |
                                        GTK_DIALOG_NO_SEPARATOR,
                                        "OK",
                                        GTK_RESPONSE_OK,
					"Cancel",
					GTK_RESPONSE_CANCEL,
                                        NULL);

  box = GTK_BOX(GTK_DIALOG (dialog)->vbox);

  /* Create a radio buttons with a label */

  button1 = gtk_radio_button_new_with_label_from_widget (NULL,
      							"MMC"); 
		       
  button2 = gtk_radio_button_new_with_label_from_widget (GTK_RADIO_BUTTON (button1),
							 "UsbNet");
  
  checkbox = gtk_check_button_new_with_label ("Enable cpu-transparency");

  appdata.usbnet=button1;
  appdata.cputra=checkbox;
  
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbox),
			       get_current_cputransparency());
  
  if (get_current_usbnet()) {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button2),
				 TRUE);
  } else {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button1),
				 TRUE);
  }
  
  gtk_box_pack_start (box, button1, TRUE, TRUE, 2);
  gtk_box_pack_start (box, button2, TRUE, TRUE, 2);
  gtk_box_pack_start (box, checkbox, TRUE, TRUE, 2);

  g_signal_connect(GTK_DIALOG(dialog), "response", 
		   G_CALLBACK(dialog_response), 
		   &appdata);
  
  gtk_widget_show_all (dialog);

  return GTK_DIALOG (dialog);
}

void
maemo_dm_dialog_show ()
{
  GtkDialog *dialog = GTK_DIALOG( maemo_dm_dialog_new () );
  gtk_dialog_run (dialog);
  gtk_widget_destroy (GTK_WIDGET(dialog));
}

GtkWidget *
maemo_dm_button_new ()
{
  GtkIconTheme *icon_theme;
  GdkPixbuf *icon;
  GtkWidget *icon_image, *button;

  icon_theme = gtk_icon_theme_get_default ();
  icon = gtk_icon_theme_load_icon (icon_theme,
				   "qgn_stat_dev_network",
				   40,
				   0,
				   NULL);
  if (icon == NULL)
    icon = gtk_icon_theme_load_icon (icon_theme,
				     "qgn_list_gene_default_app",
				     40,
				     0,
				     NULL);
    
  fprintf (stderr, "icon %p\n", icon);
  icon_image = gtk_image_new_from_pixbuf (icon);
  g_object_unref (G_OBJECT (icon));
  button = gtk_button_new ();
  gtk_container_add (GTK_CONTAINER (button), icon_image);

  gtk_widget_show_all (button);

  return button;
}
