/*
 * rtpstream.h - Headers for RTP plugin stream implementation
 *
 * Farsight Voice+Video library
 * Copyright (C) 2005,2006 Collabora Ltd.
 * Copyright (C) 2005,2006 Nokia Corporation
 *   @author Rob Taylor <rob.taylor@collabora.co.uk>.
 *   @author Philippe Kalaf <philippe.kalaf@collabora.co.uk>
 * Copyright (C) 2005 INdT
 *   @author Andre Moreira Magalhaes <andre.magalhaes@indt.org.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __FARSIGHT_RTP_STREAM_H__
#define __FARSIGHT_RTP_STREAM_H__

#include "farsight-stream.h"

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef HAVE_JINGLEP2P
#include "jingle_c.h"
#endif

#ifdef HAVE_CLINKC
#include "helpers/upnpigd.h"
#endif

G_BEGIN_DECLS

/* TYPE MACROS */
#define FARSIGHT_TYPE_RTP_STREAM \
  (farsight_rtp_stream_get_type())
#define FARSIGHT_RTP_STREAM(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), FARSIGHT_TYPE_RTP_STREAM, FarsightRTPStream))
#define FARSIGHT_RTP_STREAM_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass), FARSIGHT_TYPE_RTP_STREAM, FarsightRTPStreamClass))
#define FARSIGHT_IS_RTP_STREAM(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), FARSIGHT_TYPE_RTP_STREAM))
#define FARSIGHT_IS_RTP_STREAM_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE((klass), FARSIGHT_TYPE_RTP_STREAM))
#define FARSIGHT_RTP_STREAM_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), FARSIGHT_TYPE_RTP_STREAM, FarsightRTPStreamClass))

#define DIR_SEND 0
#define DIR_RECV 1

typedef struct _FarsightRTPStreamClass FarsightRTPStreamClass;

struct _FarsightRTPStreamClass
{
  FarsightStreamClass parent_class;
};

struct _FarsightRTPStream
{
  FarsightStream parent;

  gboolean disposed;

  GList *local_codecs;
  const GHashTable *list_codecs_internal;
  GList *remote_codecs;
  GHashTable *pt_caps_table;

  /* send/recv pipeline */
  GstElement *pipeline;
  GstElement *rtpbin;
  GstElement *send_codec_bin;

  GstElement *src;
  GstCaps *src_filter;

  GstElement *rtpdemux;
  GstElement *sink;
  GstCaps *sink_filter;

  guint bus_watch;

  gint recv_codec_id;
  gint send_codec_id;
  
  gboolean start_me;
  gboolean build_send_pipeline;

  GHashTable *depayloader_chains_info;

  gboolean prepared; /*set if prepare has been called*/
#ifdef HAVE_JINGLEP2P
  socketclient_t socket_client;
#endif

  gchar *stun_ip;
  guint stun_port;
  gchar *turn_ip;
  guint turn_port;

  guint conn_timeout;
  gint timeout_src;

  GList *local_candidates;
  GList *remote_candidates;

  gchar *active_native_candidate;
  gchar *active_remote_candidate;

  guint16 base_local_port;
  guint16 local_port;
  gint local_socket; /* socket used for symetric RTP */

  gboolean use_upnp;
};

typedef struct _DepayloaderChainInfo DepayloaderChainInfo;

struct _DepayloaderChainInfo
{
  GstPad *pad;
};

GType farsight_rtp_stream_get_type (void);

G_END_DECLS

#endif
