/*
 * farsight-transport.c - Source for core API transports
 *
 * Farsight Voice+Video library
 * FarsightCodec
 * Copyright 2005,2006 Collabora Ltd.
 * Copyright 2005,2006 Nokia Corp.
 *   Contact: Philippe Kalaf <philippe.kalaf@collabora.co.uk>
 * Copyright (c) 2005 INdT.
 *   Contact: Andre Moreira Magalhaes <andre.magalhaes@indt.org.br>,
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "farsight-transport.h"

/*
void
farsight_transport_init ()
{
}
*/

void
farsight_transport_destroy (FarsightTransportInfo * trans)
{
  if (trans->candidate_id)
      g_free ((gchar *)trans->candidate_id);
  if (trans->ip)
      g_free ((gchar *)trans->ip);
  if (trans->proto_subtype)
      g_free ((gchar *)trans->proto_subtype);
  if (trans->proto_profile)
      g_free ((gchar *)trans->proto_profile);
  if (trans->username)
      g_free ((gchar *)trans->username);
  if (trans->password)
      g_free ((gchar *)trans->password);

  g_free (trans);
}

FarsightTransportInfo *
farsight_transport_copy (const FarsightTransportInfo * trans)
{
  FarsightTransportInfo *copy = g_new0 (FarsightTransportInfo, 1);

  copy->component = trans->component;
  copy->port = trans->port;
  copy->proto = trans->proto;
  copy->preference = trans->preference;
  copy->type = trans->type;

  if (trans->candidate_id)
      copy->candidate_id = g_strdup (trans->candidate_id);
  else
      copy->candidate_id = NULL;
  
  if (trans->ip)
      copy->ip = g_strdup (trans->ip);
  else
      copy->ip = NULL;

  if (trans->proto_subtype)
      copy->proto_subtype = g_strdup (trans->proto_subtype);
  else
      copy->proto_subtype = NULL;

  if (trans->proto_profile)
      copy->proto_profile = g_strdup (trans->proto_profile);
  else
      copy->proto_profile = NULL;

  if (trans->username)
      copy->username = g_strdup (trans->username);
  else
      copy->username = NULL;

  if (trans->password)
      copy->password = g_strdup (trans->password);
  else
      copy->password = NULL;

  return copy;
}

void
farsight_transport_list_destroy (GList *transport_list)
{
  GList *lp;
  FarsightTransportInfo *trans;

  for (lp = transport_list; lp; lp = g_list_next (lp)) {
    trans = (FarsightTransportInfo *) lp->data;
    farsight_transport_destroy(trans);
    lp->data = NULL;
  }
  g_list_free (transport_list);
}

GList *
farsight_transport_list_copy (const GList *transport_list)
{
  GList *copy = NULL;
  const GList *lp;
  FarsightTransportInfo *trans;

  for (lp = transport_list; lp; lp = g_list_next (lp)) {
    trans = (FarsightTransportInfo *) lp->data;
    /* prepend then reverse the list for efficiency */
    copy = g_list_prepend (copy, farsight_transport_copy (trans));
  }
  copy= g_list_reverse (copy);
  return copy;
}

GList *
farsight_transport_get_list_for_candidate_id (const GList *candidate_list, const
        gchar *candidate_id)
{
    FarsightTransportInfo *trans = NULL;
    GList *result = NULL;
    const GList *lp;
    FarsightTransportInfo *ccopy = NULL;

    for (lp = candidate_list; lp; lp = g_list_next (lp)) {
        trans = (FarsightTransportInfo *) lp->data;
        if (g_ascii_strcasecmp(trans->candidate_id, candidate_id) == 0)
        {
            ccopy = farsight_transport_copy(trans);
            g_print("%p\n", ccopy);
            result = g_list_prepend (result, ccopy);
        }
    }
    result = g_list_reverse (result);
    return result;
}

gboolean farsight_transport_are_equal (FarsightTransportInfo *trans1,
        FarsightTransportInfo *trans2)
{
    /* TODO we compare just the ip and port for now 
     * is this enough ? think about it some more */
    if ((g_ascii_strcasecmp(trans1->ip, trans2->ip) == 0) &&
            (trans1->port == trans2->port))
        return TRUE;
    else
        return FALSE;
}
