
import os
from utils import get_addrs
import sys
import ConfigParser

CURR_DIR = os.environ["PWD"]
MSGS_DIR = ""
if ( os.path.exists( os.environ["top_srcdir"]+"/tests/regression/stress/messages/" ) ):
    MSGS_DIR = os.environ["top_srcdir"]+"/tests/regression/stress/messages/"
    #print "MSGS_DIR (to_srcdir) = %s\n" % MSGS_DIR
else:
    if ( CURR_DIR.find('stress') == -1 ):
        MSGS_DIR = os.environ["PWD"]+"/stress/messages/"
        #print "MSGS_DIR = %s\n" % MSGS_DIR
    elif (os.path.exists(os.environ["PWD"]+"/messages/")):
        MSGS_DIR = os.environ["PWD"]+"/messages/"
        #print "MSGS_DIR = %s\n" % MSGS_DIR    

#NOTIFY message file name
NOTIFY_ALIVE_MSG_FILENAME="notify_ssdp_alive.msg"
#NOTIFY message configuration parameters file name
NOTIFY_ALIVE_PARAMS_FILENAME="notify_ssdp_alive.params"

class NotifyAliveMessage:
    def __init__(self, fileNameParams = ""):
        """Sets default values """        
        if fileNameParams != "":
            self.loadNotifyAliveMessageParams(fileNameParams);
        else:
            self.maxAge = '1800' #
            self.location_host = self.get_local_addr()
            self.change_host_at_location( self.location_host )
            self.nt = "urn:schemas-upnp-org:device:InternetGatewayDevice:1"
            self.host = '239.255.255.250'
            self.port = '1900'

    def get_local_addr(self):
        addrs = get_addrs()
        addrs.remove('127.0.0.1')
        return addrs[0]
    
    def change_host_at_location(self, host):
        self.location_host = host
        self.location = "%s:19" % self.location_host
        #self.location = "%s:19/igddescs/gatedesc.xml" % self.location_host
        
    def loadNotifyAliveMessageParams(self, fileNameParams):
        """Load data from the SSDP Alive message from a file."""
        config = ConfigParser.ConfigParser()
        if os.path.exists(MSGS_DIR+fileNameParams):
            config.read(MSGS_DIR+fileNameParams)
            try:
                maxAge = config.get("Notify SSDP Alive Params", "MaxAge")
                location = config.get("Notify SSDP Alive Params", "Location")
                nt = config.get("Notify SSDP Alive Params", "NT")
                host = config.get("Notify SSDP Alive Params", "Host")
                port = config.get("Notify SSDP Alive Params", "Port")
            except:
                raise "ConfigError", "Problems on configuration file (%s) " % fileNameParams
            else:
                self.maxAge = maxAge
                self.location = location
                self.nt = nt
                self.host = host
                self.port = port
        else:
            print "Specified file doesn't exists! Creating file %s" % (MSGS_DIR+fileNameParams)
            self.create()

    def create(self):
        self.save()
    
    def save(self):
        """Store data from the SSDP Alive message in a file."""
        config = ConfigParser.ConfigParser()
        config.add_section("Notify SSDP Alive Params")
        config.set("Notify SSDP Alive Params", "MaxAge", self.maxAge)
        config.set("Notify SSDP Alive Params", "Location", self.location)
        config.set("Notify SSDP Alive Params", "NT", self.nt)
        config.set("Notify SSDP Alive Params", "Host", self.host)
        config.set("Notify SSDP Alive Params", "Port", self.port)
        file = open(MSGS_DIR+self.paramsFilename, "w")
        config.write(file)
        file.close()
    
    def get_max_age(self):
        return self.maxAge
    
    def get_location(self):
        return self.location
    
    def get_nt(self):
        return self.nt
    
    def get_host(self):
        return self.host
    
    def get_port(self):
        return self.port

    def show(self):
        return "NotifyAliveMessage => maxAge = %s, location = %s, nt = %s, host = %s, port = %s\n" % (self.maxAge, self.location, self.nt, self.host, self.port)

class NotifyAliveMessageSession:
    def __init__(self, msgFilename = NOTIFY_ALIVE_MSG_FILENAME, 
                 paramsFilename = NOTIFY_ALIVE_PARAMS_FILENAME):
        self.msgFilename = msgFilename
        self.paramsFilename = paramsFilename
        self.notifyMsg = NotifyAliveMessage(self.paramsFilename)

    def getMsgContentFromFile(self, filename):
        #print "Opening message filename = %s\n" % (MSGS_DIR+filename)
        fileContent = []
        file_cnt = ""
        if os.path.exists(MSGS_DIR+filename):
            f = open(MSGS_DIR+filename, 'r+')
            file_cnt = f.read()
            fileContent = file_cnt.splitlines(False)
            #print "File content = ", fileContent
        file_cnt = "\r\n".join(fileContent)
        file_cnt += "\r\n\r\n"
        #print "Parsed file content = ", file_cnt
        return file_cnt

    def createNotifyAliveMessage(self, host = None, fileMsg = NOTIFY_ALIVE_MSG_FILENAME, 
                                 fileMsgParams = NOTIFY_ALIVE_PARAMS_FILENAME):
        """Creating the SSDP Alive message."""
        self.msgFilename = fileMsg
        self.paramsFilename = fileMsgParams
        msgNotifyAlive = self.getMsgContentFromFile(self.msgFilename)
        # put the SSDP alive message parameters settled in the "params" file
        self.notifyMsg = NotifyAliveMessage(self.paramsFilename)
        if host != None:
            self.notifyMsg.change_host_at_location(host);
        #print "Created notifyMsg from file: %s\n" % self.notifyMsg.show()
        notify_msg_final = (msgNotifyAlive % (self.notifyMsg.maxAge, self.notifyMsg.location, self.notifyMsg.nt, self.notifyMsg.nt, self.notifyMsg.host, self.notifyMsg.port))
        #print "\nMessage that will be sent = %s\n" % notify_msg_final
        return notify_msg_final
