#!/usr/bin/env python

import socket, sys, time

CRLF = '\r\n'
host = sys.argv[1]
textport = sys.argv[2]
filename = sys.argv[3]

content_notify = [
    'NOTIFY * HTTP/1.1',
    'HOST: 239.255.255.250:190',
    'CACHE-CONTROL: max-age = 1800'
    'LOCATION: /root',
    'NT:',
    'NTS: ssdp:alive',
    'SERVER:',
    'USN: uuid:device-UUID::upnp:rootdevice'
              ]
content_notify = "\r\n".join( content_notify )

content_msearch = 'M-SEARCH * HTTP/1.1'
CRLF
'HOST: 239.255.255.250:1900'
CRLF
'MAN: "ssdp:discover"'
CRLF
'MX: 10'
CRLF
'ST: %s'
CRLF

content_byebye = 'NOTIFY * HTTP/1.1'
CRLF
'HOST: 239.255.255.250:1900'
CRLF
'NT: "upnp:rootdevice"'
CRLF
'NTS: ssdp:byebye'
CRLF
'USN: %s'
CRLF

def connect_udp():
    try:
        s = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
    except socket.error, e:
        print "Strange error creating socket: %s" % e
        sys.exit(1)
        
    try:
        port = int(textport)
    except ValueError:
        try:
            port = socket.getservbyname(textport, 'udp')
        except socket.error, e:
            print "Couldn't find your port (UDP): %s" % e
            sys.exit(1)

    try:
        s.connect((host,port))
    except socket.gaierror, e:
        print "Address-related error connecting to server: %s" % e
        sys.exit(1)
    except socket.error, e:
        print "Connection error: %s" % e
        sys.exit(1)
        
    print "Sleeping..."
    time.sleep(10)
    print "Continuing."

    return s

def send_message(s, msg, arguments):
    content = msg % arguments
    print content
    try:
        s.sendall(content)
    except socket.error, e:
        print "Error sending data: %s" % e
        sys.exit(1)
        
    try:
        s.shutdown(1)
    except socket.error, e:
        print "Error sending data (detected by shutdown): %s" % e
        sys.exit(1)
        
    while 1:
        try:
            buf = s.recv(2048)
        except socket.error, e:
            print "Error receiving data: %s" % e
            sys.exit(1)
        if not len(buf):
            break
        sys.stdout.write(buf)

def send_msearch_message_ssdp_all():
    s = connect_udp()
    send_message(s, content_msearch, 'ssdp:all')
    
def __main__():
    send_msearch_message_ssdp_all()
    return

    