#!/usr/bin/env python2.4

################################################
# Simple UDP Multicast Client example
# Rosfran Lins Borges (rosfran.borges@indt.org.br)
# multicast_simple_client.py
################################################

import sys, traceback, os
import ConfigParser
from twisted.internet.protocol import DatagramProtocol
from twisted.internet import reactor
from twisted.python import threadable
from twisted.application.internet import MulticastServer

# local application scope imports
import ssdp_notify_msg
import msearch_msg

#threadable.init()

# timeout for closing reactor (seconds)
REACTOR_TIMEOUT=5
CRLF = '\r\n'
# directory used to store the UDP messages
#MSGS_DIR = './messages/'
MSGS_DIR = os.environ["PWD"]+'/messages/'
print "MSGS_DIR =", MSGS_DIR
MAX_PACKET_NUMBER = 5
MAX_PACKET_SIZE = 512

content_notify = "NOTIFY * HTTP/1.1\r\n\
HOST: 239.255.255.250:1900\r\n\
Cache-Control: max-age = 1800\r\n\
Location: http://172.19.141.82:38400/description.xml\r\n\
NT: urn:schemas-upnp-org:service:timer:1\r\n\
NTS: ssdp:alive\r\n\
Server: Testing Linux 2.6.12-1-686 UPnP/1.0 CyberLinkC/1.0\r\n\
USN: uuid:device-UUID::upnp:rootdevice\r\n\
HOST: uuid:cybergarageClockDevice::urn:schemas-upnp-org:service:timer:1\r\n\
\r\n"

msearch_IGD_response = "HTTP/1.1 200 OK\r\n\
Cache-Control: max-age = 1800\r\n\
EXT: \r\n\
Location: http://172.19.141.70:49152/gatedesc.xml\r\n\
ST: urn:schemas-upnp-org:device:InternetGatewayDevice:1\r\n\
Server: Testing Linux 2.6.12-1-686 UPnP/1.0 CyberLinkC/1.0\r\n\
USN: uuid:device-UUID::upnp:rootdevice\r\n\
\r\n"

def gotIP(ip):
    print "Got IP number =", ip

def getIPAddrForName(siteName):
    reactor.resolve(siteName).addCallback(gotIP)

class MulticastClientUDP(DatagramProtocol):

    def datagramReceived(self, datagram, address):
            print "Received: %s\n" % repr(datagram)

class UnicastClientUDP(DatagramProtocol):
    
    def __init__(self, addr, prt, msg):
        """Initialize a Unicast UDP connection
        @param addr a String denotating IP address
        @param prt Port number
        @param msg Message content to send
        """
        self.address = addr
        self.port = prt
        self.msg = msg

    def startProtocol(self):
        self.transport.connect(self.addr, self.port)
        print "Sending to %s now" % str((host, port))
        self.transport.write("hello") # no need for address
        
    def datagramReceived(self, data, (host, port)):
        print "received %r from %s:%d" % (data, host, port)

    # Possibly invoked if there is no server listening on the
    # address to which we are sending.
    def connectionRefused(self):
        print "None listening"

def getMsgContentFromFile(filename):
    print "Opening message filename = %s\n" % (MSGS_DIR+filename)
    s = ""
    fileContent = []
    file_content = ""
    if os.path.exists(MSGS_DIR+filename):
        f = open(MSGS_DIR+filename, 'r+')
        file_content = f.read()
        fileContent = file_content.splitlines( False )
        #print "s = %s\n"  % s
    s = "\r\n".join(fileContent)
    s += "\r\n"
    return s
    print "Get message from file == %s" % s

def sendMulticastUDP(addr, port, nts, maxPacketSize = MAX_PACKET_SIZE,
                      max_packet_number = MAX_PACKET_NUMBER):
    """Send a multicast UDP message, based on a command-line parameter list
        UDP message can be one of that below (based on the msgNEM parameter value):
            - M-SEARCH IGD Response
            - Notify
        @param addr Multicast address for packet sending
        @param port Port number for the multicast server listening
        @param msgMNEM Message type
        @param maxPacketSize Max size for each packet
        @param maxPacketNumber Max number of packets
    """
    msgUDP = ''
    if msgMNEM[0:12] == 'msearch_resp':
        print 'msearch message option selected\n'
        msgUDP = getMsgContentFromFile("msearch_igd_response.msg")
    elif msgMNEM[0:14] == 'content_notify':
        print 'content_notify message option selected\n'
        msgUDP = getMsgContentFromFile("content_notify.msg")
    elif msgMNEM[0:10] == 'ssdp_alive':
        print 'ssdp_alive message option selected\n'
        #create SSDP Notify Alive message session
        msgSSDPAlive = NotifyAliveMessageSession()
        #create a notify SSDP Alive message, filling up the 4 parameters
        msgUDP = msgSSDPAlive.createNotifyAliveMessage("%s:%d" % (addr, port))
    elif msgMNEM[0:7] == 'msearch':
        print 'ssdp_alive message option selected\n'
        #create SSDP Notify Alive message session
        msgMSearchAlive = msearch_msg.MSearchMessageSession()
        #create a notify SSDP Alive message, filling up the 4 parameters
        msgUDP = msgMSearchAlive.createMSearchMessage("%s:%d" % (addr, port))

    multi_UDP = MulticastClientUDP()
    # sets timeout for closing reactor(default=5 seconds)
    callID = reactor.callLater(REACTOR_TIMEOUT, reactor.stop)
    #uni_UDP = UnicastClientUDP()
    maxPacketSizeStr = str(maxPacketSize)
    hst = (addr, port)
    i = 0
    while i < maxPacketNumber:
        try:
            ++i
            print "Sending UDP packet to %s:%d ...\n" % ( addr, port )
            print "Message content = %s" % msgUDP
            # Send multicast on 239.255.255.250:1900, on our dynamically allocated port
            reactor.listenUDP(0, multi_UDP, maxPacketSizeStr).write(msgUDP, (addr, port))
            #reactor.run()
            # this may be not the best solution, call stop just after a reactor.run() call
            #reactor.stop()
        except (KeyboardInterrupt, SystemExit):
            reactor.stop()
            sys.exit(1)
            break
        except:
            traceback.print_exc()
    reactor.run()

def sendUnicastUDP(addr, port, nts, maxPacketSize = MAX_PACKET_SIZE,
                      max_packet_number = MAX_PACKET_NUMBER):
    """Send a unicast UDP message, based on a command-line parameter list
        UDP message can be one of that below (based on the msgNEM parameter value):
            - M-SEARCH IGD Response
        @param addr Multicast address for packet sending
        @param port Port number for the multicast server listening
        @param msgMNEM Message type mnemomicous
        @param maxPacketSize Max size for each packet
        @param maxPacketNumber Max number of packets
    """
    msgUDP = ''
    if msgMNEM[0:12] == 'msearch_resp':
        print 'msearch message option selected\n'
        msgUDP = getMsgContentFromFile("msearch_igd_response.msg")

    uni_UDP = UnicastClientUDP(addr, port, msgUDP)
    # sets timeout for closing reactor(default=5 seconds)
    reactor.callLater(REACTOR_TIMEOUT, reactor.stop)
    #uni_UDP = UnicastClientUDP()
    maxPacketSizeStr = str(maxPacketSize)
    hst = (addr, port)
    i = 0
    while i < maxPacketNumber:
        try:
            ++i
            print "Sending UDP packet to %s:%d ...\n" % ( addr, port )
            print "Message content = %s" % msgUDP
            # Send multicast on 239.255.255.250:1900, on our dynamically allocated port
            reactor.listenUDP(0, uni_UDP, maxPacketSizeStr)
        except (KeyboardInterrupt, SystemExit):
            reactor.stop()
            sys.exit(1)
            break
        except:
            traceback.print_exc()
    reactor.run()

if __name__ == "__main__":
    addr = '239.255.255.250'
    port = 1900
    msgMNEM = 'ssdp_alive'
    maxPacketNumber = MAX_PACKET_NUMBER
    print "Parameters passed through this script = %s\n" % len(sys.argv)
    if len(sys.argv) > 1:
        addr = sys.argv[1]
        if len(sys.argv) == 3:
            try:
                port = int(sys.argv[2])
            except ValueError:
                print "Invalid conversion for the port number value: %d " % sys.argv[2]
                sys.exit()
        if len(sys.argv) == 4:
            msgMNEM = sys.argv[3]            
        if len(sys.argv) == 5:
            try:
                maxPacketNumber = int(sys.argv[4])
            except ValueError:
                print "Invalid conversion for the max packet number value: %d " % sys.argv[4]
                sys.exit()
    # send a lot of Multicast UDP UPnP Notify messages
    sendMulticastUDP(addr, port, msgMNEM)
