
import os
import ConfigParser

MSEARCH_MSG_FILENAME = "msearch_ssdp_discover.msg"
MSEARCH_PARAMS_FILENAME = "msearch_ssdp_discover.params"

# message's directory
MSGS_DIR = os.environ["PWD"]+'/messages/'
print "Getting information from the messages' directory = %s\n" % MSGS_DIR

class MSearchMessage:
    def __init__(self):
        """Sets default values"""
        self.mx = "2"
        self.st = "urn:schemas-upnp-org:device:InternetGatewayDevice:1"
    def show(self):
        print "MSearchMessage => MX = %s, ST = %s\n" % (self.mx, self.st)

class MSearchMessageSession:
    def __init__(self):
        self.msearchMsg = MSearchMessage()

    def getMsgContentFromFile(self, filename):
        print "Openning message filename = %s\n" % (MSGS_DIR+filename)
        s = ""
        fileContent = []
        if os.path.exists(MSGS_DIR+filename):
            f = open(MSGS_DIR+filename, 'r+')
            fileContent = f.readlines()
            #print "s = %s\n"  % s
        s = "\r\n".join(fileContent)
        s += "\r\n"
        return s
        #print "MSG == %s" % s

    def createMSearchMessage(self, host):
        msgMSearch = self.getMsgContentFromFile(MSEARCH_MSG_FILENAME)
        self.loadMSearchMessageParams()
        print "msearchMsg = %s\n" % self.msearchMsg.show()
        return msgMSearch % (self.msearchMsg.mx, self.msearchMsg.st)
    
    def loadMSearchMessageParams(self):
        """Load data from the SSDP Alive message from a file."""
        config = ConfigParser.ConfigParser()
        if os.path.exists(MSGS_DIR+MSEARCH_PARAMS_FILENAME):
            config.read(MSGS_DIR+MSEARCH_PARAMS_FILENAME)
            try:
                mx=config.get("MSearch SSDP Discover Params", "MX")
                st=config.get("MSearch SSDP Discover Params", "ST")
            except:
                raise "ConfigError", "Problems on configuration file (%s) " % MSEARCH_PARAMS_FILENAME
            else:
                self.msearchMsg.mx = mx
                self.msearchMsg.st = st
        else:
            print "Creating file %s..." % MSGS_DIR+MSEARCH_PARAMS_FILENAME
            self.create()
    
    def create(self):
        self.save()
    
    def save(self):
        """Store data from the MSearch message in a file."""
        config = ConfigParser.ConfigParser()
        config.add_section("MSearch SSDP Discover Params")
        config.set("MSearch SSDP Discover Params", "MX", self.msearchMsg.mx)
        config.set("MSearch SSDP Discover Params", "ST", self.msearchMsg.st)
        file = open(MSGS_DIR+MSEARCH_PARAMS_FILENAME, "w")
        config.write(file)
        file.close()
        
if __name__ == '__main__':
    # just for testing
    msgSession = MSearchMessageSession()
