/**
 *
 * 	UPnP IGD simple device implementation
 *
 */

#include <cybergarage/upnp/cupnp.h>
#include "common.h"

char *IGD_DEVICE_DESCRIPTION_FILE_NAME = "igddescs/gatedesc.xml";
char *IGD_ICFG_SERVICE_DESCRIPTION_FILE_NAME = "igddescs/gateifcgSCPD.xml";

/**
 * UPnP IGD device description
 */
char *IGD_DEVICE_DESCRIPTION =
"<?xml version=\"1.0\"?>"
"<root xmlns=\"urn:schemas-upnp-org:device-1-0\">"
"	<specVersion>"
"		<major>1</major>"
"		<minor>0</minor>"
"	</specVersion>"
"	<device>"
"		<deviceType>urn:schemas-upnp-org:device:InternetGatewayDevice:1</deviceType>"
"		<friendlyName>UPnPIGD</friendlyName>"
"		<manufacturer>Linux UPnP IGD Project</manufacturer>"
"		<manufacturerURL>http://linux-igd.sourceforge.net</manufacturerURL>"
"		<modelName>IGD Version 0.92</modelName>"
"		<UDN>uuid:75802409-bccb-40e7-8e6c-fa095ecce13e</UDN>"
"		<iconList>"
"			<icon>"
"				<mimetype>image/gif</mimetype>"
"				<width>118</width>"
"				<height>119</height>"
"				<depth>8</depth>"
"				<url>/ligd.gif</url>"
"			</icon>"
"		</iconList>"
"		<serviceList>"
"       	<service>"
"           	<serviceType>urn:schemas-dummy-com:service:Dummy:1</serviceType>"
"               <serviceId>urn:dummy-com:serviceId:dummy1</serviceId>"
"	            <controlURL>/dummy</controlURL>"
"               <eventSubURL>/dummy</eventSubURL>"
"       		<SCPDURL>/igddescs/dummy.xml</SCPDURL>"
"           </service>"
"       </serviceList>"
"		<deviceList>"
"			<device>"
"				<deviceType>urn:schemas-upnp-org:device:WANDevice:1</deviceType>"
"				<friendlyName>WANDevice</friendlyName>"
"				<manufacturer>Linux UPnP IGD Project</manufacturer>"
"				<manufacturerURL>http://linux-igd.sourceforge.net</manufacturerURL>"
"				<modelDescription>WAN Device on Linux IGD</modelDescription>"
"				<modelName>Linux IGD</modelName>"
"				<modelNumber>0.92</modelNumber>"
"				<modelURL>http://linux-igd.sourceforge.net</modelURL>"
"				<serialNumber>0.92</serialNumber>"
"				<UDN>uuid:75802409-bccb-40e7-8e6c-fa095ecce13e</UDN>"
"				<UPC>Linux IGD</UPC>"
"				<serviceList>"
"					<service>"
"						<serviceType>urn:schemas-upnp-org:service:WANCommonInterfaceConfig:1</serviceType>"
"						<serviceId>urn:upnp-org:serviceId:WANCommonIFC1</serviceId>"
"						<controlURL>/upnp/control/WANCommonIFC1</controlURL>"
"						<eventSubURL>/upnp/control/WANCommonIFC1</eventSubURL>"
"						<SCPDURL>/igddescs/gateicfgSCPD.xml</SCPDURL>"
"					</service>"
"				</serviceList>"
"				<deviceList>"
"					<device>"
"						<deviceType>urn:schemas-upnp-org:device:WANConnectionDevice:1</deviceType>"
"						<friendlyName>WANConnectionDevice</friendlyName>"
"						<manufacturer>Linux UPnP IGD Project</manufacturer>"
"						<manufacturerURL>http://linux-igd.sourceforge.net</manufacturerURL>"
"						<modelDescription>WanConnectionDevice on Linux IGD</modelDescription>"
"						<modelName>Linux IGD</modelName>"
"						<modelNumber>0.92</modelNumber>"
"						<modelURL>http://linux-igd.sourceforge.net</modelURL>"
"						<serialNumber>0.92</serialNumber>"
"						<UDN>uuid:75802409-bccb-40e7-8e6c-fa095ecce13e</UDN>"
"						<UPC>Linux IGD</UPC>"
"						<serviceList>"
"							<service>"
"								<serviceType>urn:schemas-upnp-org:service:WANIPConnection:1</serviceType>"
"								<serviceId>urn:upnp-org:serviceId:WANIPConn1</serviceId>"
"								<controlURL>/upnp/control/WANIPConn1</controlURL>"
"								<eventSubURL>/upnp/control/WANIPConn1</eventSubURL>"
"								<SCPDURL>/igddescs/gateconnSCPD.xml</SCPDURL>"
"							</service>"
"						</serviceList>"
"					</device>"
"				</deviceList>"
"			</device>"
"		</deviceList>"
"	</device>"
"</root>";

/**
 * UPnP IGD Common Interface Config service description
 */
char *IGD_IFCG_SERVICE_DESCRIPTION =
"<?xml version=\"1.0\"?>"
"<scpd xmlns=\"urn:schemas-upnp-org:service-1-0\">"
"	<specVersion>"
"		<major>1</major>"
"		<minor>0</minor>"
"	</specVersion>"
"	<actionList>"
"    <action>"
"      <name>GetCommonLinkProperties</name>"
"      <argumentList>"
"        <argument>"
"          <name>NewWANAccessType</name>"
"          <direction>out</direction>"
"          <relatedStateVariable>WANAccessType</relatedStateVariable>"
"        </argument>"
"        <argument>"
"          <name>NewLayer1UpstreamMaxBitRate</name>"
"          <direction>out</direction>"
"          <relatedStateVariable>Layer1UpstreamMaxBitRate</relatedStateVariable>"
"        </argument>"
"        <argument>"
"          <name>NewLayer1DownstreamMaxBitRate</name>"
"          <direction>out</direction>"
"          <relatedStateVariable>Layer1DownstreamMaxBitRate</relatedStateVariable>"
"        </argument>"
"        <argument>"
"          <name>NewPhysicalLinkStatus</name>"
"          <direction>out</direction>"
"          <relatedStateVariable>PhysicalLinkStatus</relatedStateVariable>"
"        </argument>"
"      </argumentList>"
"    </action>"
"    <action>"
"    <name>GetTotalBytesSent</name>"
"      <argumentList>"
"        <argument>"
"          <name>NewTotalBytesSent</name>"
"          <direction>out</direction>"
"          <relatedStateVariable>TotalBytesSent</relatedStateVariable>"
"        </argument>"
"      </argumentList>"
"    </action>"
"    <action>"
"    <name>GetTotalBytesReceived</name>"
"      <argumentList>"
"        <argument>"
"          <name>NewTotalBytesReceived</name>"
"          <direction>out</direction>"
"          <relatedStateVariable>TotalBytesReceived</relatedStateVariable>"
"        </argument>"
"      </argumentList>"
"    </action>"
"    <action>"
"    <name>GetTotalPacketsSent</name>"
"      <argumentList>"
"        <argument>"
"          <name>NewTotalPacketsSent</name>"
"          <direction>out</direction>"
"          <relatedStateVariable>TotalPacketsSent</relatedStateVariable>"
"        </argument>"
"      </argumentList>"
"    </action>"
"    <action>"
"    <name>GetTotalPacketsReceived</name>"
"      <argumentList>"
"        <argument>"
"          <name>NewTotalPacketsReceived</name>"
"          <direction>out</direction>"
"         <relatedStateVariable>TotalPacketsReceived</relatedStateVariable>"
"        </argument>"
"      </argumentList>"
"    </action>"
"	</actionList>"
"	<serviceStateTable>"
"		<stateVariable sendEvents=\"no\">"
"			<name>WANAccessType</name>"
"			<dataType>string</dataType>"
"			<allowedValueList>"
"				<allowedValue>DSL</allowedValue>"
"				<allowedValue>POTS</allowedValue>"
"				<allowedValue>Cable</allowedValue>"
"				<allowedValue>Ethernet</allowedValue>"
"				<allowedValue>Other</allowedValue>"
"			</allowedValueList>"
"		</stateVariable>"
"		<stateVariable sendEvents=\"no\">"
"			<name>Layer1UpstreamMaxBitRate</name>"
"			<dataType>ui4</dataType>"
"		</stateVariable>"
"		<stateVariable sendEvents=\"no\">"
"			<name>Layer1DownstreamMaxBitRate</name>"
"			<dataType>ui4</dataType>"
"		</stateVariable>"
"		<stateVariable sendEvents=\"yes\">"
"			<name>PhysicalLinkStatus</name>"
"			<dataType>string</dataType>"
"	  <allowedValueList>"
"        <allowedValue>Up</allowedValue>"
"        <allowedValue>Down</allowedValue>"
"        <allowedValue>Initializing</allowedValue>"
"        <allowedValue>Unavailable</allowedValue>"
"      </allowedValueList>"
"		</stateVariable>"
"    <stateVariable sendEvents=\"no\">"
"      <name>WANAccessProvider</name>"
"      <dataType>string</dataType>"
"    </stateVariable>"
"    <stateVariable sendEvents=\"no\">"
"      <name>MaximumActiveConnections</name>"
"      <dataType>ui2</dataType>"
"      <allowedValueRange>"
"        <minimum>1</minimum>"
"        <maximum></maximum>"
"        <step>1</step>"
"      </allowedValueRange>"
"    </stateVariable>"
"    <stateVariable sendEvents=\"no\">"
"      <name>TotalBytesSent</name>"
"      <dataType>ui4</dataType>"
"    </stateVariable>"
"    <stateVariable sendEvents=\"no\">"
"      <name>TotalBytesReceived</name>"
"      <dataType>ui4</dataType>"
"    </stateVariable>"
"    <stateVariable sendEvents=\"no\">"
"      <name>TotalPacketsSent</name>"
"      <dataType>ui4</dataType>"
"    </stateVariable>"
"    <stateVariable sendEvents=\"no\">"
"      <name>TotalPacketsReceived</name>"
"      <dataType>ui4</dataType>"
"    </stateVariable>"
"	</serviceStateTable>"
"</scpd>";


/**
 * Action listener for WAN Common Interface Config service 
 * Just see if the action is conformant with any service, in any IGD embedded device
 */
BOOL upnp_igd_common_ifcg_actionreceived(CgUpnpAction *action)
{
	char *actionName;
	CgUpnpService* service;

	actionName = cg_upnp_action_getname(action);
	service = cg_upnp_action_getservice(action);
	if (cg_strcmp(cg_upnp_service_getserviceid(service), "urn:upnp-org:serviceId:WANCommonIFC1") == 0) {
		if (cg_strcmp(actionName,"GetTotalBytesSent") == 0)
			return TRUE;
		else if (cg_strcmp(actionName,"GetTotalBytesReceived") == 0)
			return TRUE;
		else return FALSE;
	}

	return FALSE;
}

/**
 * upnp_igd_device_new
 */
CgUpnpDevice *upnp_igd_device_new(int leaseTime)
{
	CgUpnpDevice *igdDev, *wanDev;

	CgUpnpService *wanConfigService;
	 
	CgString *descURI = cg_string_new();
	cg_string_setvalue( descURI, "/" );
	cg_string_addvalue( descURI, IGD_DEVICE_DESCRIPTION_FILE_NAME );
	
	igdDev = cg_upnp_device_new();
	cg_upnp_device_setdescriptionuri( igdDev, cg_string_getvalue(descURI) );
	cg_upnp_device_setleasetime(igdDev, leaseTime);

	if (cg_upnp_device_parsedescription(igdDev, IGD_DEVICE_DESCRIPTION, cg_strlen(IGD_DEVICE_DESCRIPTION)) == FALSE) {
		cg_upnp_device_delete(igdDev);
		return NULL;
	}
	
	/* get the WANDevice child-device, from the IGD Device root node */
	wanDev = cg_upnp_device_getdevicebyexacttype(igdDev, "urn:schemas-upnp-org:device:WANDevice:1");
	
	/* get the WAN Common Interface Config service, from WANDevice */
	wanConfigService = cg_upnp_device_getservicebyserviceid(wanDev, "urn:upnp-org:serviceId:WANCommonIFC1");
	if (cg_upnp_service_parsedescription(wanConfigService, IGD_IFCG_SERVICE_DESCRIPTION, cg_strlen(IGD_IFCG_SERVICE_DESCRIPTION)) == FALSE) {
		cg_upnp_service_delete(wanConfigService);
		return NULL;
	}
	
	cg_upnp_service_setactionlistener(wanConfigService, upnp_igd_common_ifcg_actionreceived);

	return igdDev;
}

int main( int argc, char* argv[] )
{
	int leaseTime = 1800;
	CgUpnpDevice *igdDev = upnp_igd_device_new(leaseTime);
	
	if ( igdDev != NULL ){
		if ( cg_upnp_device_start(igdDev) == FALSE ) {
			fprintf( stderr, "IGD (simple) Device couldn't be started!\n" );
		} else {
			fprintf( stderr, "IGD (simple) Device started!\n" );
		}
	}
	
	printf(SYNC_STRING);
	fflush(NULL);
	getchar();

	cg_upnp_device_stop(igdDev);
	cg_upnp_device_delete(igdDev);

	return(0);
}
