#!/usr/bin/python

import re
import sys
import os
import shutil
from test import is_coverage, get_gcda

def build_dir(exe):
    t = get_gcda(exe)
    a = re.search("(/.*)/tests/regression/.*" ,t)
    return a.groups()[0]

def gen_cov_info(build_dir):
    if os.path.exists('coverage'):
        shutil.rmtree('coverage')
    os.mkdir('coverage')
    os.chdir('coverage')
    os.system('lcov -d ' + build_dir + ' -b ../ -z')
    os.system('lcov -d ' + build_dir + ' -b ../ -c -o clinkc.info')
    os.system('genhtml clinkc.info')

exe = 'mini_cp'
exe = '.libs/' + exe
if is_coverage(exe):
    bdir = build_dir(exe)
    gen_cov_info(bdir)
sys.exit(0)
