/*
 * This file is part of sp-response-time
 *
 * Copyright (C) 2005-2008 Nokia Corporation. 
 *
 * Contact: Eero Tamminen <eero.tamminen@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 
 * version 2 as published by the Free Software Foundation. 
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */ 

/**
   @file common.h

   Implementation of configuration operations
   <p>
*/

// TODO: create separate API for logging.

#ifndef COMMON_H_
#define COMMON_H_

#include <stdio.h>
#include <pthread.h>
#include <sys/time.h>

#include <X11/Xlib.h>

enum LogType { USE_STDERR, USE_STDOUT, USE_FILE };

#define HERE fprintf(stderr, "MARK: %s: %i: %s\n", __FILE__, __LINE__, __FUNCTION__);

typedef struct Rectangle {
	int x;
	int y;
	int width;
	int height;
} Rectangle;

Display* setup_display(char* dpy_name);

void log_error(const char* format, ...);
void log_message(const struct timeval timestamp, const char* format, ...);
void log_analysis_report(const struct timeval timestamp, const struct timeval event_occured, const struct timeval last_update_occured, Time update_time, const char *additional);
void init_logging(int log_type, const char* log_path);
void end_logging();

#endif //COMMON_H_
