/****************************************************************************
**
** Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the QtGui module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial Usage
** Licensees holding valid Qt Commercial licenses may use this file in
** accordance with the Qt Commercial License Agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and Nokia.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights.  These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3.0 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU General Public License version 3.0 requirements will be
** met: http://www.gnu.org/copyleft/gpl.html.
**
** If you have questions regarding the use of this file, please contact
** Nokia at qt-info@nokia.com.
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef QMENU_MAEMO5_P_H
#define QMENU_MAEMO5_P_H

#include <QtCore/qpair.h>
#include <QtCore/qlist.h>
#include <QtCore/qmap.h>
#include <QtCore/qpointer.h>
#include <QtGui/qdialog.h>

QT_BEGIN_HEADER

QT_BEGIN_NAMESPACE

QT_MODULE(Gui)

class QAction;
class QMenuBar;
class QGridLayout;
class QActionGroup;
class QButtonGroup;
class QHBoxLayout;
class QAbstractButton;

#if defined(Q_WS_MAEMO_5)

class QMaemo5ApplicationMenu : public QDialog
{
    Q_OBJECT

public:
    QMaemo5ApplicationMenu(QMenuBar *menubar);

    bool isEmpty() const;
    QAction *selectedAction() const;

protected:
    void paintEvent(QPaintEvent *);
    void showEvent(QShowEvent *);

private slots:
    void buttonClicked(bool);
    void actionChanged();
    void actionGroupDestroyed(QObject *actionGroup);

private:
    void recursiveAddActions(const QList<QAction *> &actions, QGridLayout *grid, int &row, int &col, int maxcol);

    QHBoxLayout *layoutForButton(QAbstractButton *button, QAction *action);

    QMap<QWidget *, QPointer<QAction> > m_actions;
    typedef QMap<QActionGroup *, QPair<QHBoxLayout *, QButtonGroup *> > GroupMap;
    GroupMap m_groups;
    QPointer<QAction> m_selected;
};

#endif

QT_END_NAMESPACE

QT_END_HEADER

#endif // QMENU_MAEMO_5_H
