/**
 * @folder.c folder handling
 *
 * Copyright (C) 2003,2004 Lars Lindner <lars.lindner@gmx.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _FOLDER_H
#define _FOLDER_H

#include <string.h>
#include "common.h"

typedef struct folder {
    gint type;
    gpointer *ui_data;
    gchar *title;
    gchar *id;
    gboolean nonremovable;
    gboolean root;
    gboolean expanded;
    gboolean dialog_mode_expanded;
    gint markCount;
} *folderPtr;

/* ------------------------------------------------------------ */
/* functions to create/change/remove folder         */
/* ------------------------------------------------------------ */

void folder_add_feed(folderPtr folder, struct feed *feed, gint position);

/**
 * Free's an empty folder, removing it from the feedlist if
 * necessary.
 *
 * @param folder the folder to remove
 */
void folder_free(folderPtr folder);

/* to create/delete folders */

/** Used to add a folder without adding it to the config 
  *
  * @param parent the parent folder
  * @param title title
  * @param id folder id
  * @param type type
  * @return pointer to the folder
  */
folderPtr restore_folder(folderPtr parent, gchar * title, gchar * id,
                         gint type);

/** Creates a root folder 
  *
  * @param title the title of the folder
  * @return pointer to the folder
  */
folderPtr create_root_folder(gchar * title);

/* to read/change folder properties */

/** Gets the folder id
  *
  * @param folder pointer to the folder
  * @return the id
  */
gchar *folder_get_id(folderPtr folder);

/** Gets the folder title
  *
  * @param folder pointer to the folder
  * @return the title
  */
gchar *folder_get_title(folderPtr folder);

/** Gets the nonremovable status of a folder
  *
  * @param folder pointer to the folder
  * @return TRUE if nonremovable
  */
gboolean folder_get_nonremovable(folderPtr folder);

/** Sets the folder title
  *
  * @param folder pointer to the folder
  * @param title the new title
  */
void folder_set_title(folderPtr folder, gchar * title);

/** Sets the collapse state of a folder
  *
  * @param folder pointer to the folder
  * @param collapsed the collapse state
  */
void folder_set_collapse_state(struct folder *folder, gboolean collapsed);

/** Sets the nonremovable status of a folder
  *
  * @param folder pointer to the folder
  * @param nonremovable the nonremovable status
  */
void folder_set_nonremovable(folderPtr folder, gboolean nonremovable);

#endif
