/**
 * @file ui_dnd.h everything concerning DnD
 *
 * Copyright (C) 2003, 2004 Lars Lindner <lars.lindner@gmx.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 * 
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _UI_DND_H
#define _UI_DND_H

#include <gtk/gtk.h>
#include <gdk/gdk.h>

G_BEGIN_DECLS
#define RSS_TYPE_FEED_TREE	(rss_feed_tree_get_type ())
#define RSS_FEED_TREE(obj)	(G_TYPE_CHECK_INSTANCE_CAST((obj), RSS_TYPE_FEED_TREE, RssFeedTree)
typedef struct _RssFeedTree RssFeedTree;
typedef struct _RssFeedTreeClass RssFeedTreeClass;

struct _RssFeedTree {
    GObject parent;
};

struct _RssFeedTreeClass {
    GObjectClass parent_class;
};

GType rss_feed_tree_get_type(void);

G_END_DECLS
/** sets up DnD for the feedlist model */
void ui_dnd_init(void);

/** sets up URL DnD support */
void ui_dnd_setup_URL_receiver(GtkWidget * mainwindow);

/** to catch drag end events and to do some postprocessing in the feedlist */
void on_feedlist_drag_end(GtkWidget * widget,
                          GdkDragContext * drag_context, gpointer user_data);

/** To catch drag begin events and to do some preprocessing to know which feed
  * or folder is being dragged
  */
void on_feedlist_drag_begin(GtkWidget * widget,
                            GdkDragContext * drag_context,
                            gpointer user_data);

void rss_feed_tree_drag_init(GtkTreeDragDestIface * iface,
                             gpointer user_data);

gboolean ui_dnd_drop_possible(GtkTreeModel * model, GtkTreePath * path);

void ui_dnd_receive_drag_data(GtkWidget * widget,
                              GdkDragContext * drag_context,
                              gint x,
                              gint y,
                              GtkSelectionData * data,
                              guint info, guint time, gpointer user_data);

gboolean ui_dnd_drag_drop(GtkWidget * widget,
                          GdkDragContext * drag_context,
                          gint x, gint y, guint time, gpointer user_data);

void ui_dnd_reparent(GtkTreeIter * from, nodePtr selected, nodePtr fptr,
                     gboolean copy, folderPtr new_folder);

#endif
