/**
 * @file ui_prefs.c program preferences
 *
 * Copyright (C) 2004 Nathan J. Conrad <t98502@users.sourceforge.net>
 * Copyright (C) 2004 Lars Lindner <lars.lindner@gmx.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <hildon/hildon-time-editor.h>

#include <osso-rss-feed-reader/settings.h>

#include "ui_prefs.h"
#include "appdata.h"

extern AppData *app_data;
extern Iphb_cb_data iphb_data; // Rama added

static gboolean settings_dialog_opened = FALSE;

/*------------------------------------------------------------------------------*/
/* preferences dialog callbacks                         */
/*------------------------------------------------------------------------------*/

void settings_dialog_close(void)
{
    if (settings_dialog_opened) {
        close_rss_settings();
    }
}

void on_prefbtn_clicked(GtkButton * button, gpointer user_data)
{
    g_assert(app_data);
    g_assert(app_data->app_ui_data);
    settings_dialog_opened = TRUE;
    execute_rss_settings(app_data->osso, app_data->app_ui_data->main_view,
                         TRUE, FALSE, &iphb_data);
    settings_dialog_opened = FALSE;
}
