/**
 * @file favicon_cache.c Liferea favicon handling
 * 
 * Copyright (C) 2004 Nathan J. Conrad <t98502@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <hildon/hildon-defines.h>

#include <glib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <osso-log.h>
#include <osso-rss-feed-reader/cache_handling.h>
#include <osso-rss-feed-reader/cache_favicon.h>

#include "favicon_cache.h"
#include "common.h"
#include "html.h"


/************************************************************************/
/*                        PUBLIC FUNCTIONS                              */
/************************************************************************/

void favicon_load(feedPtr fp)
{
    GdkPixbuf *pixbuf = NULL;

    pixbuf = rsslib_favicon_load((gchar *) feed_get_id(fp));

    if (pixbuf) {
        if (fp->icon != NULL)
            g_object_unref(fp->icon);
        fp->icon = pixbuf;
    }
    return;
}

void favicon_remove(feedPtr fp)
{
    rsslib_favicon_remove((gchar *) feed_get_id(fp));
    return;
}
