#ifndef _HTMLIMPORT_H
#define _HTMLIMPORT_H

#include <gtkhtml/gtkhtml.h>
#include <gtkhtml/gtkhtml-enums.h>

#define HTML_CHECK_TYPE(object, otype) ((object) \
                           && (HTML_OBJECT (object))->klass \
                           && (HTML_OBJECT (object))->klass->type == otype)
#define HTML_IS_IMAGE(x) (HTML_CHECK_TYPE ((x), HTML_TYPE_IMAGE))
#define HTML_IS_TEXT(x) (HTML_CHECK_TYPE ((x), HTML_TYPE_TEXT))
#define HTML_OBJECT(x) ((HTMLObject0 *) (x))
#define HTML_IMAGE0(x) ((HTMLImage0 *)(x))
#define HTML_IMAGE(x) ((HTMLImage *)(x))

//incomplete types!
typedef struct _HTMLObjectClass0 {
    HTMLType type;
} HTMLObjectClass0;

typedef struct _HTMLObject0 {
    HTMLObjectClass0 *klass;
    /* Pointer to the parent object.  */
    HTMLObject *parent;

    HTMLObject *prev;
    HTMLObject *next;

    HTMLChangeFlags change;

    gint x, y;

    gint ascent, descent;

    gint min_width;
    gint width;
    gint pref_width;
    gint max_width;

    gint percent;

    guchar flags;

    /* FIXME maybe unify with `flags'?  */
    guint redraw_pending:1;
    guint selected:1;

    /* If an object has a redraw pending and is being destroyed, this flag
     * is set to TRUE instead of g_free()ing the object.  When the draw
     * queue is flushed, the g_free() is performed.  */
    guint free_pending:1;

    /* FIXME add the other dynamic pusedo-classes... */
    guint draw_focused:1;

    GData *object_data;
    GData *object_data_nocp;

    char *id;
} HTMLObject0;

typedef struct _HTMLImagePointer0 {
    gint refcount;
    gchar *url;
} HTMLImagePointer0;

typedef struct _HTMLImage0 {
    HTMLObject0 object;
    HTMLImagePointer0 *image_ptr;
} HTMLImage0;

HTMLObject *html_engine_get_object_at(HTMLEngine * e, gint x, gint y,
                                      guint * offset_return,
                                      gboolean for_cursor);
HTMLObject *html_engine_get_focus_object(HTMLEngine * e, gint * offset);
gchar *html_object_get_url(HTMLObject * o, gint offset);
gboolean html_object_is_container(HTMLObject * self);
void html_object_calc_abs_position(HTMLObject * o, gint * x_return,
                                   gint * y_return);

void html_image_edit_set_url(HTMLImage * image, const gchar * url);

HTMLImageFactory *html_engine_get_image_factory(HTMLEngine * e);
void html_image_factory_cleanup(HTMLImageFactory * factory);
void html_image_factory_unref_all_images(HTMLImageFactory * factory);
void html_engine_set_focus_object(HTMLEngine * e, HTMLObject * o,
                                  gint offset);

void html_engine_select_region(HTMLEngine * e, gint x1, gint y1, gint x2,
                               gint y2);

#endif                          //_HTMLIMPORT_H
