/**
    @file cache_handling.h

    Copyright (c) 2004-2005 Nokia. All rights reserved.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
    02111-1307 USA
*/

#define __USE_XOPEN
#include <glib.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <time.h>


#ifndef __RSSLIB_CACHE_H__
#define __RSSLIB_CACHE_H__


G_BEGIN_DECLS

#define C_MAGICHEAD  0xCA204220
/* actual version of cache */
#define C_VERSION  4

#define VERSION_2 2
#define VERSION_3 3
#define VERSION_4 4

#define DEFAULT_MAX_ITEMS 100

#define READSTR str = cache_read_str(cache);
#define FREESTR if (str) {g_free(str); str=NULL;}
#define RETURN_IF_ERROR {fclose(cache); save_data->cache=NULL; cache=NULL; g_free(filename); g_free(filename_temp); unlink(filename_temp); return FALSE;}

typedef enum cache_limit {
    /* Values > 0 are used to specify certain limits */
    CACHE_DISABLE = 0,
    CACHE_DEFAULT = -1,
    CACHE_UNLIMITED = -2,
} rsslib_cache_limit;


typedef struct _rsslib_cache_init_data rsslib_cache_init_data;
typedef struct _rsslib_cache_item_data rsslib_cache_item_data;

struct _rsslib_cache_init_data 
{
    FILE *cache;
    gchar *id;
    gchar *feed_title;
    gchar *feed_source;
    gchar *feed_description;
    gchar *feed_image_url;
    glong feed_available;
    gboolean feed_discontinued;
    glong feed_added;
	time_t feed_last_modifed;
    glong feed_newest_post;
    glong feed_read;
    gint saveMaxCount;
    gboolean fhp_null;
    gboolean is_directory;
    gint ver;
    gint pos;
    gint size;
    GSList *feed_items;
};



struct _rsslib_cache_item_data
{
    gchar *item_title;
    gchar *item_description;
    gchar *item_source;
    gchar *item_real_source_title;
    gchar *item_real_source_url;
    gchar *item_id;
    gulong nr;
    gboolean item_read_status;
    gboolean marked;
    gulong item_time;
    gboolean on_server;
    GSList *enclosure_metadata;
};

struct enclosure_attribute {
  gchar *ul;
  gchar *type;
  gint length;
};

gboolean cache_read_boolean(FILE * cache);

long cache_read_long(FILE * cache);

/** Reads a string from a file
  *
  * @param cache the file to read from
  */
gchar *cache_read_str(FILE * cache);


/** Reads an integer from a file
  *
  * @param cache the file to read from
  */
int cache_read_int(FILE * cache);

gboolean cache_write_boolean(FILE * cache, gboolean data);
gboolean cache_write_long(FILE * cache, long data);

/** Writes a string to a file
  *
  * @param cache the file to write
  * @param string the string to write
  */
gboolean cache_write_str(FILE * cache, const gchar * string);


/** Writes an integer to a file
  *
  * @param cache the file to write
  * @param data the integer to write
  */
gboolean cache_write_int(FILE * cache, int data);


void rsslib_cache_item_data_free(rsslib_cache_item_data *item);

void rsslib_cache_init_data_free(rsslib_cache_init_data *init_data);

rsslib_cache_item_data *rsslib_cache_get_next_item(rsslib_cache_init_data *init_data);

rsslib_cache_init_data *rsslib_cache_open_file(gchar *fname);

gboolean rsslib_cache_save_feed(rsslib_cache_init_data *save_data,gboolean just_empty_items);





gchar *common_get_cache_path(void);

gchar *common_create_cache_filename(const gchar * folder,
				    const gchar * key,
				    const gchar * extension);


G_END_DECLS

#endif
