/**
	@file interface.h

	File implementing the user interface for RSS Feed Reader Settings
	
	Copyright (c) 2004-2007 Nokia Corporation.
	Parts of code are from Liferea.
	Liferea (C) 2003,2004 Lars Lindner <lars.lindner@gmx.net>

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License 
	version 2 or later, as published by the Free Software Foundation. 

	This program is distributed in the hope that it will be useful, but
	WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
	02110-1301 USA
*/

#ifndef __INTERFACE_H__
#define __INTERFACE_H__

#include <gtk/gtk.h>
#include <libosso.h>
#include <gconf/gconf-client.h>
#include "settings.h"

#ifdef __cplusplus 
extern "C" { 
#endif

extern gboolean ui_interface_kill_softly_only;
extern GConfClient* gconf;
extern size_t cache_size;

/**
	Creates the settings dialog
	
	@param window	The parent window, for which the dialog is made
			modal to.
	@return The created main dialog or NULL, if creation failed.
*/
GtkWidget* ui_create_settings_dialog(osso_context_t *osso_context,
                                     gpointer window, gboolean modal,
                                     gboolean executed_from_applet,
				     Iphb_cb_data *iphb_data);

/**

	Refreshes the UI by fetching the appropriate values from 
	SettingsDatabase and showing them in UI.
*/
void ui_refresh(void);

/**
	Destroyes the UI and frees all memory occupied by it.
*/
void ui_destroy(void);

void ui_reset_cache(int value);

gboolean ui_activate_dialog();

void ui_enable_widgets(gboolean enable);

#ifdef __cplusplus 
}
#endif
#endif /* __INTERFACE_H__ */
