/**
  @file interface.c

  User Interface (Representation module).

  Copyright (c) 2004-2007 Nokia Corporation.
  Parts of code are from Liferea.
  Liferea (C) 2003,2004 Lars Lindner <lars.lindner@gmx.net>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License 
  version 2 or later, as published by the Free Software Foundation. 

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
  02110-1301 USA
  
*/

#include <stdio.h>
#include <libosso.h>
#include <osso-log.h>

#include <gtk/gtk.h>
#include <assert.h>

#include "callbacks.h"
#include "interface.h"
#include "settings_database.h"
#include "i18n.h"

#include <hildon/hildon-caption.h>
#include <hildon/hildon-helper.h>

#define RSS_NEWS_READER_HELP_SETTINGS "Applications_RssReader_settingsdialog"
#define PREF_DIALOG_X_SIZE 500

/* Main dialog related stuff */
GtkWidget* global_dialog = NULL;
GtkWidget *cacheSizePulldown = NULL;
GtkWidget *automaticUpdatesBtn = NULL;
//GtkWidget *automaticScrollingBtn = NULL;
GtkWidget *connTypePulldown = NULL;
GtkWidget *connIntervalPulldown = NULL;
GtkWidget *openFeedsToPulldown = NULL;

gboolean ui_interface_kill_softly_only = FALSE;

GConfClient* gconf = NULL;
size_t cache_size = 0;

static
gboolean is_hw_wimax_capable(void);

// global functions

GtkWidget* ui_create_settings_dialog(osso_context_t *osso_context,
                                     gpointer window, gboolean modal,
                                     gboolean executed_from_applet,
				     Iphb_cb_data *iphb_data)
{
    /* Initialize local stuff */

    GtkWidget *notebook;
    GtkWidget *dialog_vbox13;
    GtkWidget *propTable;
    GtkWidget *titleLabel;
    /*
    GtkWidget *dialog_action_area;
    */
    GtkWidget *prefokbtn;

    notebook = gtk_notebook_new();

    GtkSizeGroup *group =
        GTK_SIZE_GROUP(gtk_size_group_new(GTK_SIZE_GROUP_HORIZONTAL));

    global_dialog = gtk_dialog_new();
    gtk_window_set_title(GTK_WINDOW(global_dialog), _("rss_ti_settings"));
    gtk_window_set_default_size(GTK_WINDOW(global_dialog), PREF_DIALOG_X_SIZE, -1);
    gtk_window_set_type_hint(GTK_WINDOW(global_dialog),
            GDK_WINDOW_TYPE_HINT_DIALOG);
    if (window)
        gtk_window_set_transient_for(GTK_WINDOW(global_dialog),
                GTK_WINDOW(window));
    if (modal)
        gtk_window_set_modal(GTK_WINDOW(global_dialog), TRUE);
    gtk_dialog_set_has_separator(GTK_DIALOG(global_dialog), FALSE);

    dialog_vbox13 = GTK_DIALOG(global_dialog)->vbox;
    /* gtk_widget_show(dialog_vbox13); */

    gtk_container_add(GTK_CONTAINER(dialog_vbox13), notebook);
    gtk_widget_show(notebook);


    /*Updating Feeds tab*/
    propTable = gtk_vbox_new(FALSE, 0);
    gtk_widget_show(propTable);
    gtk_notebook_append_page( GTK_NOTEBOOK( notebook ),
                              GTK_WIDGET( propTable ),
                              gtk_label_new( _("rss_ti_updating") ) );


    automaticUpdatesBtn = gtk_check_button_new ();
    gtk_widget_show(automaticUpdatesBtn);

    titleLabel = hildon_caption_new(group, _("rss_ia_update_feeds_automatically"),    
                    automaticUpdatesBtn, NULL,
                    HILDON_CAPTION_OPTIONAL);
//    gtk_misc_set_alignment(GTK_MISC(titleLabel), 0, 0.5);
    gtk_widget_show(titleLabel);
    gtk_box_pack_start(GTK_BOX(propTable), titleLabel, FALSE,FALSE,2);

    connTypePulldown = gtk_combo_box_new_text();

    /* first option depends on existance of WIMAX capability */
    gtk_combo_box_append_text(GTK_COMBO_BOX(connTypePulldown),
//                    is_hw_wimax_capable() ?
//                        _("rss_va_update_when_connected_wimax") :
                        _("rss_va_update_when_connected_wlan"));
    gtk_combo_box_append_text(GTK_COMBO_BOX(connTypePulldown),
                    _("rss_va_update_when_connected_any"));
    gtk_combo_box_set_active(GTK_COMBO_BOX(connTypePulldown), 0);
    gtk_widget_show(GTK_WIDGET(connTypePulldown));

    titleLabel = hildon_caption_new(group, _("rss_ia_update_when_connected"),
                    connTypePulldown, NULL,
                    HILDON_CAPTION_OPTIONAL);
    gtk_widget_show(titleLabel);
    gtk_box_pack_start(GTK_BOX(propTable), titleLabel, FALSE,FALSE,2);

//    g_signal_connect((gpointer) connTypePulldown, "event",
//            G_CALLBACK(on_mainfeedlist_button_press_event), NULL);
    hildon_helper_set_insensitive_message(GTK_WIDGET( connTypePulldown), 
      _("rss_ib_feed_auto_update_disabled"));

    cacheSizePulldown = gtk_combo_box_new_text();
    gtk_combo_box_append_text(GTK_COMBO_BOX(cacheSizePulldown),
            _("rss_va_img_cache_1"));
    gtk_combo_box_append_text(GTK_COMBO_BOX(cacheSizePulldown),
            _("rss_va_img_cache_2"));
    gtk_combo_box_append_text(GTK_COMBO_BOX(cacheSizePulldown),
            _("rss_va_img_cache_4"));
    gtk_combo_box_append_text(GTK_COMBO_BOX(cacheSizePulldown),
            _("rss_va_img_cache_8"));
    gtk_combo_box_append_text(GTK_COMBO_BOX(cacheSizePulldown),
            _("rss_va_img_cache_off"));
    gtk_combo_box_set_active(GTK_COMBO_BOX(cacheSizePulldown), 0);
    gtk_widget_show(GTK_WIDGET(cacheSizePulldown));

    titleLabel = hildon_caption_new(group, _("rss_ia_img_cache_size"),
                    cacheSizePulldown, NULL,
                    HILDON_CAPTION_OPTIONAL);
    gtk_widget_show(titleLabel);
    gtk_box_pack_start(GTK_BOX(propTable), titleLabel, FALSE,FALSE,2);

    connIntervalPulldown = gtk_combo_box_new_text();
    gtk_combo_box_append_text(GTK_COMBO_BOX(connIntervalPulldown),
                    _("rss_va_update_interval_15"));
    gtk_combo_box_append_text(GTK_COMBO_BOX(connIntervalPulldown),
                    _("rss_va_update_interval_30"));
    gtk_combo_box_append_text(GTK_COMBO_BOX(connIntervalPulldown),
                    _("rss_va_update_interval_1"));
    gtk_combo_box_append_text(GTK_COMBO_BOX(connIntervalPulldown),
                    _("rss_va_update_interval_2"));
    gtk_combo_box_append_text(GTK_COMBO_BOX(connIntervalPulldown),
                    _("rss_va_update_interval_4"));
    gtk_combo_box_append_text(GTK_COMBO_BOX(connIntervalPulldown),
                    _("rss_va_update_interval_8"));
    gtk_combo_box_set_active(GTK_COMBO_BOX(connIntervalPulldown), 0);
    gtk_widget_show(GTK_WIDGET(connIntervalPulldown));

    titleLabel = hildon_caption_new(group, _("rss_ia_update_interval"),
                    connIntervalPulldown, NULL,
                    HILDON_CAPTION_OPTIONAL);
    gtk_widget_show(titleLabel);
    gtk_box_pack_start(GTK_BOX(propTable), titleLabel, FALSE,FALSE,2);

//    g_signal_connect((gpointer) connIntervalPulldown, "event",
//            G_CALLBACK(on_mainfeedlist_button_press_event), NULL);
    hildon_helper_set_insensitive_message(GTK_WIDGET(connIntervalPulldown),
      _("rss_ib_feed_auto_update_disabled"));

//    GTK_WIDGET_SET_FLAGS(prefokbtn, GTK_CAN_DEFAULT);

    g_signal_connect(G_OBJECT(cacheSizePulldown), "changed",
            G_CALLBACK(combobox_changed), S_CACHE_SIZE);
    g_signal_connect(G_OBJECT(connTypePulldown), "changed",
            G_CALLBACK(combobox_changed), S_CONN_TYPE);
    g_signal_connect(G_OBJECT(connIntervalPulldown), "changed",
            G_CALLBACK(combobox_changed), S_CONN_INTERVAL);

    g_signal_connect(G_OBJECT(automaticUpdatesBtn), "toggled",
            G_CALLBACK(checkbox_toggled), S_AUTOMATIC_UPDATES);

    
    /*RSS Home Applet tab*/
    propTable = gtk_vbox_new(FALSE, 0);
    gtk_widget_show(propTable);
    gint applet_tab_index = 
        gtk_notebook_append_page(GTK_NOTEBOOK(notebook),
                                 GTK_WIDGET( propTable ),
                                 gtk_label_new(_("rss_ti_home_applet")));

#if 0
    automaticScrollingBtn = gtk_check_button_new ();
    gtk_widget_show(automaticScrollingBtn);

    titleLabel = hildon_caption_new(group, _("rss_fi_automatic_scrolling"),
                    automaticScrollingBtn, NULL,
                    HILDON_CAPTION_OPTIONAL);
//    gtk_misc_set_alignment(GTK_MISC(titleLabel), 0, 0.5);
    gtk_widget_show(titleLabel);
    gtk_box_pack_start(GTK_BOX(propTable), titleLabel, FALSE,FALSE,2);
#endif
    
    openFeedsToPulldown = gtk_combo_box_new_text();
    gtk_combo_box_append_text(GTK_COMBO_BOX(openFeedsToPulldown),
                    _("rss_va_open_posts_to_rss") );
    gtk_combo_box_append_text(GTK_COMBO_BOX(openFeedsToPulldown),
                    _("rss_va_open_posts_to_web") );
    gtk_combo_box_set_active(GTK_COMBO_BOX(openFeedsToPulldown), 0);
    gtk_widget_show(GTK_WIDGET(openFeedsToPulldown));

    titleLabel = hildon_caption_new(group, _("rss_fi_open_posts_to"),
                    openFeedsToPulldown, NULL,
                    HILDON_CAPTION_OPTIONAL);
    gtk_widget_show(titleLabel);
    gtk_box_pack_start(GTK_BOX(propTable), titleLabel, FALSE,FALSE,2);

    g_signal_connect(G_OBJECT(openFeedsToPulldown), "changed",
            G_CALLBACK(combobox_changed), S_OPEN_FEEDS_TO);
#if 0    
    g_signal_connect(G_OBJECT(automaticScrollingBtn), "toggled",
            G_CALLBACK(checkbox_toggled), S_AUTOMATIC_SCROLLING);
#endif    

/*NB#104707*/
#if 0
    /*Dialog control buttons*/
    dialog_action_area = GTK_DIALOG(global_dialog)->action_area;
    gtk_widget_show(dialog_action_area);
    gtk_button_box_set_layout(GTK_BUTTON_BOX(dialog_action_area),
                    GTK_BUTTONBOX_END);

#endif    
#ifdef DIAL_BUTTONSIZE
    prefokbtn = gtk_button_new_with_label(dgettext("hildon-libs", "wdgt_bd_save"));
    gtk_widget_show(prefokbtn);
    gtk_dialog_add_action_widget(GTK_DIALOG(global_dialog), prefokbtn,
                GTK_RESPONSE_OK);
#endif

    prefokbtn = gtk_dialog_add_button(GTK_DIALOG(global_dialog), dgettext("hildon-libs", "wdgt_bd_save"), GTK_RESPONSE_OK);	

    g_signal_connect(G_OBJECT(global_dialog), "key-press-event",
            G_CALLBACK(dialog_key_press), (gpointer)(iphb_data));

    g_signal_connect(G_OBJECT(global_dialog), "response",
            G_CALLBACK(on_dialog_response), (gpointer)(iphb_data));
    

//    gtk_widget_grab_default(prefokbtn);

    if (executed_from_applet)
    {
        gtk_notebook_set_current_page(GTK_NOTEBOOK( notebook ),
                                      applet_tab_index);
    }

    return global_dialog;
}


void ui_refresh(void)
{
    Value *value = NULL;
    gboolean automaticUpdates = FALSE;
   
    if (global_dialog == NULL) {
        ULOG_DEBUG("ui_refresh(): global_dialog == NULL, nothing to show yet");    
        return;
       
    }
    
    value = settings_get_value(S_CACHE_SIZE);
    if (value && value->type == TYPE_INTEGER) 
        gtk_combo_box_set_active(GTK_COMBO_BOX(cacheSizePulldown),
                     value->integer);
    
    value = settings_get_value(S_AUTOMATIC_UPDATES);
    if (value && value->type == TYPE_BOOLEAN)
    {
      
      gboolean result = value->boolean;
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON
                         (automaticUpdatesBtn), result);
        automaticUpdates = result;
    }

    value = settings_get_value(S_CONN_TYPE);
    if (value && value->type == TYPE_INTEGER) 
        gtk_combo_box_set_active(GTK_COMBO_BOX(connTypePulldown),
                     value->integer);
    
    value = settings_get_value(S_CONN_INTERVAL);
    if (value && value->type == TYPE_INTEGER) 
        gtk_combo_box_set_active(GTK_COMBO_BOX(connIntervalPulldown),
                     value->integer);

#if 0
    value = settings_get_value(S_AUTOMATIC_SCROLLING);
    if (value && value->type == TYPE_BOOLEAN)
    {
      
      gboolean result = value->boolean;
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON
                         (automaticScrollingBtn), result);
    }
#endif    

    value = settings_get_value(S_OPEN_FEEDS_TO);
    if (value && value->type == TYPE_INTEGER) 
        gtk_combo_box_set_active(GTK_COMBO_BOX(openFeedsToPulldown),
                     value->integer);
    
    ui_enable_widgets(automaticUpdates);
}


void ui_destroy(void)
{
	gboolean bIsAlive = FALSE;
	if (global_dialog == NULL) return;
	
	bIsAlive = GTK_IS_WIDGET(global_dialog);
	
	if ( ! bIsAlive ) {
		/* Deadmeat */
		global_dialog = NULL;
		return;
	} else {
        gtk_widget_destroy(global_dialog);
        global_dialog = NULL;
        settings_destroy();
        g_object_unref(gconf);
        gconf = NULL;
        //gtk_dialog_response(GTK_DIALOG(global_dialog),GTK_RESPONSE_DELETE_EVENT);
	}


	if ( ui_interface_kill_softly_only )
	{
		return;
	}

	/* Destroy dialogs, if they exist */
	if (global_dialog != NULL) {
		
		bIsAlive = GTK_IS_WIDGET(global_dialog);
		if ( bIsAlive ) {
			gtk_widget_destroy(global_dialog); 
			global_dialog = NULL;
		}
	}
	return;
}

void ui_reset_cache(int value)
{
    gtk_widget_grab_focus(cacheSizePulldown);
    gtk_combo_box_set_active(GTK_COMBO_BOX(cacheSizePulldown), value);
    
    Value v;
    v.type = TYPE_INTEGER;
    v.integer = value;
    settings_set_value(S_CACHE_SIZE, &v);
}

gboolean ui_activate_dialog()
{
    if (global_dialog && GTK_IS_WIDGET(global_dialog))
    {
        ui_refresh();
        gtk_widget_show(GTK_DIALOG(global_dialog)->vbox);
        gtk_dialog_run(GTK_DIALOG(global_dialog));
        return TRUE;
    }
    else
        return FALSE;
}

void ui_enable_widgets(gboolean enable)
{
    gtk_widget_set_sensitive(connTypePulldown, enable);
    gtk_widget_set_sensitive(connIntervalPulldown, enable);
}

static
gboolean is_hw_wimax_capable(void)
{
    const gchar *hwtype = g_getenv("OSSO_PRODUCT_HARDWARE");

    if (hwtype && strcmp(hwtype, "RX-48") == 0)
        return TRUE;

    return FALSE;
}
