#!/usr/bin/perl -w

my $filename = $ARGV[0];

my %exist_trans = ();

open(FILE, "bookmark-translations.h");
while(my $line=<FILE>)
{
    if ($line=~/\#define\s+(.*)\s+\"(.*)\"/)
    {
	$exist_trans{$2} = $1;
    }
}
close(FILE);

open(FILE, $filename);
while(my $line=<FILE>)
{
    if ($line=~/\_\(\"(.*)\"/)
    {
	$value = $1;
	$name = $exist_trans{$value};
	if (!$name)
	{
#	    print "Not Found: $value\n";
	}
	else
	{
	    $line=~s/\"$value\"/$name/g;
#	    print "Changed $value to $name t\n";
	}
    }
    print $line;
}
close(FILE);


