/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 tw=80 et cindent: */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#ifndef __MicrobEalCertificate_h
#define __MicrobEalCertificate_h

#include "nsIDOMEventListener.h"
#include "nsISSLCertErrorDialog.h"

class nsIDOMWindow;

// 0b389baa-439c-456d-8e5b-f3cc76792ec5
#define MICROB_NSSDIALOGS_CID \
  {0x0b389baa, 0x439c, 0x456d, \
      { 0x8e, 0x5b, 0xf3, 0xcc, 0x76, 0x79, 0x2e, 0xc5 }}

class MicrobEalCertificate : public nsIDOMEventListener,
                             public nsISSLCertErrorDialog
{
    public:
        NS_DECL_ISUPPORTS
        NS_DECL_NSIDOMEVENTLISTENER
        NS_DECL_NSISSLCERTERRORDIALOG

        MicrobEalCertificate();
        ~MicrobEalCertificate();

        nsresult Init();
        nsresult SetUp(nsISupports *aTarget);
        nsresult UnSetup(nsISupports *aTarget);

    private:
        nsresult OutOfHere();
        nsresult ExceptionDialog();
        PRBool mDialogOpen;
};

#endif /* __MicrobEalCertificate_h */
