/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the MICROB EAL package.
 *
 * The Initial Developer of the Original Code is Nokia Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contact: Oleg Romashin <oleg.romashin@nokia.com>
 *
 * ***** END LICENSE BLOCK ***** */

#ifndef __GMOZILLAPLUGINLIST_H__
#define __GMOZILLAPLUGINLIST_H__

#include <gwebpluginlist.h>

G_BEGIN_DECLS

/* GMozillaPluginList */

#define G_TYPE_MOZILLA_PLUGIN_LIST             (g_mozilla_plugin_list_get_type ())
#define G_MOZILLA_PLUGIN_LIST(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), G_TYPE_MOZILLA_PLUGIN_LIST, GMozillaPluginList))
#define G_MOZILLA_PLUGIN_LIST_CLASS(vtable)    (G_TYPE_CHECK_CLASS_CAST ((vtable), G_TYPE_MOZILLA_PLUGIN_LIST, GMozillaPluginListClass))
#define G_IS_MOZILLA_PLUGIN_LIST(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), G_TYPE_MOZILLA_PLUGIN_LIST))
#define G_IS_MOZILLA_PLUGIN_LIST_CLASS(vtable) (G_TYPE_CHECK_CLASS_TYPE ((vtable), G_TYPE_MOZILLA_PLUGIN_LIST))
#define G_MOZILLA_PLUGIN_LIST_GET_CLASS(inst)  (G_TYPE_INSTANCE_GET_INTERFACE ((inst), G_TYPE_MOZILLA_PLUGIN_LIST, GMozillaPluginListClass))

typedef struct _GMozillaPluginList GMozillaPluginList;
typedef struct _GMozillaPluginListClass GMozillaPluginListClass;

struct _GMozillaPluginList
{
    GObject parent;

    GList *items;
    gint num_items;
};

typedef enum 
{
    COMPONENT = 0,
    SYS_COMPONENT,
    PLUGIN
} PluginType;

struct _GMozillaPluginListClass
{
    GObjectClass parent;
};

GType g_mozilla_plugin_list_get_type (void);

GObject* g_mozilla_plugin_list_new (void);

gboolean g_mozilla_plugin_get_item_status (gchar *filename);

gboolean g_mozilla_plugin_set_item_status (gchar *name, gboolean enabled);

gboolean g_mozilla_plugin_disable_plugins (GSList **plugin_list);

gboolean g_mozilla_plugin_enable_plugins (GSList **plugin_list);

G_END_DECLS

#endif /* __GMOZILLAPLUGINLIST_H__ */
