/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 tw=80 et cindent: */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla's Element Optimizeing extension.
 *
 * The Initial Developer of the Original Code is the Mozilla Foundation.
 * Portions created by the Initial Developer are Copyright (C) 2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Oleg Romashin <romaxa@gmail.com> (original author)
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#ifndef __MICROBEMBEDXULAPPINFO_H__
#define __MICROBEMBEDXULAPPINFO_H__

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include "nsCOMPtr.h"
#include "nsICategoryManager.h"
#include "nsMemory.h"
#include "nsIServiceManager.h"
#include "nsIGenericFactory.h"
#include "nsIObserverService.h"
#include "nsIObserver.h"
#include "nsIPref.h"
#include "nsXULAppAPI.h"
#include "nsIXULAppInfo.h"
#include "nsIXULRuntime.h"
#include "nsStringGlue.h"
#include "nsIComponentRegistrar.h"
#include "nsILocalFile.h"
#include "prenv.h"

#define EMBED_XULAPPINFO_SERVICE_CONTRACTID \
  "@mozilla.org/xre/app-info;1"

/* Override nsAppRunner nsXULAppInfo */
// {95d89e3e-a169-41a3-8e56-719978e15b12}
#define EMBED_XULAPPINFO_CID \
  { 0x95d89e3e, 0xa169, 0x41a3, { 0x8e, 0x56, 0x71, 0x99, 0x78, 0xe1, 0x5b, 0x12 } }

/**
 * The EmbedXulAppInfo object implements nsIFactory so that it can be its own
 * singleton.
 */
class EmbedXulAppInfo : public nsIXULAppInfo,
                        public nsIXULRuntime
{
public:
  NS_DECL_ISUPPORTS_INHERITED
  NS_DECL_NSIXULAPPINFO
  NS_DECL_NSIXULRUNTIME
};

static PRBool gSafeMode = PR_FALSE;
static PRBool gLogConsoleErrors = PR_FALSE;
static nsXREAppData* gEmbedXulAppData = nsnull;
static PRInt32 gRefCounter = 0;

NS_INTERFACE_MAP_BEGIN(EmbedXulAppInfo)
  NS_INTERFACE_MAP_ENTRY_AMBIGUOUS(nsISupports, nsIXULRuntime)
  NS_INTERFACE_MAP_ENTRY(nsIXULRuntime)
  NS_INTERFACE_MAP_ENTRY_CONDITIONAL(nsIXULAppInfo, gEmbedXulAppData)
NS_INTERFACE_MAP_END


NS_IMETHODIMP_(nsrefcnt)
EmbedXulAppInfo::AddRef()
{
  if (!gRefCounter++) {
    nsresult rv;
    nsCOMPtr<nsILocalFile> appini;

    char *appDataFile = PR_GetEnv("MOZ_EMBED_APP_INI");
    if (appDataFile)
      rv = XRE_GetFileFromPath(appDataFile, getter_AddRefs(appini));
    else {
      rv = XRE_GetFileFromPath("/etc/gre.d/application.ini", getter_AddRefs(appini));
      if (NS_FAILED(rv)) {
        printf("\n\tWARNING: \"MOZ_EMBED_APP_INI\" env variable not found\n\n");
        return 1;
      }
    }

    if (NS_FAILED(rv)) {
      printf("Invalid path found: '%s'", appDataFile);
      return 1;
    }

    rv = XRE_CreateAppData(appini, &gEmbedXulAppData);
    if (NS_FAILED(rv)) {
      NS_WARNING("Couldn't read application.ini");
      return 1;
    }
  }

  return 1;
}

NS_IMETHODIMP_(nsrefcnt)
EmbedXulAppInfo::Release()
{
  if (!--gRefCounter && gEmbedXulAppData) {
    XRE_FreeAppData(gEmbedXulAppData);
    delete this;
  }
  return 1;
}

NS_IMETHODIMP
EmbedXulAppInfo::GetVendor(nsACString& aResult)
{
  aResult.Assign(nsCString(gEmbedXulAppData->vendor));
  return NS_OK;
}

NS_IMETHODIMP
EmbedXulAppInfo::GetName(nsACString& aResult)
{
  aResult.Assign(nsCString(gEmbedXulAppData->name));
  return NS_OK;
}

NS_IMETHODIMP
EmbedXulAppInfo::GetID(nsACString& aResult)
{
  aResult.Assign(nsCString(gEmbedXulAppData->ID));
  return NS_OK;
}

NS_IMETHODIMP
EmbedXulAppInfo::GetVersion(nsACString& aResult)
{
  aResult.Assign(nsCString(gEmbedXulAppData->version));
  return NS_OK;
}

NS_IMETHODIMP
EmbedXulAppInfo::GetPlatformVersion(nsACString& aResult)
{
  aResult.Assign(TOOLKIT_EM_VERSION);
  return NS_OK;
}

NS_IMETHODIMP
EmbedXulAppInfo::GetAppBuildID(nsACString& aResult)
{
  aResult.Assign(nsCString(gEmbedXulAppData->buildID));
  return NS_OK;
}

NS_IMETHODIMP
EmbedXulAppInfo::GetPlatformBuildID(nsACString& aResult)
{
  aResult.Assign(BUILD_ID);
  return NS_OK;
}

NS_IMETHODIMP
EmbedXulAppInfo::GetLogConsoleErrors(PRBool *aResult)
{
  *aResult = gLogConsoleErrors;
  return NS_OK;
}

NS_IMETHODIMP
EmbedXulAppInfo::SetLogConsoleErrors(PRBool aValue)
{
  gLogConsoleErrors = aValue;
  return NS_OK;
}

NS_IMETHODIMP
EmbedXulAppInfo::GetInSafeMode(PRBool *aResult)
{
  *aResult = gSafeMode;
  return NS_OK;
}

NS_IMETHODIMP
EmbedXulAppInfo::GetOS(nsACString& aResult)
{
  aResult.Assign(OS_TARGET);
  return NS_OK;
}

NS_IMETHODIMP
EmbedXulAppInfo::GetXPCOMABI(nsACString& aResult)
{

#ifdef TARGET_XPCOM_ABI
  aResult.Assign(TARGET_XPCOM_ABI);
  return NS_OK;
#else
  return NS_ERROR_NOT_AVAILABLE;
#endif
}

NS_IMETHODIMP
EmbedXulAppInfo::GetWidgetToolkit(nsACString & aResult)
{
  aResult.AssignLiteral(MOZ_WIDGET_TOOLKIT);
  return NS_OK;
}

#endif  // __MICROBEMBEDXULAPPINFO_H__
