/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* vim:expandtab:shiftwidth=4:tabstop=4: */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "common.h"
#include <nsISidebar.h>
#include <nsIClassInfoImpl.h>
#include <nsIGenericFactory.h>

#define MICROB_EAL_SIDEBAR_EXT_DESCRIPTION "MicroB Sidebar External"
#define MICROB_EAL_SIDEBAR_EXT_CID {0x1f4f709b, 0xcbb7, 0x49cf, {0xba, 0x5f, 0x1a, 0x77, 0xb7, 0x61, 0xc6, 0x2b}}

class MicrobEalSidebarExternal : public nsISidebarExternal,
                                 public nsIClassInfo
{
public:
    MicrobEalSidebarExternal();
    virtual ~MicrobEalSidebarExternal();

    static NS_METHOD RegisterSelf(nsIComponentManager* aCompMgr,
                                  nsIFile* aPath,
                                  const char* aRegistryLocation,
                                  const char* aComponentType,
                                  const nsModuleComponentInfo* aInfo);
 
    static NS_METHOD UnregisterSelf(nsIComponentManager* aCompMgr,
                                    nsIFile* aPath,
                                    const char* aRegistryLocation,
                                    const nsModuleComponentInfo* aInfo);
    
    NS_DECL_ISUPPORTS
    NS_DECL_NSISIDEBAREXTERNAL
    NS_DECL_NSICLASSINFO
};
