/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the MICROB EAL package.
 *
 * The Initial Developer of the Original Code is Nokia Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contact: Oleg Romashin <oleg.romashin@nokia.com>
 *
 * ***** END LICENSE BLOCK ***** */

#ifndef GMOZILLA_CONNECTIVITY_H_
#define GMOZILLA_CONNECTIVITY_H_

#include <glib.h>
#include "gmozillaweb.h"

#ifdef USE_GCONF
#include <gconf/gconf-client.h>
#endif

#ifdef USE_OSSOIC
#include <osso-ic.h>
#include <osso-ic-gconf.h>
#endif

#define GCONF_PROXY "/system/proxy"
#define GCONF_HTTP_PROXY "/system/http_proxy"

#define G_MOZILLA_PROXY_NONE "none"
#define G_MOZILLA_PROXY_AUTO "auto"
#define G_MOZILLA_PROXY_MANUAL "manual"

#ifdef USE_CONIC

/** Verify the connectivity between OSSO IC and the engine
  * @param data Generic pointer (e.g. web engine)
  */
gboolean g_mozilla_connectivity_connect(gpointer data, gboolean reconnect);

void g_mozilla_connectivity_set_global(GMozillaWeb *self);

void g_mozilla_connectivity_unset_global(GMozillaWeb *self);

gboolean g_mozilla_connectivity_check_buggy();

#endif

gboolean g_mozilla_connectivity_is_connected();

/** Set the proxy if it is necessary
  */
gboolean g_mozilla_connectivity_set_proxy ();

#endif
