/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the MICROB EAL package.
 *
 * The Initial Developer of the Original Code is Nokia Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contact: Oleg Romashin <oleg.romashin@nokia.com>
 *
 * ***** END LICENSE BLOCK ***** */

#ifndef COMMON_H
#define COMMON_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <gtk/gtk.h>
#include <stdlib.h>
#include <libintl.h>
#include <locale.h>
#include <gdk/gdkkeysyms.h>

#define OSSOLOG_COMPILE 1
#include <osso-log.h>

#undef ULOG_INFO_F
#undef ULOG_CRIT_F
#undef ULOG_WARN_F
#undef ULOG_ERR_F
#undef ULOG_DEBUG_F

//#define MOZEAL_LOGGING 1

#ifdef MOZEAL_LOGGING
#define ULOG(FMT, ARG...) printf(\
     "MEAL:%s:%d: " FMT "\n", __FUNCTION__, __LINE__, ## ARG)
#define ULOG_DEBUG_F(FMT, ARG...) printf(\
     "MOZMOZEAL:%s:%d: " FMT "\n", __FUNCTION__, __LINE__, ## ARG)
#define ULOG_CRIT_F(FMT, ARG...) printf(\
     "MOZMOZEAL:%s:%d: " FMT "\n", __FUNCTION__, __LINE__, ## ARG)
#define ULOG_INFO_F(FMT, ARG...) printf(\
     "MOZMOZEAL:%s:%d: " FMT "\n", __FUNCTION__, __LINE__, ## ARG)
#define ULOG_WARN_F(FMT, ARG...) printf(\
     "MOZMOZEAL:%s:%d: " FMT "\n", __FUNCTION__, __LINE__, ## ARG)
#define ULOG_ERR_F(FMT, ARG...) printf(\
     "MOZMOZEAL:%s:%d: " FMT "\n", __FUNCTION__, __LINE__, ## ARG)
#define TRACE_LOG(FMT, ARG...) pr_mozeal_trace(\
     "MOZEAL_TRACE:%s:%s:%d: " FMT "\n", __FILE__, __FUNCTION__, __LINE__, ## ARG)
void
pr_mozeal_trace (const char *fmt, ...);
#else
#       define ULOG_DEBUG_F(...) do {} while (0)
#       define ULOG_CRIT_F(...) do {} while (0)
#       define ULOG_INFO_F(...) do {} while (0)
#       define ULOG_WARN_F(...) do {} while (0)
#       define ULOG_ERR_F(...) do {} while (0)
#       define TRACE_LOG(...) do {} while (0)
#       define ULOG(...) do {} while (0)
#endif

#define ULOGA(FMT, ARG...) printf(\
     "EXTR_LOG:%s:%s:%d: " FMT "\n", __FILE__, __FUNCTION__, __LINE__, ## ARG)

#define MOZILLA_DEFAULT_VENDOR_NAME                     "Firefox/3.5"

#define G_MOZILLA_PREF_UI_STRING                        "general.useragent.extra.simple"
#define G_MOZILLA_PREF_EAL_NAME                         "general.useragent.vendor"
#define G_MOZILLA_PREF_EAL_VER                          "general.useragent.vendorSub"
#define G_MOZILLA_PREF_EAL_MILESTONE                    "general.useragent.vendorComment"
#define G_MOZILLA_PREF_EAL_LOCALE                       "general.useragent.locale"
#define G_MOZILLA_PREF_PLUGINS_DIR                      "MOZ_PLUGIN_PATH"
#define G_MOZILLA_PREF_MEMORY_CACHE_SIZE                "browser.cache.memory.capacity"
#define G_MOZILLA_PREF_DISPLAY_FRAME_BORDER             "layout.frames.force_resizability"
#define G_MOZILLA_PREF_WEB_ADDRESS_SUFFIXES             "browser.fixup.alternate.suffix"
#define G_MOZILLA_PREF_HOME_PAGE_LOCATION               "browser.startup.homepage"
#define G_MOZILLA_PREF_USE_DEFAULT_HOME_PAGE            "browser.startup.use_default_homepage"
#define G_MOZILLA_PREF_ENABLE_SSL2                      "security.enable_ssl2"
#define G_MOZILLA_PREF_ENABLE_PLUGINS                   "plugin.default_plugin_disable"
#define G_MOZILLA_PREF_ENABLE_JAVA_SCRIPT               "javascript.enabled"
#define G_MOZILLA_PREF_ENABLE_JAVA                      "security.enable_java"
#define G_MOZILLA_PREF_SECURE_ENTER                     "security.warn_entering_secure"
#define G_MOZILLA_PREF_SECURE_LEAVE                     "security.warn_leaving_secure"
#define G_MOZILLA_PREF_SECURE_SUBMIT                    "security.warn_submit_insecure"
#define G_MOZILLA_PREF_ENABLE_POPUP_WINDOWS             "privacy.popups.policy"
#define G_MOZILLA_PREF_OPEN_POPUP_DURING_LOAD           "dom.disable_open_during_load"
#define G_MOZILLA_PREF_ACCEPT_COOKIES                   "network.cookie.alwaysAcceptSessionCookies"
#define G_MOZILLA_PREF_COOKIE_LIFETIMEPOLICY            "network.cookie.lifetimePolicy"
#define G_MOZILLA_PREF_COOKIE_BEHAVIOUR                 "network.cookie.cookieBehavior"
#define G_MOZILLA_PREF_COOKIE_WARN_ABOUT_COOKIES        "network.cookie.warnAboutCookies"
#define G_MOZILLA_PREF_COOKIE_LIFETIME_POLICY           "network.cookie.lifetimePolicy"
#define G_MOZILLA_PREF_SHOW_IMAGES                      "permissions.default.image"
#define G_MOZILLA_PREF_OFFLINE_BROWSER                  "network.online"
#define G_MOZILLA_PREF_LANGUAGE                         "intl.accept_languages"
#define G_MOZILLA_PREF_PROXY_TYPE                       "network.proxy.type"
#define G_MOZILLA_PREF_HTTP_PROXY                       "network.proxy.http"
#define G_MOZILLA_PREF_HTTP_PROXY_PORT                  "network.proxy.http_port"
#define G_MOZILLA_PREF_HTTPS_PROXY                      "network.proxy.ssl"
#define G_MOZILLA_PREF_HTTPS_PROXY_PORT                 "network.proxy.ssl_port"
#define G_MOZILLA_PREF_FTP_PROXY                        "network.proxy.ftp"
#define G_MOZILLA_PREF_FTP_PROXY_PORT                   "network.proxy.ftp_port"
#define G_MOZILLA_PREF_AUTOCONFIG_URL_PROXY             "network.proxy.autoconfig_url"
#define G_MOZILLA_PREF_OMITTED_HOSTS_PROXY              "network.proxy.no_proxies_on"
#define G_MOZILLA_PREF_REDIRECTION_DEFAULT_LIMIT        20
#define G_MOZILLA_PREF_REDIRECTION_LIMIT                "network.http.redirection-limit"
#define G_MOZILLA_PREF_SPATIAL_NAVIGATION               "snav.keyCode.modifier"
#define G_MOZILLA_PREF_WIDGETUTILS_ENABLED              "webaddon.widgetutils.enabled"
#define G_MOZILLA_PREF_WIDGETUTILS_BLOCK                "webaddon.widgetutils.block"
#define G_MOZILLA_PREF_WIDGETUTILS_MONOMODE             "webaddon.widgetutils.monomode"
#define G_MOZILLA_PREF_WIDGETUTILS_MONOKINETIC          "webaddon.widgetutils.monoKinetic"
#define G_MOZILLA_PREF_WIDGETUTILS_ABSORBMOUSEDOWN      "webaddon.widgetutils.absorbMouseDown"
#define G_MOZILLA_PREF_WIDGETUTILS_PLUGINSUPPORT        "webaddon.widgetutils.pluginSupport"
#define G_MOZILLA_PREF_USE_FOCUS_COLOR                  "browser.display.use_focus_colors"
#define G_MOZILLA_PREF_FOCUS_TEXT_COLOR                 "browser.display.focus_text_color"
#define G_MOZILLA_PREF_FOCUS_BACKGROUND_COLOR           "browser.display.focus_background_color"
#define G_MOZILLA_PREF_FOCUS_RING_WIDTH                 "browser.display.focus_ring_width"
#define G_MOZILLA_PREF_JSFOCUS_FOR_VISIBLE_AREA         "browser.display.jsfocus_for_visible_area"
#define G_MOZILLA_PREF_AUTOMATIC_FORM_FILL              "browser.formfill.enable"
#define G_MOZILLA_PREF_FORCE_AUTOCOMPLETION             "signon.forceAutocompletion"
#define G_MOZILLA_PREF_REMEMBER_PASSWORDS               "signon.rememberPasswords"
#define G_MOZILLA_PREF_REMEMBER_SIGNONS                 "signon.rememberSignons"
#define G_MOZILLA_PREF_PASSWORDS_SAVING                 "signon.rememberSignons"
#define G_MOZILLA_PREF_SIGNON_FILE                      "signon.SignonFileName"
#define G_MOZILLA_PREF_BROWSER_HISTORY_EXPIRE_DAYS      "browser.history_expire_days"
#define G_MOZILLA_PREF_SSR_ENABLED                      "ftv.enabled"
#define G_MOZILLA_PREF_MERGE_FRAMES                     "merge.frames.enabled"
#define G_MOZILLA_PREF_IMAGE_ZOOM_ENABLED               "imagezoom.enabled"
#define G_MOZILLA_PREF_IDENTIFY_AS                      "to do"
#define G_MOZILLA_PREF_USER_UA_ADD                      "general.useragent.user.add"
#define G_MOZILLA_PREF_XUL_ERROR_PAGE                   "browser.xul.error_pages.enabled"
#define G_MOZILLA_PREF_GNOMEVFS_SUPPORT                 "network.gnomevfs.supported-protocols"
#define G_MOZILLA_PREF_PRESERVE_ZOOM_NAV_CHANGE         "browser.shistory.preservezoom"
#define G_MOZILLA_PREF_PANNING_SENS                     "gtkmozembed.mscroll.step"
#define G_MOZILLA_PREF_AUTOMATIC_IMAGE_RESIZING         "browser.enable_automatic_image_resizing"
// NOTE: microb.download_images is handled in microbImageLoadingPolicy.js
#define G_MOZILLA_PREF_DOWNLOAD_IMAGES                  "microb.download_images"
#define G_MOZILLA_PREF_WIDGET_FORCE_24BPP               "mozilla.widget.force-24bpp"
#define G_MOZILLA_PREF_GFX_FORCE_OFFSCR_IMAGE           "mozilla.gfx.force.image.offscreen"
#define G_MOZILLA_PREF_FORCE_WMODE                      "plugins.force.wmode"
#define G_MOZILLA_PREF_WMODE_OPAQUE                     "opaque"
#define G_MOZILLA_PREF_BLOCK_ZOOM_ENABLED               "block-zoom.block-zoom-enabled"
#define G_MOZILLA_PREF_WIDGET_DISABLE                   "mozilla.widget.not-active"
#define G_MOZILLA_PREF_WIDGET_NOT_REALIZED              "mozilla.widget.not-realized"
#define G_MOZILLA_PREF_PLUGINS_FLASHBACK                "plugins.flashhack"
#define G_MOZILLA_PREF_PLUGINS_ENABLE_SUSPENDING        "plugins.enableSuspending"
#define G_MOZILLA_PREF_SNAV_IGNORE_TEXT_FIELDS          "snav.ignoreTextFields"
#define G_MOZILLA_PREF_SNAV_DISABLE_JS                  "snav.disableJS"
#define G_MOZILLA_PREF_SNAV_BLOCK                       "snav.block"
#define G_MOZILLA_PREF_ACCESSIBILITY_TABFOCUS           "accessibility.tabfocus"
#define G_MOZILLA_PREF_SNAV_ENABLED                     "snav.enabled"
#define G_MOZILLA_PREF_LAYOUT_FULL_ZOOM_MODE_FAST       "layout.full.zoom.mode.fast"
#define G_MOZILLA_PREF_LAYOUT_FULL_TRUE_ZOOM_MODE       "layout.full.true.zoom.mode"
#define G_MOZILLA_PREF_WIDGET_ALLOW_NATIVE_THEME        "mozilla.widget.allow_native_theme"
#define G_MOZILLA_PREF_DM_SHOW_ALERTCOMPLETE            "browser.download.manager.showAlertOnComplete"
#define G_MOZILLA_PREF_EXTENSIONS_GETADDONS_SHOWPANE    "extensions.getAddons.showPane"
#define G_MOZILLA_PREF_XUL_DOWNLOAD_MGR_SHOW            "browser.download.manager.showWhenStarting"
#define G_MOZILLA_PREF_SUSPEND_IMAGES                   "microb.suspend_images"
#define G_MOZILLA_PREF_SUSPEND_JAVASCRIPT               "microb.suspend_javascript"
#define G_MOZILLA_PREF_SUSPEND_PLUGINS                  "microb.suspend_plugins"
#define G_MOZILLA_PREF_SUSPEND_NATIVE                   "microb.suspend_native"
#define G_MOZILLA_PREF_EXPAND_FRAMES                    "microb.expand_frames"
#define G_MOZILLA_PREF_SHRINK_BUFFER                    "microb.shrink.buffer"
#define G_MOZILLA_PREF_SHRINK_TIMEOUT                   "microb.shrink.buffer.timeout"
#define G_MOZILLA_PREF_BUFFER_DEF_WIDTH                 "microb.buffer.height"
#define G_MOZILLA_PREF_BUFFER_DEF_HEIGHT                "microb.buffer.width"
#define G_MOZILLA_PREF_HIDE_FIXED_FRAMES                "microb.hide_fixed_frames"
#define G_MOZILLA_PREF_LAYOUT_CSS_DPI                   "layout.css.dpi"

#define G_MOZILLA_LOCAL_HOST_IP                         "127.0.0.1"
#define G_MOZILLA_TRANSLATE_CONNECTIVITY_ERROR          "Network Connection Error"
#define G_MOZILLA_MEMORY_PRESSURE                       "memory-pressure"
#define G_MOZILLA_CHROME_FLAGS                          "chrome_flags"
#define G_MOZILLA_HEAP_MINIMIZE_UNICODE                 "h\0e\0a\0p\0-\0m\0i\0n\0i\0m\0i\0z\0e\0\0"
#define G_MOZILLA_FOCUS_OUT                             "__focus_out__"
#define G_MOZILLA_ENGINE_CLEAN_AUTH                     "engine_clean_auth"
#define G_MOZILLA_SNAV_BLOCK_DEFAULTS                   "http://www.google.com/reader http://docs.google.com"
#define G_MOZILLA_WIDGETUTILS_BLOCK_DEFAULT             "http://maps.google.com/"
#define G_MOZILLA_ACCESSIBILITY_TABFOCUS_DEFAULT        1
#define G_MOZILLA_WEB_ADDRESS_SUFFIXES                  ".com .org"
#define G_MOZILLA_GNOMEVFS_SUPPORT                      "smb:,obex:,upnpav:"
#define G_MOZILLA_RESOURCES                             "urn:mozilla:item:"
#define G_MOZILLA_LANG_SHORT_DEFAULT                    "en"
#define G_MOZILLA_EAL_LOCALE_DEFAULT                    "US"
#define G_MOZILLA_SHOW_IMAGES_DEFAULT                   1
#define G_MOZILLA_PANNING_SENSITIVITY_DEFAULT           5
#define G_MOZILLA_LANG                                  "LANG"
#define G_MOZILLA_HOME                                  "HOME"
#define G_MOZILLA_BRVIEW_DBUS                           "BRVIEW_DBUS" 
#define G_MOZILLA_LC_MESSAGES                           "LC_MESSAGES"
#define G_MOZILLA_MOZ_ENABLE_XSHM                       "MOZ_ENABLE_XSHM"
#define G_MOZILLA_MOZ_DISABLE_XEMBED                    "MOZ_DISABLE_XEMBED"
#define G_MOZILLA_INTERNAL_EXTENSIONS_DIR               "MOZILLA_INTERNAL_EXTENSIONS_DIR"
#define G_MOZILLA_COMP_PATH_OVVERRIDE                   "MOZ_COMP_PATH_OVERRIDE"
#define G_MOZILLA_PROFILE_OVERRIDE                      "MOZ_PROFILE_OVERRIDE"
#define G_MOZILLA_INTERNAL_PLUGINS_DIR                  "MOZILLA_INTERNAL_PLUGINS_DIR"
#define G_MOZILLA_DISABLE_SIG_HANDLER                   "MOZ_DISABLE_SIG_HANDLER"
#define G_MOZILLA_MICROB_PROFILE_PATH                   "MOZ_MICROB_PROFILE_PATH"
#define G_MOZILLA_SIGNON_FILE_DEFAULT                   "passwords.s"
#define G_MOZILLA_BROWSER_HISTORY_EXPIRE_DAYS_DEFAULT   30
#define G_MOZILLA_BROWSER_NAME_DEFAULT                  "osso_browserd"
#define G_MOZILLA_WEB_NAME_DEFAULT                      "gweb"
#define G_MOZILLA_NEW_WINDOW_ORPHAN                     "new_window_orphan"
#define G_MOZILLA_MICROB_PROFILE_PATH_NAME_DEFAULT      "MOZ_MICROB_PROFILE_PATH"
#define G_MOZILLA_EXTENSIONS_FILENAME_DEFAULT           "microb/extensions.ini"
#define G_MOZILLA_EXTENSIONS_FILENAME_NEW_DEFAULT       "microb/extensions.ini.temp"
#define G_MOZILLA_EXTENSION_NAME_PARAM                  "Extension%i=%s\n"
#define G_MOZILLA_THUMBNAIL_FILENAME_PARAM              "%s/browser_thumbnails/thumbnail_%d/"
#define G_MOZILLA_THUMBNAILS_DIRNAME_PARAM              "%s/browser_thumbnails"
#define G_MOZILLA_COMPREG_FILENAME_PARAM                "%s/.mozilla/microb/compreg.dat"
#define G_MOZILLA_XPTI_FILENAME_PARAM                   "%s/.mozilla/microb/xpti.dat"
#define G_MOZILLA_APP_STARTUP                           "app-startup"
#define G_MOZILLA_QUIT_APPLICATION                      "quit-application"
#define G_MOZILLA_QUIT_APPLICATION_REQUESTED            "quit-application-requested"
#define G_MOZILLA_QUIT_APPLICATION_GRANTED              "quit-application-granted"
#define G_MOZILLA_PAINT_LISTENER                        "paint_listener"
#define G_MOZILLA_ENGINE_CLEAN_AUTH                     "engine_clean_auth"
#define G_MOZILLA_CERTIFICATE_LISTENER                  "cert_listener"
#define G_MOZILLA_MICROB_EAL_OBSERVER                   "MicrobEalObserver"
#define G_MOZILLA_MICROB                                "microb"
#define G_MOZILLA_XPCOM_SHUTDOWN                        "xpcom-shutdown"
#define G_MOZILLA_RESTART                               "restart"
#define G_MOZILLA_COMPONENTS                            "components"
#define G_MOZILLA_RESTART_REQUIRED                      "restart_required"
#define G_MOZILLA_START_LOADING                         "start_loading"
#define G_MOZILLA_FINISHED_LOADING                      "finished_loading"
#define G_MOZILLA_HTTP_PROXY                            "http_proxy"
#define G_MOZILLA_FTP_PROXY                             "ftp_proxy"
#define G_MOZILLA_HTTPS_PROXY                           "https_proxy"
#define G_MOZILLA_PROFILE_CHANGE_NET_TEARDOWN           "profile-change-net-teardown"
#define G_MOZILLA_PROFILE_CHANGE_NET_RESTORE            "profile-change-net-restore"
#define G_MOZILLA_CONNECTION_EVENT                      "connection-event"
#define G_MOZILLA_AUTOMATIC_CONNECTION_EVENTS           "automatic-connection-events"
#define G_MOZILLA_HTTP                                  "http"
#define G_MOZILLA_FTP                                   "ftp"
#define G_MOZILLA_SSL                                   "ssl"
#define G_MOZILLA_URL_PREFIX_HTTP                       "http://"
#define G_MOZILLA_URL_PREFIX_HTTPS                      "https://"
#define G_MOZILLA_URL_PREFIX_FTP                        "ftp://"
#define G_MOZILLA_URL_PREFIX_LOCAL                      "file://"
#define G_MOZILLA_IAP_STATE_IDLE                        "IDLE"
#define G_MOZILLA_IAP_STATE_CONNECTED                   "CONNECTED"
#define G_MOZILLA_IAP_STATE_CONNECTING                  "CONNECTING"
#define G_MOZILLA_NETWORK_PROXY_PARAM_PORT              "network.proxy.%s_port"
#define G_MOZILLA_NETWORK_PROXY_PARAM                   "network.proxy.%s"
#define G_MOZILLA_EAL_PARENT                            "eal_parent"
#define G_MOZILLA_EAL_CTX_TYPE                          "eal_ctx_type"
#define G_MOZILLA_GLOBAL                                "global"
#define G_MOZILLA_UI                                    "ui"
#define G_MOZILLA_SET_IMAGES_SCALING                    "set_images_scaling"
#define G_MOZILLA_SCROLL_TO_LAST_NODE                   "scrool_to_last_node"
#define G_MOZILLA_OPTIMIZED_VIEW                        "optimized_view"
#define G_MOZILLA_IMAGE_SURFACE_DEPTH                   "microb.img.surface-bpp"


#define G_MOZILLA_CLIENT_OBSERVER_CONTRACTID            "@browser/engine-client-observer;1"
#define G_MOZILLA_DOWNLOAD_MANAGER_CONTRACTID           "@mozilla.org/download-manager;1"
#define G_MOZILLA_OBSERVER_SERVICE_CONTRACTID           "@mozilla.org/observer-service;1"
#define G_MOZILLA_EXTENSIONS_MANAGER_CONTRACTID         "@mozilla.org/extensions/manager;1"
#define G_MOZILLA_RDF_SERVICE_CONTRACTID                "@mozilla.org/rdf/rdf-service;1"
#define G_MOZILLA_NETWORK_IO_SERVICE_CONTRACTID         "@mozilla.org/network/io-service;1"
#define G_MOZILLA_EXTENSIONS_IMAGEZOOM_CONTRACTID       "@mozilla.org/extensions/imagezoom;1"
#define G_MOZILLA_EXTENSIONS_FTV_CONTRACTID             "@mozilla.org/extensions/ftv;1"

/* Helper Macros */

#define EAL_BEGIN_MACRO do {
#define EAL_END_MACRO   } while (0)


#define EAL_GFREE_FUNC(_ptr, _func)    \
  EAL_BEGIN_MACRO                      \
      _func(_ptr);                     \
      (_ptr) = NULL;                   \
  EAL_END_MACRO

#define EAL_IF_GFREE_FUNC(_ptr, _func) \
  EAL_BEGIN_MACRO                      \
    if (_ptr != 0) {                   \
      _func(_ptr);                     \
      (_ptr) = 0;                      \
    }                                  \
  EAL_END_MACRO

#define EAL_GFREE(_ptr) EAL_GFREE_FUNC(_ptr, g_free)
#define EAL_IF_GFREE(_ptr) EAL_IF_GFREE_FUNC(_ptr, g_free)

#endif
