
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the MICROB EAL package.
 *
 * The Initial Developer of the Original Code is Nokia Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contact: Oleg Romashin <oleg.romashin@nokia.com>
 *
 * ***** END LICENSE BLOCK ***** */



#include "testgmozillapassman.h"
#include "tests_common.h"

#include <assert.h>
#include <Automated.h>

#include <stdio.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "common.h"
#include "gmozillapassman.h"
#include "gmozillacppwrapper.h"

typedef struct {
    GList* logins_list;
    guint size;
} TestHelpData;

typedef struct {
    GType expected_retvalue;
} GMozillaPasswordManagerGetTypeStruct;
typedef struct {
    gchar* server;
    gint index;
    GList* logins_list;
    GObject* expected_retvalue;
} GMozillaPasswordManagerLoginNewStruct;
typedef struct {
    GMozillaPasswordManager** test_self_pp;
    GMozillaPasswordManager* self;
    gchar*  test_username_variable;
    gchar** username;
    GWebStatus expected_retvalue;
    GWebPasswordManagerIface* iface;
} IfaceGMozillaPasswordManagerGetLoginUsernameStruct;
typedef struct {
    GMozillaPasswordManager** test_self_pp;
    GMozillaPasswordManager* self;
    gchar*  test_password_variable;
    gchar** password;
    GWebStatus expected_retvalue;
    GWebPasswordManagerIface* iface;
} IfaceGMozillaPasswordManagerGetLoginPasswordStruct;
typedef struct {
    GMozillaPasswordManager** test_self_pp;
    GMozillaPasswordManager* self;
    GObject* expected_retvalue;
    GWebPasswordManagerIface* iface;
} IfaceGMozillaPasswordManagerLoginGetPersonalDataStruct;

typedef struct {
    gboolean automatic;
    gboolean basics;
    TestHelpData help_data;
    TestTableData g_mozilla_password_manager_get_type;
    TestTableData g_mozilla_password_manager_login_new;
    TestTableData iface_g_mozilla_password_manager_get_login_username;
    TestTableData iface_g_mozilla_password_manager_get_login_password;
    TestTableData iface_g_mozilla_password_manager_login_get_personal_data;
} TestData;
TestData testdata;
static void init_test_data()
{
    testdata.automatic = FALSE;
    testdata.basics = FALSE;

    g_list_free(testdata.g_mozilla_password_manager_get_type.table);
    testdata.g_mozilla_password_manager_get_type.table = NULL;
    testdata.g_mozilla_password_manager_get_type.index = -1;

    g_list_free(testdata.g_mozilla_password_manager_login_new.table);
    testdata.g_mozilla_password_manager_login_new.table = NULL;
    testdata.g_mozilla_password_manager_login_new.index = -1;

    g_list_free(testdata.iface_g_mozilla_password_manager_get_login_username.table);
    testdata.iface_g_mozilla_password_manager_get_login_username.table = NULL;
    testdata.iface_g_mozilla_password_manager_get_login_username.index = -1;

    g_list_free(testdata.iface_g_mozilla_password_manager_get_login_password.table);
    testdata.iface_g_mozilla_password_manager_get_login_password.table = NULL;
    testdata.iface_g_mozilla_password_manager_get_login_password.index = -1;

    g_list_free(testdata.iface_g_mozilla_password_manager_login_get_personal_data.table);
    testdata.iface_g_mozilla_password_manager_login_get_personal_data.table = NULL;
    testdata.iface_g_mozilla_password_manager_login_get_personal_data.index = -1;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_mozilla_password_manager_get_type(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_password_manager_get_type");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.g_mozilla_password_manager_get_type.index;
        printf("Index of test data: %i\n", test_index);
        GMozillaPasswordManagerGetTypeStruct* test_item_data =
            (GMozillaPasswordManagerGetTypeStruct*)g_list_nth_data(testdata.g_mozilla_password_manager_get_type.table, test_index);
        testdata.g_mozilla_password_manager_get_type.index++;
        GType retvalue;
        if(testdata.basics) {
            retvalue = g_mozilla_password_manager_get_type();
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            GType expected_retvalue = test_item_data->expected_retvalue;
            retvalue = g_mozilla_password_manager_get_type();
            CU_ASSERT_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_mozilla_password_manager_login_new(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_password_manager_login_new");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.g_mozilla_password_manager_login_new.index;
        printf("Index of test data: %i\n", test_index);
        GMozillaPasswordManagerLoginNewStruct* test_item_data =
            (GMozillaPasswordManagerLoginNewStruct*)g_list_nth_data(testdata.g_mozilla_password_manager_login_new.table, test_index);
        testdata.g_mozilla_password_manager_login_new.index++;
        const gchar* server = test_item_data->server;
        gint index = test_item_data->index;
        GList* logins_list = test_item_data->logins_list;
        GObject* retvalue;
        if(testdata.basics) {
            retvalue = g_mozilla_password_manager_login_new(server,index,logins_list);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            GObject* expected_retvalue = test_item_data->expected_retvalue;
            retvalue = g_mozilla_password_manager_login_new(server,index,logins_list);
            CU_ASSERT_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

void test_iface_g_mozilla_password_manager_get_login_username(void)
{
    DEBUG_FUNCTIONS_STARTED("g_mozilla_password_manager_get_login_username");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.iface_g_mozilla_password_manager_get_login_username.index;
        printf("Index of test data: %i\n", test_index);
        IfaceGMozillaPasswordManagerGetLoginUsernameStruct* test_item_data =
            (IfaceGMozillaPasswordManagerGetLoginUsernameStruct*)g_list_nth_data(testdata.iface_g_mozilla_password_manager_get_login_username.table, test_index);
        testdata.iface_g_mozilla_password_manager_get_login_username.index++;

        GMozillaPasswordManager* self = test_item_data->self;
        gchar* test_username_variable = test_item_data->test_username_variable;
        gchar** username = test_item_data->username;
        GWebStatus retvalue;
        GWebPasswordManagerIface* iface = test_item_data->iface;
        if(testdata.basics) {
            if(iface != NULL)
            {
                retvalue = iface->get_login_username(G_WEB_PASSWORD_MANAGER(self), username);
                CU_PASS("Basic interface test!");
                printf("Basic interface test runned.\n");
            }
            else
            {
                printf("Basic interface: No interface to call through, function not called!!!\n");
                CU_FAIL("Basic interface: No interface to call through!!!");
            }
        }
        /*
        else
        {
            if(iface != NULL)
            {
                GWebStatus expected_retvalue = test_item_data->expected_retvalue
                retvalue = iface->get_login_username(G_WEB_PASSWORD_MANAGER(self), username);
                CU_ASSERT_EQUAL(retvalue, expected_retvalue);
                printf("Advanced test runned.\n");
            }
            else
            {
                CU_FAIL("Advance interface: No interface to call through!!!");
            }
        }
        */
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

void test_iface_g_mozilla_password_manager_get_login_password(void)
{
    DEBUG_FUNCTIONS_STARTED("g_mozilla_password_manager_get_login_password");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.iface_g_mozilla_password_manager_get_login_password.index;
        printf("Index of test data: %i\n", test_index);
        IfaceGMozillaPasswordManagerGetLoginPasswordStruct* test_item_data =
            (IfaceGMozillaPasswordManagerGetLoginPasswordStruct*)g_list_nth_data(testdata.iface_g_mozilla_password_manager_get_login_password.table, test_index);
        testdata.iface_g_mozilla_password_manager_get_login_password.index++;

        GMozillaPasswordManager* self = test_item_data->self;
        gchar* test_password_variable = test_item_data->test_password_variable;
        gchar** password = test_item_data->password;
        GWebStatus retvalue;
        GWebPasswordManagerIface* iface = test_item_data->iface;
        if(testdata.basics) {
            if(iface != NULL)
            {
                printf("testing login!!\n");
                if(!self->login)
                {
                    printf("login not found!!\n");
                }
                printf("about to call!!\n");
                retvalue = iface->get_login_password(G_WEB_PASSWORD_MANAGER(self), password);
                CU_PASS("Basic interface test!");
                printf("Basic interface test runned.\n");
            }
            else
            {
                printf("Basic interface: No interface to call through, function not called!!!\n");
                CU_FAIL("Basic interface: No interface to call through!!!");
            }
        }
        /*
        else
        {
            if(iface != NULL)
            {
                GWebStatus expected_retvalue = test_item_data->expected_retvalue
                retvalue = iface->get_login_password(G_WEB_PASSWORD_MANAGER(self), password);
                CU_ASSERT_EQUAL(retvalue, expected_retvalue);
                printf("Advanced test runned.\n");
            }
            else
            {
                CU_FAIL("Advance interface: No interface to call through!!!");
            }
        }
        */
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

void test_iface_g_mozilla_password_manager_login_get_personal_data(void)
{
    DEBUG_FUNCTIONS_STARTED("g_mozilla_password_manager_login_get_personal_data");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.iface_g_mozilla_password_manager_login_get_personal_data.index;
        printf("Index of test data: %i\n", test_index);
        IfaceGMozillaPasswordManagerLoginGetPersonalDataStruct* test_item_data =
            (IfaceGMozillaPasswordManagerLoginGetPersonalDataStruct*)g_list_nth_data(testdata.iface_g_mozilla_password_manager_login_get_personal_data.table, test_index);
        testdata.iface_g_mozilla_password_manager_login_get_personal_data.index++;

        GMozillaPasswordManager* self = test_item_data->self;
        GObject* retvalue;
        GWebPasswordManagerIface* iface = test_item_data->iface;
        if(testdata.basics) {
            if(iface != NULL)
            {
                retvalue = iface->login_get_personal_data(G_WEB_PASSWORD_MANAGER(self));
                CU_PASS("Basic interface test!");
                printf("Basic interface test runned.\n");
            }
            else
            {
                printf("Basic interface: No interface to call through, function not called!!!\n");
                CU_FAIL("Basic interface: No interface to call through!!!");
            }
        }
        /*
        else
        {
            if(iface != NULL)
            {
                GObject* expected_retvalue = test_item_data->expected_retvalue
                retvalue = iface->login_get_personal_data(G_WEB_PASSWORD_MANAGER(self), username);
                CU_ASSERT_EQUAL(retvalue, expected_retvalue);
                printf("Advanced test runned.\n");
            }
            else
            {
                CU_FAIL("Advance interface: No interface to call through!!!");
            }
        }
        */
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * Init function created by test creation script. It is success always.
 */
static int
testgmozillapassman_automatic_init()
{
    INIT_OR_CLEAN_STARTED("testgmozillapassman_init");
    //init_test_data();
    testdata.automatic = TRUE;
    return 0;
}

/**
 * Clean function created by test creation script. It is success always.
 */
static int
testgmozillapassman_automatic_clean()
{
    INIT_OR_CLEAN_STARTED("testgmozillapassman_clean");
    testdata.automatic = FALSE;
    return 0;
}

/**
 * Init function created by test creation script. It is success always.
 */
static int
testgmozillapassman_basics_init()
{
    INIT_OR_CLEAN_STARTED("testgmozillapassman_basics_init");
    g_type_init();
    init_test_data();
    testdata.basics = TRUE;
    
    GMozillaPasswordManagerGetTypeStruct* tmp_g_mozilla_password_manager_get_type = g_new0(GMozillaPasswordManagerGetTypeStruct, 1);
    /* GType */tmp_g_mozilla_password_manager_get_type->expected_retvalue = 0;
    testdata.g_mozilla_password_manager_get_type.table =
        g_list_append (testdata.g_mozilla_password_manager_get_type.table, tmp_g_mozilla_password_manager_get_type);
    testdata.g_mozilla_password_manager_get_type.index = 0;

    GMozillaPasswordManagerLoginNewStruct* tmp_g_mozilla_password_manager_login_new = g_new0(GMozillaPasswordManagerLoginNewStruct, 1);
    /* const gchar* */tmp_g_mozilla_password_manager_login_new->server = NULL;
    /* gint */tmp_g_mozilla_password_manager_login_new->index = 0;
    /* GList* */tmp_g_mozilla_password_manager_login_new->logins_list = NULL;
    /* GObject* */tmp_g_mozilla_password_manager_login_new->expected_retvalue = 0;
    testdata.g_mozilla_password_manager_login_new.table =
        g_list_append (testdata.g_mozilla_password_manager_login_new.table, tmp_g_mozilla_password_manager_login_new);
    testdata.g_mozilla_password_manager_login_new.index = 0;

    return 0;
}

/**
 * Clean function created by test creation script. It is success always.
 */
static int
testgmozillapassman_basics_clean()
{
    INIT_OR_CLEAN_STARTED("testgmozillapassman_basics_clean");
    testdata.basics = FALSE;
    return 0;
}

/**
 * Init function created by test creation script. It is success always.
 */
static int
testgmozillapassman_advanced_init()
{
    INIT_OR_CLEAN_STARTED("testgmozillapassman_advanced_init");
    g_type_init();
    init_test_data();
    
    GMozillaPasswordManagerGetTypeStruct* tmp_g_mozilla_password_manager_get_type = g_new0(GMozillaPasswordManagerGetTypeStruct, 1);
    /* GType */tmp_g_mozilla_password_manager_get_type->expected_retvalue = 0;
    testdata.g_mozilla_password_manager_get_type.table =
        g_list_append (testdata.g_mozilla_password_manager_get_type.table, tmp_g_mozilla_password_manager_get_type);
    testdata.g_mozilla_password_manager_get_type.index = 0;

    GMozillaPasswordManagerLoginNewStruct* tmp_g_mozilla_password_manager_login_new = g_new0(GMozillaPasswordManagerLoginNewStruct, 1);
    /* const gchar* */tmp_g_mozilla_password_manager_login_new->server = NULL;
    /* gint */tmp_g_mozilla_password_manager_login_new->index = 0;
    /* GList* */tmp_g_mozilla_password_manager_login_new->logins_list = NULL;
    /* GObject* */tmp_g_mozilla_password_manager_login_new->expected_retvalue = 0;
    testdata.g_mozilla_password_manager_login_new.table =
        g_list_append (testdata.g_mozilla_password_manager_login_new.table, tmp_g_mozilla_password_manager_login_new);
    testdata.g_mozilla_password_manager_login_new.index = 0;

    return 0;
}

/**
 * Clean function created by test creation script. It is success always.
 */
static int
testgmozillapassman_advanced_clean()
{
    INIT_OR_CLEAN_STARTED("testgmozillapassman_advanced_clean");
    return 0;
}

/**
 * Init function created by test creation script. It is success always.
 */
static int
testgmozillapassman_interface_basics_init()
{
    INIT_OR_CLEAN_STARTED("testgmozillapassman_interface_basics_init");
    g_type_init();
    init_test_data();
    testdata.basics = TRUE;

    IfaceGMozillaPasswordManagerGetLoginUsernameStruct* tmp_iface_g_mozilla_password_manager_get_login_username =
        g_new0(IfaceGMozillaPasswordManagerGetLoginUsernameStruct, 1);
    /* GMozillaPasswordManager* */tmp_iface_g_mozilla_password_manager_get_login_username->self = 
        (GMozillaPasswordManager*)g_object_new(g_mozilla_password_manager_get_type(), NULL);
    END_INIT_WITH_MESSAGE_IF_FAIL(tmp_iface_g_mozilla_password_manager_get_login_username->self, "GMozillaPasswordManager not received!");
    /* gchar* */tmp_iface_g_mozilla_password_manager_get_login_username->test_username_variable = "";
    /* gchar** */tmp_iface_g_mozilla_password_manager_get_login_username->username = 
        &tmp_iface_g_mozilla_password_manager_get_login_username->test_username_variable;
    /* GType */tmp_iface_g_mozilla_password_manager_get_login_username->expected_retvalue = 0;
    /* GWebPasswordManagerIface* */tmp_iface_g_mozilla_password_manager_get_login_username->iface =
        g_type_interface_peek (g_type_class_peek (G_OBJECT_TYPE (tmp_iface_g_mozilla_password_manager_get_login_username->self)), G_TYPE_WEB_PASSWORD_MANAGER);
    END_INIT_WITH_MESSAGE_IF_FAIL(tmp_iface_g_mozilla_password_manager_get_login_username->iface, "Iface not received!");
    testdata.iface_g_mozilla_password_manager_get_login_username.table =
        g_list_append (testdata.iface_g_mozilla_password_manager_get_login_username.table,
                tmp_iface_g_mozilla_password_manager_get_login_username);
    testdata.iface_g_mozilla_password_manager_get_login_username.index = 0;
    
    IfaceGMozillaPasswordManagerGetLoginPasswordStruct* tmp_iface_g_mozilla_password_manager_get_login_password =
        g_new0(IfaceGMozillaPasswordManagerGetLoginPasswordStruct, 1);
    /* GMozillaPasswordManager* */tmp_iface_g_mozilla_password_manager_get_login_password->self =  
        (GMozillaPasswordManager*)g_object_new(g_mozilla_password_manager_get_type(), NULL);
    END_INIT_WITH_MESSAGE_IF_FAIL(tmp_iface_g_mozilla_password_manager_get_login_password->self, "GMozillaPasswordManager not received!");
    /* gchar*  */tmp_iface_g_mozilla_password_manager_get_login_password->test_password_variable = NULL;
    /* gchar** */tmp_iface_g_mozilla_password_manager_get_login_password->password = NULL;
    /* GWebStatus */tmp_iface_g_mozilla_password_manager_get_login_password->expected_retvalue = G_WEB_STATUS_OK;
    /* GWebPasswordManagerIface* */tmp_iface_g_mozilla_password_manager_get_login_password->iface =
        g_type_interface_peek (g_type_class_peek (G_OBJECT_TYPE (tmp_iface_g_mozilla_password_manager_get_login_password->self)), G_TYPE_WEB_PASSWORD_MANAGER);
    END_INIT_WITH_MESSAGE_IF_FAIL(tmp_iface_g_mozilla_password_manager_get_login_password->iface, "Iface not received!");
    testdata.iface_g_mozilla_password_manager_get_login_password.table =
        g_list_append (testdata.iface_g_mozilla_password_manager_get_login_password.table,
                tmp_iface_g_mozilla_password_manager_get_login_password);
    testdata.iface_g_mozilla_password_manager_get_login_password.index = 0;

    IfaceGMozillaPasswordManagerLoginGetPersonalDataStruct* tmp_iface_g_mozilla_password_manager_login_get_personal_data =
        g_new0(IfaceGMozillaPasswordManagerLoginGetPersonalDataStruct, 1);
    /* GMozillaPasswordManager* */tmp_iface_g_mozilla_password_manager_login_get_personal_data->self =  
        (GMozillaPasswordManager*)g_object_new(g_mozilla_password_manager_get_type(), NULL);
    END_INIT_WITH_MESSAGE_IF_FAIL(tmp_iface_g_mozilla_password_manager_login_get_personal_data->self, "GMozillaPasswordManager not received!");
    /* GObject* */tmp_iface_g_mozilla_password_manager_login_get_personal_data->expected_retvalue = NULL;
    /* GWebPasswordManagerIface* */tmp_iface_g_mozilla_password_manager_login_get_personal_data->iface =
        g_type_interface_peek (g_type_class_peek (G_OBJECT_TYPE (tmp_iface_g_mozilla_password_manager_login_get_personal_data->self)), G_TYPE_WEB_PASSWORD_MANAGER);
    END_INIT_WITH_MESSAGE_IF_FAIL(tmp_iface_g_mozilla_password_manager_login_get_personal_data->iface, "Iface not received!");
    testdata.iface_g_mozilla_password_manager_login_get_personal_data.table =
        g_list_append (testdata.iface_g_mozilla_password_manager_login_get_personal_data.table,
                tmp_iface_g_mozilla_password_manager_login_get_personal_data);
    testdata.iface_g_mozilla_password_manager_login_get_personal_data.index = 0;

    
    printf("SUCCESS\n"); 
    return 0;
}

/**
 * Clean function created by test creation script. It is success always.
 */
static int
testgmozillapassman_interface_basics_clean()
{
    INIT_OR_CLEAN_STARTED("testgmozillapassman_interface_basics_clean");
    testdata.basics = FALSE;
    return 0;
}

/**
 * Init function created by test creation script. It is success always.
 */
static int
testgmozillapassman_interface_basics2_init()
{
    INIT_OR_CLEAN_STARTED("testgmozillapassman_interface_basics2_init");
    g_type_init();
    init_test_data();
    testdata.basics = TRUE;

    testdata.help_data.logins_list = NULL;
    testdata.help_data.size = 0;
    guint index = 0;
    GtkMozLogin* login = g_new0(GtkMozLogin, 1);
    END_INIT_WITH_MESSAGE_IF_FAIL(login, "login not received!");
    printf("Creation of login was SUCCESSFULL!!!.\n");
    login->user = "user";
    login->pass = "pass";
    login->host = "host";
    login->index = index;
    testdata.help_data.logins_list = g_list_append (testdata.help_data.logins_list, login);
    END_INIT_WITH_MESSAGE_IF_FAIL(testdata.help_data.logins_list, "Creating logins_list failed.");
    testdata.help_data.size++;

    IfaceGMozillaPasswordManagerGetLoginUsernameStruct* tmp_iface_g_mozilla_password_manager_get_login_username =
        g_new0(IfaceGMozillaPasswordManagerGetLoginUsernameStruct, 1);
    /* GMozillaPasswordManager* */tmp_iface_g_mozilla_password_manager_get_login_username->self = 
        (GMozillaPasswordManager*)g_object_new(g_mozilla_password_manager_get_type(), NULL);
    END_INIT_WITH_MESSAGE_IF_FAIL(tmp_iface_g_mozilla_password_manager_get_login_username->self, "GMozillaPasswordManager not received!");
    /* GMozillaPasswordManager* */tmp_iface_g_mozilla_password_manager_get_login_username->self->login =
        g_list_nth_data(testdata.help_data.logins_list, index);
    END_INIT_WITH_MESSAGE_IF_FAIL(login, "login not received!");
    /* gchar* */tmp_iface_g_mozilla_password_manager_get_login_username->test_username_variable = "";
    /* gchar** */tmp_iface_g_mozilla_password_manager_get_login_username->username = 
        &tmp_iface_g_mozilla_password_manager_get_login_username->test_username_variable;
    /* GType */tmp_iface_g_mozilla_password_manager_get_login_username->expected_retvalue = 0;
    /* GWebPasswordManagerIface* */tmp_iface_g_mozilla_password_manager_get_login_username->iface =
        g_type_interface_peek (g_type_class_peek (G_OBJECT_TYPE (tmp_iface_g_mozilla_password_manager_get_login_username->self)), G_TYPE_WEB_PASSWORD_MANAGER);
    END_INIT_WITH_MESSAGE_IF_FAIL(tmp_iface_g_mozilla_password_manager_get_login_username->iface, "Iface not received!");
    testdata.iface_g_mozilla_password_manager_get_login_username.table =
        g_list_append (testdata.iface_g_mozilla_password_manager_get_login_username.table,
                tmp_iface_g_mozilla_password_manager_get_login_username);
    testdata.iface_g_mozilla_password_manager_get_login_username.index = 0;

    login = g_new0(GtkMozLogin, 1);
    END_INIT_WITH_MESSAGE_IF_FAIL(login, "login not received!");
    printf("Creation of login was SUCCESSFULL!!!.\n");
    index++;
    login->user = "user";
    login->pass = "pass";
    login->host = "host";
    login->index = index;
    testdata.help_data.logins_list = g_list_append (testdata.help_data.logins_list, login);
    END_INIT_WITH_MESSAGE_IF_FAIL(testdata.help_data.logins_list, "Creating logins_list failed.");
    testdata.help_data.size++;

    IfaceGMozillaPasswordManagerGetLoginPasswordStruct* tmp_iface_g_mozilla_password_manager_get_login_password =
        g_new0(IfaceGMozillaPasswordManagerGetLoginPasswordStruct, 1);
    /* GMozillaPasswordManager* */tmp_iface_g_mozilla_password_manager_get_login_password->self = 
        (GMozillaPasswordManager*)g_object_new(g_mozilla_password_manager_get_type(), NULL);
    END_INIT_WITH_MESSAGE_IF_FAIL(tmp_iface_g_mozilla_password_manager_get_login_password->self, "GMozillaPasswordManager not received!");
    /* GMozillaPasswordManager* */tmp_iface_g_mozilla_password_manager_get_login_password->self->login =
        g_list_nth_data(testdata.help_data.logins_list, index);
    END_INIT_WITH_MESSAGE_IF_FAIL(login, "login not received!");
    /* gchar*  */tmp_iface_g_mozilla_password_manager_get_login_password->test_password_variable = "";
    /* gchar** */tmp_iface_g_mozilla_password_manager_get_login_password->password =
        &tmp_iface_g_mozilla_password_manager_get_login_password->test_password_variable;
    /* GWebStatus */tmp_iface_g_mozilla_password_manager_get_login_password->expected_retvalue = G_WEB_STATUS_OK;
    /* GWebPasswordManagerIface* */tmp_iface_g_mozilla_password_manager_get_login_password->iface =
        g_type_interface_peek (g_type_class_peek (G_OBJECT_TYPE (tmp_iface_g_mozilla_password_manager_get_login_password->self)), G_TYPE_WEB_PASSWORD_MANAGER);
    END_INIT_WITH_MESSAGE_IF_FAIL(tmp_iface_g_mozilla_password_manager_get_login_password->iface, "Iface not received!");
    testdata.iface_g_mozilla_password_manager_get_login_password.table =
        g_list_append (testdata.iface_g_mozilla_password_manager_get_login_password.table,
                tmp_iface_g_mozilla_password_manager_get_login_password);
    testdata.iface_g_mozilla_password_manager_get_login_password.index = 0;


    index = 0;
    login = g_new0(GtkMozLogin, 1);
    END_INIT_WITH_MESSAGE_IF_FAIL(login, "login not received!");
    printf("Creation of login was SUCCESSFULL!!!.\n");
    index++;
    login->user = "user";
    login->pass = "pass";
    login->host = "host";
    login->index = index;
    testdata.help_data.logins_list = g_list_append (testdata.help_data.logins_list, login);
    END_INIT_WITH_MESSAGE_IF_FAIL(testdata.help_data.logins_list, "Creating logins_list failed.");
    testdata.help_data.size++;

    IfaceGMozillaPasswordManagerLoginGetPersonalDataStruct* tmp_iface_g_mozilla_password_manager_login_get_personal_data =
        g_new0(IfaceGMozillaPasswordManagerLoginGetPersonalDataStruct, 1);
    /* GMozillaPasswordManager* */tmp_iface_g_mozilla_password_manager_login_get_personal_data->self = 
        (GMozillaPasswordManager*)g_object_new(g_mozilla_password_manager_get_type(), NULL);
    END_INIT_WITH_MESSAGE_IF_FAIL(tmp_iface_g_mozilla_password_manager_login_get_personal_data->self, "GMozillaPasswordManager not received!");
    /* GMozillaPasswordManager* */tmp_iface_g_mozilla_password_manager_login_get_personal_data->self->login =
        g_list_nth_data(testdata.help_data.logins_list, index);
    END_INIT_WITH_MESSAGE_IF_FAIL(login, "login not received!");
    /* GObject* */tmp_iface_g_mozilla_password_manager_login_get_personal_data->expected_retvalue = NULL;
    /* GWebPasswordManagerIface* */tmp_iface_g_mozilla_password_manager_login_get_personal_data->iface =
        g_type_interface_peek (g_type_class_peek (G_OBJECT_TYPE (tmp_iface_g_mozilla_password_manager_login_get_personal_data->self)), G_TYPE_WEB_PASSWORD_MANAGER);
    END_INIT_WITH_MESSAGE_IF_FAIL(tmp_iface_g_mozilla_password_manager_login_get_personal_data->iface, "Iface not received!");
    testdata.iface_g_mozilla_password_manager_login_get_personal_data.table =
        g_list_append (testdata.iface_g_mozilla_password_manager_login_get_personal_data.table,
                tmp_iface_g_mozilla_password_manager_login_get_personal_data);
    testdata.iface_g_mozilla_password_manager_login_get_personal_data.index = 0;

    printf("3. case initialized.\n");
    
    printf("SUCCESS\n"); 
    return 0;
}

/**
 * Clean function created by test creation script. It is success always.
 */
static int
testgmozillapassman_interface_basics2_clean()
{
    INIT_OR_CLEAN_STARTED("testgmozillapassman_interface_basics2_clean");
    testdata.basics = FALSE;
    return 0;
}


/**
 * All new test cases are going to start from here. They are also added to automatic suite.
 * DO NOT DELETE AUTOMATIC SUITE!
 */

static CU_TestInfo testgmozillapassman_automatic_added[] = {
        // Test is made { "test_g_mozilla_password_manager_get_type", test_g_mozilla_password_manager_get_type },
        // Test is made { "test_g_mozilla_password_manager_login_new", test_g_mozilla_password_manager_login_new },
        CU_TEST_INFO_NULL, //null terminated
};
static CU_TestInfo testgmozillapassman_basics[] = {
        { "test_g_mozilla_password_manager_get_type", test_g_mozilla_password_manager_get_type },
        { "test_g_mozilla_password_manager_login_new", test_g_mozilla_password_manager_login_new },
        CU_TEST_INFO_NULL, //null terminated
};
static CU_TestInfo testgmozillapassman_advanced[] = {
        //{ "test_g_mozilla_password_manager_get_type", test_g_mozilla_password_manager_get_type },
        //{ "test_g_mozilla_password_manager_login_new", test_g_mozilla_password_manager_login_new },
        CU_TEST_INFO_NULL, //null terminated
};

static CU_TestInfo testgmozillapassman_interface_basics[] = {
{ "test_iface_g_mozilla_password_manager_get_login_username", test_iface_g_mozilla_password_manager_get_login_username },
{ "test_iface_g_mozilla_password_manager_get_login_password", test_iface_g_mozilla_password_manager_get_login_password },
{ "test_iface_g_mozilla_password_manager_login_get_personal_data", test_iface_g_mozilla_password_manager_login_get_personal_data },
    CU_TEST_INFO_NULL, //null terminated
};
/**
 * Main table holding all the test cases.
 */
CU_SuiteInfo testgmozillapassman[] = {
        {"testgmozillapassman_automatic_added", testgmozillapassman_automatic_init, testgmozillapassman_automatic_clean, testgmozillapassman_automatic_added },
        {"testgmozillapassman_basics", testgmozillapassman_basics_init, testgmozillapassman_basics_clean, testgmozillapassman_basics },
        {"testgmozillapassman_advanced", testgmozillapassman_advanced_init, testgmozillapassman_advanced_clean, testgmozillapassman_advanced },
        {"testgmozillapassman_interface_basics", testgmozillapassman_interface_basics_init, testgmozillapassman_interface_basics_clean, testgmozillapassman_interface_basics },
        {"testgmozillapassman_interface_basics2", testgmozillapassman_interface_basics2_init, testgmozillapassman_interface_basics2_clean, testgmozillapassman_interface_basics },
        CU_SUITE_INFO_NULL, //null terminated
};
