
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the MICROB EAL package.
 *
 * The Initial Developer of the Original Code is Nokia Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contact: Oleg Romashin <oleg.romashin@nokia.com>
 *
 * ***** END LICENSE BLOCK ***** */



#include "testgmozillaconnectivity.h"
#include "tests_common.h"

#include <assert.h>
#include <Automated.h>

#include <stdio.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>

#include "gmozillaconnectivity.h"
#include "common.h"
#include "gmozillaengine.h"
#include "gmozillaweb.h"
#include "gmozillatransferitem.h"
#include <string.h>
#include "gmozillacppwrapper.h"
#ifdef USE_GCONF
#include <gconf/gconf-client.h>
#endif
#ifdef USE_DBUS
#ifdef USE_CONIC
#include <osso-ic-dbus.h>
#endif
#include <dbus/dbus.h>
#endif
#ifdef USE_CONIC
#include <conic/conic.h>
#endif
#ifdef USE_GCONF
#endif // USE_GCONF
#ifdef USE_CONIC
#ifdef USE_DBUS
#else
#endif
#endif
#ifdef USE_CONIC
#endif
#ifdef USE_DBUS
#ifdef USE_CONIC
#endif
#ifdef USE_CONIC
#endif
#ifdef USE_CONIC
#endif
#ifdef USE_CONIC
#endif
#endif
#ifdef USE_CONIC
#endif
#ifdef USE_DBUS
#ifdef USE_CONIC
#endif
#endif /* USE_DBUS */
#ifdef USE_DBUS
#ifdef USE_CONIC
#endif /* USE_CONIC */
#endif /* USE_DBUS */
#ifdef USE_CONIC
#endif /* USE_CONIC */
#ifdef __arm__
#endif
#ifdef USE_CONIC
#endif
#ifdef USE_CONIC
#else
#endif
#ifdef USE_GCONF
#endif
#ifdef USE_GCONF
#endif
#ifdef USE_GCONF
#endif
#ifdef USE_GCONF
#endif
#ifdef USE_GCONF
#endif
#ifdef USE_GCONF
#endif
#ifdef USE_GCONF
#endif
#ifdef USE_GCONF
#endif
#ifdef USE_GCONF
#endif

typedef struct {
    gboolean expected_retvalue;
} GMozillaConnectivityCheckBuggyStruct;
typedef struct {
    gpointer data;
    gboolean reconnect;
    gboolean expected_retvalue;
} GMozillaConnectivityConnectStruct;
typedef struct {
    GMozillaEngine* self;
    gint event;
} GMozillaConnectivityHandleStruct;
typedef struct {
    gboolean expected_retvalue;
} GMozillaConnectivityIsConnectedStruct;
typedef struct {
    GMozillaWeb* self;
} GMozillaConnectivitySetGlobalStruct;
typedef struct {
    gboolean expected_retvalue;
} GMozillaConnectivitySetProxyStruct;
typedef struct {
    GMozillaWeb* self;
} GMozillaConnectivityUnsetGlobalStruct;

typedef struct {
    gboolean automatic;
    gboolean basics;
    TestTableData g_mozilla_connectivity_check_buggy;
    TestTableData g_mozilla_connectivity_connect;
    TestTableData g_mozilla_connectivity_handle;
    TestTableData g_mozilla_connectivity_is_connected;
    TestTableData g_mozilla_connectivity_set_global;
    TestTableData g_mozilla_connectivity_set_proxy;
    TestTableData g_mozilla_connectivity_unset_global;
} TestData;
TestData testdata;
static void init_test_data()
{
    testdata.automatic = FALSE;
    testdata.basics = FALSE;

    g_list_free(testdata.g_mozilla_connectivity_check_buggy.table);
    testdata.g_mozilla_connectivity_check_buggy.table = NULL;
    testdata.g_mozilla_connectivity_check_buggy.index = -1;

    g_list_free(testdata.g_mozilla_connectivity_connect.table);
    testdata.g_mozilla_connectivity_connect.table = NULL;
    testdata.g_mozilla_connectivity_connect.index = -1;

    g_list_free(testdata.g_mozilla_connectivity_handle.table);
    testdata.g_mozilla_connectivity_handle.table = NULL;
    testdata.g_mozilla_connectivity_handle.index = -1;

    g_list_free(testdata.g_mozilla_connectivity_is_connected.table);
    testdata.g_mozilla_connectivity_is_connected.table = NULL;
    testdata.g_mozilla_connectivity_is_connected.index = -1;

    g_list_free(testdata.g_mozilla_connectivity_set_global.table);
    testdata.g_mozilla_connectivity_set_global.table = NULL;
    testdata.g_mozilla_connectivity_set_global.index = -1;

    g_list_free(testdata.g_mozilla_connectivity_set_proxy.table);
    testdata.g_mozilla_connectivity_set_proxy.table = NULL;
    testdata.g_mozilla_connectivity_set_proxy.index = -1;

    g_list_free(testdata.g_mozilla_connectivity_unset_global.table);
    testdata.g_mozilla_connectivity_unset_global.table = NULL;
    testdata.g_mozilla_connectivity_unset_global.index = -1;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_mozilla_connectivity_check_buggy(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_connectivity_check_buggy");

    if(testdata.automatic)
    {
        CU_FAIL("//PRIVATE Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        /*
        gint test_index = testdata.g_mozilla_connectivity_check_buggy.index;
        printf("Index of test data: %i\n", test_index);
        GMozillaConnectivityCheckBuggyStruct* test_item_data =
            (GMozillaConnectivityCheckBuggyStruct*)g_list_nth_data(testdata.g_mozilla_connectivity_check_buggy.table, test_index);
        gboolean retvalue;
        if(testdata.basics) {
            retvalue = g_mozilla_connectivity_check_buggy();
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            gboolean expected_retvalue = test_item_data->expected_retvalue;
            retvalue = g_mozilla_connectivity_check_buggy();
            CU_ASSERT_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }
        */
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_mozilla_connectivity_connect(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_connectivity_connect");

    if(testdata.automatic)
    {
        CU_FAIL("//PRIVATE Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        /*
        gint test_index = testdata.g_mozilla_connectivity_connect.index;
        printf("Index of test data: %i\n", test_index);
        GMozillaConnectivityConnectStruct* test_item_data =
            (GMozillaConnectivityConnectStruct*)g_list_nth_data(testdata.g_mozilla_connectivity_connect.table, test_index);
        gpointer data = test_item_data->data;
        gboolean reconnect = test_item_data->reconnect;
        gboolean retvalue;
        if(testdata.basics) {
            retvalue = g_mozilla_connectivity_connect(data,reconnect);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            gboolean expected_retvalue = test_item_data->expected_retvalue;
            retvalue = g_mozilla_connectivity_connect(data,reconnect);
            CU_ASSERT_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }
        */
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_mozilla_connectivity_handle(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_connectivity_handle");

    if(testdata.automatic)
    {
        CU_FAIL("//PRIVATE Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        /*
        gint test_index = testdata.g_mozilla_connectivity_handle.index;
        printf("Index of test data: %i\n", test_index);
        GMozillaConnectivityHandleStruct* test_item_data =
            (GMozillaConnectivityHandleStruct*)g_list_nth_data(testdata.g_mozilla_connectivity_handle.table, test_index);
        GMozillaEngine* self = test_item_data->self;
        gint event = test_item_data->event;
        if(testdata.basics) {
            g_mozilla_connectivity_handle(self,event);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            g_mozilla_connectivity_handle(self,event);
            printf("Advanced test runned.\n");
        }
        */
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_mozilla_connectivity_is_connected(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_connectivity_is_connected");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.g_mozilla_connectivity_is_connected.index;
        printf("Index of test data: %i\n", test_index);
        GMozillaConnectivityIsConnectedStruct* test_item_data =
            (GMozillaConnectivityIsConnectedStruct*)g_list_nth_data(testdata.g_mozilla_connectivity_is_connected.table, test_index);
        gboolean retvalue;
        if(testdata.basics) {
            retvalue = g_mozilla_connectivity_is_connected();
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            gboolean expected_retvalue = test_item_data->expected_retvalue;
            retvalue = g_mozilla_connectivity_is_connected();
            CU_ASSERT_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_mozilla_connectivity_set_global(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_connectivity_set_global");

    if(testdata.automatic)
    {
        CU_FAIL("//PRIVATE Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        /*
        gint test_index = testdata.g_mozilla_connectivity_set_global.index;
        printf("Index of test data: %i\n", test_index);
        GMozillaConnectivitySetGlobalStruct* test_item_data =
            (GMozillaConnectivitySetGlobalStruct*)g_list_nth_data(testdata.g_mozilla_connectivity_set_global.table, test_index);
        testdata.g_mozilla_connectivity_set_global.index++;
        GMozillaWeb* self = test_item_data->self;
        if(testdata.basics) {
            g_mozilla_connectivity_set_global(self);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            g_mozilla_connectivity_set_global(self);
            printf("Advanced test runned.\n");
        }
        */
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_mozilla_connectivity_set_proxy(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_connectivity_set_proxy");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.g_mozilla_connectivity_set_proxy.index;
        printf("Index of test data: %i\n", test_index);
        GMozillaConnectivitySetProxyStruct* test_item_data =
            (GMozillaConnectivitySetProxyStruct*)g_list_nth_data(testdata.g_mozilla_connectivity_set_proxy.table, test_index);
        testdata.g_mozilla_connectivity_set_proxy.index++;
        gboolean retvalue;
        if(testdata.basics) {
            retvalue = g_mozilla_connectivity_set_proxy();
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            gboolean expected_retvalue = test_item_data->expected_retvalue;
            retvalue = g_mozilla_connectivity_set_proxy();
            CU_ASSERT_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_mozilla_connectivity_unset_global(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_connectivity_unset_global");

    if(testdata.automatic)
    {
        CU_FAIL("//PRIVATE Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        /*
        gint test_index = testdata.g_mozilla_connectivity_unset_global.index;
        printf("Index of test data: %i\n", test_index);
        GMozillaConnectivityUnsetGlobalStruct* test_item_data =
            (GMozillaConnectivityUnsetGlobalStruct*)g_list_nth_data(testdata.g_mozilla_connectivity_unset_global.table, test_index);
        testdata.g_mozilla_connectivity_unset_global.index++;
        GMozillaWeb* self = test_item_data->self;
        if(testdata.basics) {
            g_mozilla_connectivity_unset_global(self);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            g_mozilla_connectivity_unset_global(self);
            printf("Advanced test runned.\n");
        }
        */
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * Init function created by test creation script. It is success always.
 */
static int
testgmozillaconnectivity_automatic_init()
{
    INIT_OR_CLEAN_STARTED("testgmozillaconnectivity_init");
    //init_test_data();
    testdata.automatic = TRUE;
    return 0;
}

/**
 * Clean function created by test creation script. It is success always.
 */
static int
testgmozillaconnectivity_automatic_clean()
{
    INIT_OR_CLEAN_STARTED("testgmozillaconnectivity_clean");
    testdata.automatic = FALSE;
    return 0;
}

/**
 * Init function created by test creation script. It is success always.
 */
static int
testgmozillaconnectivity_basics_init()
{
    INIT_OR_CLEAN_STARTED("testgmozillaconnectivity_basics_init");
    g_type_init();
    init_test_data();
    testdata.basics = TRUE;
    GMozillaConnectivityCheckBuggyStruct* tmp_g_mozilla_connectivity_check_buggy = g_new0(GMozillaConnectivityCheckBuggyStruct, 1);
    /* gboolean */tmp_g_mozilla_connectivity_check_buggy->expected_retvalue = 0;
    testdata.g_mozilla_connectivity_check_buggy.table =
        g_list_append (testdata.g_mozilla_connectivity_check_buggy.table, tmp_g_mozilla_connectivity_check_buggy);
    testdata.g_mozilla_connectivity_check_buggy.index = 0;

    GMozillaConnectivityConnectStruct* tmp_g_mozilla_connectivity_connect = g_new0(GMozillaConnectivityConnectStruct, 1);
    /* gpointer */tmp_g_mozilla_connectivity_connect->data = NULL;
    /* gboolean */tmp_g_mozilla_connectivity_connect->reconnect = FALSE;
    /* gboolean */tmp_g_mozilla_connectivity_connect->expected_retvalue = 0;
    testdata.g_mozilla_connectivity_connect.table =
        g_list_append (testdata.g_mozilla_connectivity_connect.table, tmp_g_mozilla_connectivity_connect);
    testdata.g_mozilla_connectivity_connect.index = 0;

    GMozillaConnectivityHandleStruct* tmp_g_mozilla_connectivity_handle = g_new0(GMozillaConnectivityHandleStruct, 1);
    /* GMozillaEngine* */tmp_g_mozilla_connectivity_handle->self = NULL;
    /* gint */tmp_g_mozilla_connectivity_handle->event = 0;
    testdata.g_mozilla_connectivity_handle.table =
        g_list_append (testdata.g_mozilla_connectivity_handle.table, tmp_g_mozilla_connectivity_handle);
    testdata.g_mozilla_connectivity_handle.index = 0;

    GMozillaConnectivityIsConnectedStruct* tmp_g_mozilla_connectivity_is_connected = g_new0(GMozillaConnectivityIsConnectedStruct, 1);
    /* gboolean */tmp_g_mozilla_connectivity_is_connected->expected_retvalue = 0;
    testdata.g_mozilla_connectivity_is_connected.table =
        g_list_append (testdata.g_mozilla_connectivity_is_connected.table, tmp_g_mozilla_connectivity_is_connected);
    testdata.g_mozilla_connectivity_is_connected.index = 0;

    GMozillaConnectivitySetGlobalStruct* tmp_g_mozilla_connectivity_set_global = g_new0(GMozillaConnectivitySetGlobalStruct, 1);
    /* GMozillaWeb* */tmp_g_mozilla_connectivity_set_global->self = NULL;
    testdata.g_mozilla_connectivity_set_global.table =
        g_list_append (testdata.g_mozilla_connectivity_set_global.table, tmp_g_mozilla_connectivity_set_global);
    testdata.g_mozilla_connectivity_set_global.index = 0;

    GMozillaConnectivitySetProxyStruct* tmp_g_mozilla_connectivity_set_proxy = g_new0(GMozillaConnectivitySetProxyStruct, 1);
    /* gboolean */tmp_g_mozilla_connectivity_set_proxy->expected_retvalue = 0;
    testdata.g_mozilla_connectivity_set_proxy.table =
        g_list_append (testdata.g_mozilla_connectivity_set_proxy.table, tmp_g_mozilla_connectivity_set_proxy);
    testdata.g_mozilla_connectivity_set_proxy.index = 0;

    GMozillaConnectivityUnsetGlobalStruct* tmp_g_mozilla_connectivity_unset_global = g_new0(GMozillaConnectivityUnsetGlobalStruct, 1);
    /* GMozillaWeb* */tmp_g_mozilla_connectivity_unset_global->self = NULL;
    testdata.g_mozilla_connectivity_unset_global.table =
        g_list_append (testdata.g_mozilla_connectivity_unset_global.table, tmp_g_mozilla_connectivity_unset_global);
    testdata.g_mozilla_connectivity_unset_global.index = 0;

    return 0;
}

/**
 * Clean function created by test creation script. It is success always.
 */
static int
testgmozillaconnectivity_basics_clean()
{
    INIT_OR_CLEAN_STARTED("testgmozillaconnectivity_basics_clean");
    testdata.basics = FALSE;
    return 0;
}

/**
 * Init function created by test creation script. It is success always.
 */
static int
testgmozillaconnectivity_advanced_init()
{
    INIT_OR_CLEAN_STARTED("testgmozillaconnectivity_advanced_init");
    g_type_init();
    init_test_data();
    return 0;
}

/**
 * Clean function created by test creation script. It is success always.
 */
static int
testgmozillaconnectivity_advanced_clean()
{
    INIT_OR_CLEAN_STARTED("testgmozillaconnectivity_advanced_clean");
    return 0;
}


/**
 * All new test cases are going to start from here. They are also added to automatic suite.
 * DO NOT DELETE AUTOMATIC SUITE!
 */

static CU_TestInfo testgmozillaconnectivity_automatic_added[] = {
        { "test_g_mozilla_connectivity_check_buggy", test_g_mozilla_connectivity_check_buggy },
        { "test_g_mozilla_connectivity_connect", test_g_mozilla_connectivity_connect },
        { "test_g_mozilla_connectivity_handle", test_g_mozilla_connectivity_handle },
        // Test is made { "test_g_mozilla_connectivity_is_connected", test_g_mozilla_connectivity_is_connected },
        { "test_g_mozilla_connectivity_set_global", test_g_mozilla_connectivity_set_global },
        // Test is made { "test_g_mozilla_connectivity_set_proxy", test_g_mozilla_connectivity_set_proxy },
        { "test_g_mozilla_connectivity_unset_global", test_g_mozilla_connectivity_unset_global },
        CU_TEST_INFO_NULL, //null terminated
};
static CU_TestInfo testgmozillaconnectivity_basics[] = {
        //PRIVATE { "test_g_mozilla_connectivity_check_buggy", test_g_mozilla_connectivity_check_buggy },
        //PRIVATE { "test_g_mozilla_connectivity_connect", test_g_mozilla_connectivity_connect },
        //PRIVATE { "test_g_mozilla_connectivity_handle", test_g_mozilla_connectivity_handle },
        { "test_g_mozilla_connectivity_is_connected", test_g_mozilla_connectivity_is_connected },
        //PRIVATE { "test_g_mozilla_connectivity_set_global", test_g_mozilla_connectivity_set_global },
        { "test_g_mozilla_connectivity_set_proxy", test_g_mozilla_connectivity_set_proxy },
        //PRIVATE { "test_g_mozilla_connectivity_unset_global", test_g_mozilla_connectivity_unset_global },
        CU_TEST_INFO_NULL, //null terminated
};
static CU_TestInfo testgmozillaconnectivity_advanced[] = {
        //{ "test_g_mozilla_connectivity_check_buggy", test_g_mozilla_connectivity_check_buggy },
        //{ "test_g_mozilla_connectivity_connect", test_g_mozilla_connectivity_connect },
        //{ "test_g_mozilla_connectivity_handle", test_g_mozilla_connectivity_handle },
        //{ "test_g_mozilla_connectivity_is_connected", test_g_mozilla_connectivity_is_connected },
        //{ "test_g_mozilla_connectivity_set_global", test_g_mozilla_connectivity_set_global },
        //{ "test_g_mozilla_connectivity_set_proxy", test_g_mozilla_connectivity_set_proxy },
        //{ "test_g_mozilla_connectivity_unset_global", test_g_mozilla_connectivity_unset_global },
        CU_TEST_INFO_NULL, //null terminated
};

/**
 * Main table holding all the test cases.
 */
CU_SuiteInfo testgmozillaconnectivity[] = {
        {"testgmozillaconnectivity_automatic_added", testgmozillaconnectivity_automatic_init, testgmozillaconnectivity_automatic_clean, testgmozillaconnectivity_automatic_added },
        {"testgmozillaconnectivity_basics", testgmozillaconnectivity_basics_init, testgmozillaconnectivity_basics_clean, testgmozillaconnectivity_basics },
        {"testgmozillaconnectivity_advanced", testgmozillaconnectivity_advanced_init, testgmozillaconnectivity_advanced_clean, testgmozillaconnectivity_advanced },
        CU_SUITE_INFO_NULL, //null terminated
};
