/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=4 sts=2 et cindent: */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the MICROB EAL package.
 *
 * The Initial Developer of the Original Code is Nokia Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contact: Anton Rogaynis <anton.rogaynis@nokia.com>
 *
 * ***** END LICENSE BLOCK ***** */

#ifndef __GMOZILLACPPWRAPPER_H__
#define __GMOZILLACPPWRAPPER_H__

#include <glib.h>

#include "gmozillatransferitem.h"
#include "gtkmozembed.h"
#include "gmozillaengine.h"
#include "gmozillaweb.h"

#ifdef __cplusplus /* If this is a C++ compiler, use C linkage */
extern "C" {
#endif

#define NS_TO_GBOOLEAN(x) (x == 0 ? TRUE : FALSE)
#define NS_TO_GWEB(x) (x == 0 ? G_WEB_STATUS_OK : G_WEB_ERR)

/** @struct GtkWebHistoryItem.
  * Defines a web history item.
  */
typedef struct _GtkWebHistoryItem GtkWebHistoryItem;
struct _GtkWebHistoryItem
{
    gchar *title;     /** < URL title */
    gchar *url;       /** < URL */
    glong accessed;   /** < The last time that the URL was accessed */
};

typedef struct _GtkMozLogin GtkMozLogin;
struct _GtkMozLogin
{
    gchar *user; /** < Plugin title */
    gchar *pass; /** < Plugin path */
    gchar *host; /** < Plugin type */
    guint index;
};

/** @struct GtkMicrobPlugin.
 * Defines a Mozilla Plugin.
 */
typedef struct _GtkMicrobPlugin GtkMicrobPlugin;
struct _GtkMicrobPlugin
{
    gchar *title;  /** < Plugin title */
    gchar *creator;  /** < Plugin creator */
    gchar *path;   /** < Plugin path */
    gchar *type;   /** < Plugin type */
    gboolean isDisabled; /** < is plugin enabled */
    gboolean isPlugin; /** <is plugin or extension*/
};

typedef enum
{
  GTK_MOZ_COMMON_BACK_SHISTORY,
  GTK_MOZ_COMMON_FORWARD_SHISTORY,
  GTK_MOZ_COMMON_ALL_SHISTORY
} GtkMozSessionHistory;

typedef enum
{
  GTK_MOZ_CLIPBOARD_SELECT_ALL,
  GTK_MOZ_CLIPBOARD_CUT,
  GTK_MOZ_CLIPBOARD_COPY,
  GTK_MOZ_CLIPBOARD_PASTE,
  GTK_MOZ_CLIPBOARD_CAN_CUT,
  GTK_MOZ_CLIPBOARD_CAN_PASTE,
  GTK_MOZ_CLIPBOARD_CAN_COPY
} GtkMozClipboardAction;

/* Clear all stored logins */
void g_mozilla_cpp_clear_all_passwords();

/* Remove a login by index */
void g_mozilla_cpp_clear_passwords_by_index(int index);

/* Clear all authenticated sessions */
void g_mozilla_cpp_clear_authenticated_sessions();

/* Get all logins matching uri */
int g_mozilla_cpp_get_logins(const char* uri, GList** list);

/* GFunc for g_list_foreach for freeing GtkWebHistoryItem's in the list */
void free_history_item(gpointer data, gpointer user_data);

/* Get list of history items */
gint g_mozilla_cpp_get_history_list(GList **history_list, int cur_count);

/* Remove all history items */
gint g_mozilla_cpp_history_list_remove_all();

/* Remove all items in all session histories */
gint g_mozilla_cpp_shistory_list_remove_all(GMozillaWeb *mozweb);

/* Remove a history item by url */
gint g_mozilla_cpp_history_list_remove(const gchar *url);

int g_mozilla_engine_download_setup(void **listener, void *web_global);

int g_mozilla_engine_download_start(GMozillaTransferItem *item);
int g_mozilla_engine_download_pause(GMozillaTransferItem *item);
int g_mozilla_engine_download_cancel(GMozillaTransferItem *item);
int g_mozilla_engine_get_downloads_count(void);
GList* g_mozilla_engine_get_download_items(void* web_global);
int g_mozilla_engine_save_target(void *engine, const char* aUrl, const char* aDestination, int aSetting, void *aCtx);

int   g_mozilla_get_server_cert(GtkMozEmbed *embed, void **cert, void* ctx);
gboolean   g_mozilla_get_page_verifier_name (GtkMozEmbed *embed, char **verifier_name);

int g_mozilla_engine_observe(const char* service_id, void *object, const char* topic, gunichar2* data);
int g_mozilla_engine_save_prefs(void);
int g_mozilla_engine_get_pref(GtkType type, const char *name, void *value);
int g_mozilla_engine_set_pref(GtkType type, const char *name, void *value);
int g_mozilla_engine_get_pref_type(const char *name);
gboolean g_mozilla_engine_pref_has_user_value(const char *name);

int   g_mozilla_reflow_content(GtkMozEmbed *embed);

char* g_moz_engine_get_encoding(GtkMozEmbed *embed, gint);
int   g_moz_engine_set_encoding(GtkMozEmbed *embed, const gchar *, gint);

int   g_mozilla_engine_get_shistory_list(GMozillaEngine *mozilla_engine, GList **history_list, unsigned int type);
int   g_mozilla_engine_get_shistory_index(GtkMozEmbed *embed);
int   g_mozilla_engine_shistory_goto_index(GtkMozEmbed *embed, int index);
int   g_mozilla_engine_clipboard(GtkMozEmbed *embed, unsigned int action);

int   g_mozilla_get_plugins_list(GList **pluginArray);

int   g_mozilla_set_extension_status(char *extensionID, int status);
int   g_mozilla_set_image_policy(GMozillaEngine *engine, int policy);
int   g_mozilla_load_image(void* node, const char *url);
void  g_mozilla_notification_button_pressed(GtkButton *button, gpointer notification);

gboolean g_moz_engine_permit_unload(GtkMozEmbed *embed);

void  draw_layout(GMozillaEngine *engine, int id, int left, int top, int width, int height, int zoom);
int   send_event_to_layout(GMozillaEngine *self, int type, int x, int y, int mod, int button, int clickcount, int time);

unsigned int g_mozilla_engine_get_security_mode(unsigned int sec_state);

// return 0 when it success
int
g_mozilla_evaluate_js(GMozillaEngine* moz_engine, const gchar* script);

gint
g_mozilla_get_text_zoom(GtkMozEmbed *embed);

gboolean
g_mozilla_set_text_zoom(GtkMozEmbed *embed, gint zoom_level);

int
g_mozilla_initialize_extensions(void);

int
recalculate_element_info(GMozillaEngine *self, gboolean recalculate);

int
get_element_info(GMozillaEngine *self, const int aX, const int aY, int aRadius, GdkRectangle *aBoundingRect);

int
get_mouse_over_element_info(GMozillaEngine *self, gpointer node);

int
send_element_info(GMozillaEngine *self, int id, int type, float t, float l, float w, float h, int aScrollType);

void
g_mozilla_select_widget_item_selected(GMozillaEngine *self, gpointer select, gint* selected_items, gint count);

nsresult create_select_widget (GMozillaEngine *self, gpointer dom_node, gpointer original_node);

void
send_cursor_update_message (GMozillaEngine *self, int cursor);

void
update_default_window_size(GMozillaEngine *self);

gboolean g_mozilla_handle_key_event (void* event);

gchar *
g_mozilla_get_node_text (gpointer node);

guint
g_mozilla_find_text(GMozillaEngine *self, const gchar *string,
                    gboolean reverse, gboolean case_sensitive,
                    gboolean restart, gint target);

int
send_focused_element_message (GMozillaEngine *self, GWebEnginePopupMenuType *aType);

int
scroll_moz_scrollable_view(GMozillaEngine *self, int x, int y, int *overflowx, int *overflowy);

int
get_node_box_or_nearest(void *aNode, float *left, float *top, float *width, float *height, int nearest);

int
g_mozilla_simple_navigation(GMozillaEngine *engine, void *event);

int
g_mozilla_engine_window_set_active(GMozillaEngine *engine, int aIsActive);

gboolean
g_mozilla_engine_send_key_event(GMozillaEngine *self,
                                int type, int keyval, int length, int state, int hardware_keycode,
                                int group, guint is_modifier, int time);

int
g_mozilla_engine_send_activate_event(GMozillaEngine *self, gboolean activate);

GtkWidget *
g_mozilla_engine_get_mozcontainer_from_domwindow(void *aDOMWindow);

GtkWidget *
g_mozilla_engine_get_mozcontainer(GMozillaEngine *self);

int
g_mozilla_xshm_buffer_set_block(GMozillaEngine *engine, int aSetBlocked);

int
g_mozilla_web_suspend_native(GMozillaWeb *aWeb, gboolean aSuspend);

int g_mozilla_plugins_enable(GMozillaWeb *aWeb, gboolean aEnable);

int
g_mozilla_engine_update_fixed_frames(GMozillaEngine *self, gboolean checkOnly);

gboolean
send_fake_key_event_to_layout(GMozillaEngine *self);

void
send_frame_scroll_overflow_message (GMozillaEngine *self, int overflowx, int overflowy);

int
g_mozilla_engine_destroy_internal(GMozillaEngine *self);

int
g_mozilla_web_destroy_internal(GMozillaWeb *self);

void
g_mozilla_web_force_online(void);

#ifdef __cplusplus /* If this is a C++ compiler, end C linkage */
}
#endif

#endif  // __GMOZILLACPPWRAPPER_H__
