/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 tw=80 et cindent: */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "MicrobEalNotification.h"
#include "gmozillaengine.h"
#include "nsCOMPtr.h"

#include "MicrobEalUtils.h"

NS_IMPL_ISUPPORTS1(MicrobEalNotification, nsINotification)

MicrobEalNotification::MicrobEalNotification() : mPersistence(0),
    mButtonCount(0),
    mEngine(NULL),
    mNotificationWidget(NULL)
{
}

MicrobEalNotification::~MicrobEalNotification()
{
  mButtons.Clear();
}

nsresult
MicrobEalNotification::AddButtons(nsIArray *aButtons)
{
  NS_ENSURE_ARG_POINTER(aButtons);
  nsresult rv = aButtons->GetLength(&mButtonCount);
  NS_ENSURE_SUCCESS(rv, rv);

  for (PRUint32 i=0; i<mButtonCount; i++) {
    nsCOMPtr<MicrobEalNotificationButton> buttonData;

    rv = aButtons->QueryElementAt(i, NS_GET_IID(nsINotificationButton), (void **) getter_AddRefs(buttonData));

    if (NS_SUCCEEDED(rv)) {
      AddButton(buttonData);
    }
  }

  return rv;
}

nsresult
MicrobEalNotification::AddToUi(nsString &aTitle)
{
  GMozillaEngine *engine = NULL;
  GetEngine(&engine);
  if (!engine)
    return NS_ERROR_NOT_AVAILABLE;

  char *utf8Label = ToNewUTF8String(mLabel);

  mNotificationWidget = g_mozilla_append_notification(engine, utf8Label, this);
  g_object_ref(mNotificationWidget);

  const PRUint32 arraySize=mButtons.Count();
  for (PRUint32 i=0; i<arraySize; i++) {
    MicrobEalNotificationButton *button = mButtons[i];
    nsAutoString buttonLabel;
    button->GetLabel(buttonLabel);
    char *buttonUtf8Label = ToNewUTF8String(buttonLabel);
    g_mozilla_add_notification_button(engine, mNotificationWidget, this, (gpointer) button, buttonUtf8Label);
    NS_Free(buttonUtf8Label);
  }

  g_mozilla_show_notification(engine, mNotificationWidget, this, aTitle.IsEmpty() ? nsnull : NS_ConvertUTF16toUTF8(aTitle).get());

  NS_Free(utf8Label);
  return NS_OK;
}

nsresult
MicrobEalNotification::RemoveFromUi()
{
  GMozillaEngine *engine = NULL;
  GetEngine(&engine);
  if (!engine)
    return NS_ERROR_NOT_AVAILABLE;

  g_mozilla_remove_notification(engine, mNotificationWidget);
  g_object_unref(mNotificationWidget);
  mNotificationWidget = NULL;
  return NS_OK;
}

nsresult
MicrobEalNotification::AddButton(MicrobEalNotificationButton *aButton)
{
  nsAutoString buttonLabel;
  aButton->GetLabel(buttonLabel);

  mButtons.AppendObject(aButton);
  return NS_OK;
}

nsresult
MicrobEalNotification::ButtonPressed(MicrobEalNotificationButton *aButton)
{
  if (aButton) {
    return aButton->ButtonPressed();
  }

  return NS_ERROR_UNEXPECTED;
}

/* attribute string label; */
NS_IMETHODIMP
MicrobEalNotification::SetEngine(GMozillaEngine* aEngine)
{
  mEngine = aEngine;
  return NS_OK;
}

NS_IMETHODIMP
MicrobEalNotification::GetEngine(GMozillaEngine** aEngine)
{
  NS_ENSURE_ARG(aEngine);
  *aEngine = mEngine;
  return NS_OK;
}

/* attribute string label; */
NS_IMETHODIMP
MicrobEalNotification::GetLabel(nsAString& aLabel)
{
  aLabel = mLabel;
  return NS_OK;
}

NS_IMETHODIMP
MicrobEalNotification::SetLabel(const nsAString& aLabel)
{
  mLabel = aLabel;
  return NS_OK;
}

/* attribute long persistence; */
NS_IMETHODIMP
MicrobEalNotification::GetPersistence(PRInt32 *aPersistence)
{
  NS_ENSURE_ARG(aPersistence);
  *aPersistence = mPersistence;
  return NS_OK;
}

NS_IMETHODIMP
MicrobEalNotification::SetPersistence(PRInt32 aPersistence)
{
  mPersistence = aPersistence;
  return NS_OK;
}

/* attribute long priority; */
NS_IMETHODIMP
MicrobEalNotification::GetPriority(PRInt32 *aPriority)
{
  return NS_ERROR_NOT_IMPLEMENTED;
}

NS_IMETHODIMP
MicrobEalNotification::SetPriority(PRInt32 aPriority)
{
  return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute string value; */
NS_IMETHODIMP
MicrobEalNotification::GetValue(nsAString& aValue)
{
  aValue = mValue;

  return NS_OK;
}

NS_IMETHODIMP
MicrobEalNotification::SetValue(const nsAString& aValue)
{
  mValue = aValue;

  return NS_OK;
}

