/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 tw=80 et cindent: */
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is mozilla.org code.
 *
 * The Initial Developer of the Original Code is
 * timeless <timeless@mozdev.org>.
 * Portions created by the Initial Developer are Copyright (C) 2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Antonio Gomes <tonikitoo@gmail.com>
 *   Oleg Romashin <romaxa@gmail.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "MicrobEalFilePicker.h"
#include "nsIFileURL.h"
#include "nsILocalFile.h"
#include "nsIDOMWindow.h"
#include "nsNetUtil.h"
#include "prenv.h"
#include "nsIStringBundle.h"

#include "MicrobEalUtils.h"

#ifdef MOZ_LOGGING
#include <stdlib.h>
#endif

#define FILEPICKER_PROPERTIES "chrome://global/locale/filepicker.properties"

NS_IMPL_ISUPPORTS1(MicrobEalFilePicker, nsIFilePicker)

MicrobEalFilePicker::MicrobEalFilePicker(): mMode(nsIFilePicker::modeOpen)
{
}

MicrobEalFilePicker::~MicrobEalFilePicker()
{
}

/* void init (in nsIDOMWindowInternal parent, in wstring title, in short mode); */
NS_IMETHODIMP MicrobEalFilePicker::Init(nsIDOMWindow *parent, const nsAString &title, PRInt16 mode)
{
  mParent = parent;
  mMode = mode;
  return NS_OK;
}

/* void appendFilters (in long filterMask); */
NS_IMETHODIMP MicrobEalFilePicker::AppendFilters(PRInt32 aFilterMask)
{
  nsresult rv;
  nsCOMPtr<nsIStringBundleService> stringService =
      do_GetService(NS_STRINGBUNDLE_CONTRACTID);
  NS_ENSURE_TRUE(stringService, NS_ERROR_FAILURE);
  nsCOMPtr<nsIStringBundle> stringBundle;

  rv = stringService->CreateBundle(FILEPICKER_PROPERTIES, getter_AddRefs(stringBundle));
  if (NS_FAILED(rv)) {
    return NS_ERROR_FAILURE;
  }
  NS_ENSURE_TRUE(stringBundle, NS_ERROR_FAILURE);

  nsString filter;

  if (aFilterMask & filterAll) {
    stringBundle->GetStringFromName(NS_LITERAL_STRING("allFilter").get(),
        getter_Copies(filter));
    AppendFilter(filter, filter);
  }
  if (aFilterMask & filterHTML) {
    stringBundle->GetStringFromName(NS_LITERAL_STRING("htmlFilter").get(),
        getter_Copies(filter));
    AppendFilter(filter, filter);
  }
  if (aFilterMask & filterText) {
    stringBundle->GetStringFromName(NS_LITERAL_STRING("textFilter").get(),
        getter_Copies(filter));
    AppendFilter(filter, filter);
  }
  if (aFilterMask & filterImages) {
    stringBundle->GetStringFromName(NS_LITERAL_STRING("imageFilter").get(),
        getter_Copies(filter));
    AppendFilter(filter, filter);
  }
  if (aFilterMask & filterXML) {
    stringBundle->GetStringFromName(NS_LITERAL_STRING("xmlFilter").get(),
        getter_Copies(filter));
    AppendFilter(filter, filter);
  }
  if (aFilterMask & filterXUL) {
    stringBundle->GetStringFromName(NS_LITERAL_STRING("xulFilter").get(),
        getter_Copies(filter));
    AppendFilter(filter, filter);
  }
  // filterApps: No way to filter applications by name
  return NS_OK;
}

/* void appendFilter (in wstring title, in wstring filter); */
NS_IMETHODIMP MicrobEalFilePicker::AppendFilter(const nsAString &/*aTitle*/, const nsAString &aFilter)
{
  nsCAutoString filter;
  CopyUTF16toUTF8(aFilter, filter);
  if (mFilters.Length() > 0) {
    mFilters.Append(";");
  }
  mFilters.Append(filter);
  return NS_OK;
}

/* attribute wstring defaultString; */
NS_IMETHODIMP MicrobEalFilePicker::GetDefaultString(nsAString &aDefaultString)
{
  return NS_ERROR_NOT_IMPLEMENTED;
}

NS_IMETHODIMP MicrobEalFilePicker::SetDefaultString(const nsAString &aDefaultString)
{
  return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute wstring defaultExtension; */
NS_IMETHODIMP MicrobEalFilePicker::GetDefaultExtension(nsAString &aDefaultExtension)
{
  return NS_ERROR_NOT_IMPLEMENTED;
}

NS_IMETHODIMP MicrobEalFilePicker::SetDefaultExtension(const nsAString &aDefaultExtension)
{
  return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute long filterIndex; */
NS_IMETHODIMP MicrobEalFilePicker::GetFilterIndex(PRInt32 *aFilterIndex)
{
  return NS_ERROR_NOT_IMPLEMENTED;
}

NS_IMETHODIMP MicrobEalFilePicker::SetFilterIndex(PRInt32 aFilterIndex)
{
  return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute nsILocalFile displayDirectory; */
NS_IMETHODIMP MicrobEalFilePicker::GetDisplayDirectory(nsILocalFile **aDisplayDirectory)
{
  return NS_ERROR_NOT_IMPLEMENTED;
}

NS_IMETHODIMP MicrobEalFilePicker::SetDisplayDirectory(nsILocalFile *aDisplayDirectory)
{
  return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsILocalFile file; */
NS_IMETHODIMP MicrobEalFilePicker::GetFile(nsILocalFile **aFile)
{
  NS_ENSURE_ARG_POINTER(aFile);

  nsCOMPtr<nsIURI> baseURI;
  *aFile = nsnull;
  nsresult rv = GetFileURL(getter_AddRefs(baseURI));
  if (!baseURI) {
    return rv;
  }
  nsCOMPtr<nsIFileURL> fileURL(do_QueryInterface(baseURI, &rv));
  NS_ENSURE_SUCCESS(rv, rv);

  nsCOMPtr<nsIFile> file;
  rv = fileURL->GetFile(getter_AddRefs(file));

  nsCOMPtr<nsILocalFile> localfile;
  localfile = do_QueryInterface(file, &rv);

  if (NS_SUCCEEDED(rv)) {
    NS_ADDREF(*aFile = localfile);
    return NS_OK;
  }

  NS_ENSURE_TRUE(mParent, NS_OK);
  GMozillaEngine* parentWidget = GetGMozEngineForDOMWindow(mParent);
  NS_ENSURE_TRUE(parentWidget, NS_OK);
  g_signal_emit_by_name(GTK_OBJECT(parentWidget), "alert",
                        "File protocol not supported.", NULL);
  return NS_OK;
}

/* readonly attribute nsIFileURL fileURL; */
NS_IMETHODIMP MicrobEalFilePicker::GetFileURL(nsIURI **aFileURL)
{
  NS_ENSURE_ARG_POINTER(aFileURL);
  *aFileURL = nsnull;

  if (mFileURI.IsEmpty()) {
    return NS_OK;
  }

  return NS_NewURI(aFileURL, mFileURI);
}

/* readonly attribute nsISimpleEnumerator files; */
NS_IMETHODIMP MicrobEalFilePicker::GetFiles(nsISimpleEnumerator * *aFiles)
{
  return NS_ERROR_NOT_IMPLEMENTED;
}

/* short show (); */
NS_IMETHODIMP MicrobEalFilePicker::Show(PRInt16 *_retval)
{
  NS_ENSURE_ARG_POINTER(_retval);
  NS_ENSURE_TRUE(mParent, NS_OK);

  GObject* parentWidget;
  GetGMozEngineForDOMWindow(mParent, &parentWidget);
  NS_ENSURE_TRUE(parentWidget, NS_OK);

  gboolean response = 0;
  char *retname = nsnull;
  g_signal_emit_by_name(parentWidget,
                        "upload_dialog",
                        PR_GetEnv("HOME"),
                        mFilters.get(),
                        &retname,
                        &response,
                        NULL);

  *_retval = response ? (PRInt16) nsIFilePicker::returnOK : (PRInt16) nsIFilePicker::returnCancel;

  mFileURI = retname;
  if (retname) {
    NS_Free(retname);
  }
  return NS_OK;
}
