
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the MICROB EAL package.
 *
 * The Initial Developer of the Original Code is Nokia Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contact: Oleg Romashin <oleg.romashin@nokia.com>
 *
 * ***** END LICENSE BLOCK ***** */



#include "testgmozillaweb.h"
#include "tests_common.h"

#include <assert.h>
#include <Automated.h>

#include <stdio.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "common.h"
#include "gmozillaengine.h"
#include "gmozillaweb.h"
#include "gmozillapluginlist.h"
#include "gmozillahistorylist.h"
#include "gtkmozembed.h"
#include "gmozillamarshal.h"
#include "gmozillatransferitem.h"
#include "gmozillatransferitemlist.h"
#include "gmozillapassman.h"
#include <glib/gstdio.h>
#include "gmozillacppwrapper.h"
#include <libosso.h>
#include <malloc.h>
#include <plstr.h>
#include <gwebwidget.h>
#ifdef USE_OPENSSL
#include <openssl/x509.h>
#endif
#ifdef USE_CST
#include <cst.h>
#endif
#include <unistd.h>
#include <string.h>
#include "microb_eal_components.h"
#ifdef MOZEAL_LOGGING
#endif
#ifdef UNUSED
#endif /*UNUSED*/
#ifdef USE_HILDON
#endif
#ifdef MICROB_GTK_MOZ_EMBED
#endif
#ifdef UNUSED
#endif /*UNUSED*/
#ifdef UNUSED
#endif /*UNUSED*/
#ifdef MOZEAL_LOGGING
#endif
#if 0
#endif
#if 0
#endif
#if 0
#endif
#if 0
#endif
#if 0
#endif
#if 0
#else
#endif
#if 0
#else
#endif
#if 0
#else
#endif
#ifdef USE_HILDON2007
#endif
#ifdef USE_HILDON
#endif
#ifdef USE_HILDON
#endif

typedef struct {
    GMozillaEngine* engine;
    gboolean* remember;
    gint* action;
    gint expire;
    gchar* url;
    gchar* name;
    gchar* value;
    gchar* domain;
    gchar* path;
} GMozillaWebAskCookieStruct;
typedef struct {
    GMozillaWeb* self;
    gboolean expected_retvalue;
} GMozillaWebCheckBusStruct;
typedef struct {
    GMozillaEngine* engine;
    char* title;
    char* text;
    guint bt_flags;
    char* button1;
    char* button2;
    char* button3;
    char* check_msg;
    gboolean* check_val;
    gint expected_retvalue;
} GMozillaWebConfirmExStruct;
typedef struct {
    GMozillaWeb* self;
} GMozillaWebCreateWebBusesStruct;
typedef struct {
    GMozillaWeb* self;
} GMozillaWebDestroyWebBusStruct;
typedef struct {
    GType expected_retvalue;
} GMozillaWebGetTypeStruct;
typedef struct {
    GMozillaWeb* self;
} GMozillaWebPauseAllTransferItemStruct;
typedef struct {
    GMozillaEngine* engine;
    gchar* dialog_title;
    gchar* dialog_msg;
    gchar** default_msg;
    gchar* check_msg;
    gboolean* check_value;
    gboolean expected_retvalue;
} GMozillaWebPromptStruct;
typedef struct {
    GMozillaEngine* engine;
    GObject* mozembed;
    gchar* dialog_title;
    gchar* dialog_msg;
    gchar** user_name;
    gchar** user_passwd;
    gchar* check_msg;
    gboolean* check_value;
    gboolean expected_retvalue;
} GMozillaWebPromptAuthStruct;
typedef struct {
    GMozillaEngine* engine;
    gchar* dialog_title;
    gchar* dialog_text;
    gpointer dialog_options;
    gpointer dialog_choice;
    gboolean expected_retvalue;
} GMozillaWebSelectStruct;
typedef struct {
    GMozillaWeb* self;
    gchar* home_page;
    GWebStatus expected_retvalue;
} GMozillaWebSetDefaultHomePageStruct;
typedef struct {
    GMozillaWeb* self;
    gchar* home_page;
    GWebStatus expected_retvalue;
} GMozillaWebSetHomePageStruct;
typedef struct {
    GObject* expected_retvalue;
} GWebNewStruct;
typedef struct {
} GWebSetEnvStruct;

typedef struct {
    gboolean automatic;
    gboolean basics;
    TestTableData g_mozilla_web_ask_cookie;
    TestTableData g_mozilla_web_check_bus;
    TestTableData g_mozilla_web_confirm_ex;
    TestTableData g_mozilla_web_create_web_buses;
    TestTableData g_mozilla_web_destroy_web_bus;
    TestTableData g_mozilla_web_get_type;
    TestTableData g_mozilla_web_pause_all_transfer_item;
    TestTableData g_mozilla_web_prompt;
    TestTableData g_mozilla_web_prompt_auth;
    TestTableData g_mozilla_web_select;
    TestTableData g_mozilla_web_set_default_home_page;
    TestTableData g_mozilla_web_set_home_page;
    TestTableData g_web_new;
    TestTableData g_web_set_env;
} TestData;
TestData testdata;
static void init_test_data()
{
    testdata.automatic = FALSE;
    testdata.basics = FALSE;

    g_list_free(testdata.g_mozilla_web_ask_cookie.table);
    testdata.g_mozilla_web_ask_cookie.table = NULL;
    testdata.g_mozilla_web_ask_cookie.index = -1;

    g_list_free(testdata.g_mozilla_web_check_bus.table);
    testdata.g_mozilla_web_check_bus.table = NULL;
    testdata.g_mozilla_web_check_bus.index = -1;

    g_list_free(testdata.g_mozilla_web_confirm_ex.table);
    testdata.g_mozilla_web_confirm_ex.table = NULL;
    testdata.g_mozilla_web_confirm_ex.index = -1;

    g_list_free(testdata.g_mozilla_web_create_web_buses.table);
    testdata.g_mozilla_web_create_web_buses.table = NULL;
    testdata.g_mozilla_web_create_web_buses.index = -1;

    g_list_free(testdata.g_mozilla_web_destroy_web_bus.table);
    testdata.g_mozilla_web_destroy_web_bus.table = NULL;
    testdata.g_mozilla_web_destroy_web_bus.index = -1;

    g_list_free(testdata.g_mozilla_web_get_type.table);
    testdata.g_mozilla_web_get_type.table = NULL;
    testdata.g_mozilla_web_get_type.index = -1;

    g_list_free(testdata.g_mozilla_web_pause_all_transfer_item.table);
    testdata.g_mozilla_web_pause_all_transfer_item.table = NULL;
    testdata.g_mozilla_web_pause_all_transfer_item.index = -1;

    g_list_free(testdata.g_mozilla_web_prompt.table);
    testdata.g_mozilla_web_prompt.table = NULL;
    testdata.g_mozilla_web_prompt.index = -1;

    g_list_free(testdata.g_mozilla_web_prompt_auth.table);
    testdata.g_mozilla_web_prompt_auth.table = NULL;
    testdata.g_mozilla_web_prompt_auth.index = -1;

    g_list_free(testdata.g_mozilla_web_select.table);
    testdata.g_mozilla_web_select.table = NULL;
    testdata.g_mozilla_web_select.index = -1;

    g_list_free(testdata.g_mozilla_web_set_default_home_page.table);
    testdata.g_mozilla_web_set_default_home_page.table = NULL;
    testdata.g_mozilla_web_set_default_home_page.index = -1;

    g_list_free(testdata.g_mozilla_web_set_home_page.table);
    testdata.g_mozilla_web_set_home_page.table = NULL;
    testdata.g_mozilla_web_set_home_page.index = -1;

    g_list_free(testdata.g_web_new.table);
    testdata.g_web_new.table = NULL;
    testdata.g_web_new.index = -1;

    g_list_free(testdata.g_web_set_env.table);
    testdata.g_web_set_env.table = NULL;
    testdata.g_web_set_env.index = -1;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_mozilla_web_ask_cookie(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_web_ask_cookie");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.g_mozilla_web_ask_cookie.index;
        printf("Index of test data: %i\n", test_index);
        GMozillaWebAskCookieStruct* test_item_data =
            (GMozillaWebAskCookieStruct*)g_list_nth_data(testdata.g_mozilla_web_ask_cookie.table, test_index);
        testdata.g_mozilla_web_ask_cookie.index++;
        GMozillaEngine* engine = test_item_data->engine;
        gboolean* remember = test_item_data->remember;
        gint* action = test_item_data->action;
        gint expire = test_item_data->expire;
        const gchar* url = test_item_data->url;
        const gchar* name = test_item_data->name;
        const gchar* value = test_item_data->value;
        const gchar* domain = test_item_data->domain;
        const gchar* path = test_item_data->path;
        if(testdata.basics) {
            g_mozilla_web_ask_cookie(engine,remember,action,expire,url,name,value,domain,path);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            g_mozilla_web_ask_cookie(engine,remember,action,expire,url,name,value,domain,path);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_mozilla_web_check_bus(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_web_check_bus");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.g_mozilla_web_check_bus.index;
        printf("Index of test data: %i\n", test_index);
        GMozillaWebCheckBusStruct* test_item_data =
            (GMozillaWebCheckBusStruct*)g_list_nth_data(testdata.g_mozilla_web_check_bus.table, test_index);
        testdata.g_mozilla_web_check_bus.index++;
        GMozillaWeb* self = test_item_data->self;
        gboolean retvalue;
        if(testdata.basics) {
            retvalue = g_mozilla_web_check_bus(self);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            gboolean expected_retvalue = test_item_data->expected_retvalue;
            retvalue = g_mozilla_web_check_bus(self);
            CU_ASSERT_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_mozilla_web_confirm_ex(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_web_confirm_ex");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.g_mozilla_web_confirm_ex.index;
        printf("Index of test data: %i\n", test_index);
        GMozillaWebConfirmExStruct* test_item_data =
            (GMozillaWebConfirmExStruct*)g_list_nth_data(testdata.g_mozilla_web_confirm_ex.table, test_index);
        testdata.g_mozilla_web_confirm_ex.index++;
        GMozillaEngine* engine = test_item_data->engine;
        const char* title = test_item_data->title;
        const char* text = test_item_data->text;
        guint bt_flags = test_item_data->bt_flags;
        const char* button1 = test_item_data->button1;
        const char* button2 = test_item_data->button2;
        const char* button3 = test_item_data->button3;
        const char* check_msg = test_item_data->check_msg;
        gboolean* check_val = test_item_data->check_val;
        gint retvalue;
        if(testdata.basics) {
            retvalue = g_mozilla_web_confirm_ex(engine,title,text,bt_flags,button1,button2,button3,check_msg,check_val);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            gint expected_retvalue = test_item_data->expected_retvalue;
            retvalue = g_mozilla_web_confirm_ex(engine,title,text,bt_flags,button1,button2,button3,check_msg,check_val);
            CU_ASSERT_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_mozilla_web_create_web_buses(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_web_create_web_buses");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.g_mozilla_web_create_web_buses.index;
        printf("Index of test data: %i\n", test_index);
        GMozillaWebCreateWebBusesStruct* test_item_data =
            (GMozillaWebCreateWebBusesStruct*)g_list_nth_data(testdata.g_mozilla_web_create_web_buses.table, test_index);
        testdata.g_mozilla_web_create_web_buses.index++;
        GMozillaWeb* self = test_item_data->self;
        if(testdata.basics) {
            g_mozilla_web_create_web_buses(self);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            g_mozilla_web_create_web_buses(self);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_mozilla_web_destroy_web_bus(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_web_destroy_web_bus");

    if(testdata.automatic)
    {
        CU_FAIL("//PRIVATE Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        /*
        gint test_index = testdata.g_mozilla_web_destroy_web_bus.index;
        printf("Index of test data: %i\n", test_index);
        GMozillaWebDestroyWebBusStruct* test_item_data =
            (GMozillaWebDestroyWebBusStruct*)g_list_nth_data(testdata.g_mozilla_web_destroy_web_bus.table, test_index);
        testdata.g_mozilla_web_destroy_web_bus.index++;
        GMozillaWeb* self = test_item_data->self;
        if(testdata.basics) {
            g_mozilla_web_destroy_web_bus(self);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            g_mozilla_web_destroy_web_bus(self);
            printf("Advanced test runned.\n");
        }
         */
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_mozilla_web_get_type(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_web_get_type");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.g_mozilla_web_get_type.index;
        printf("Index of test data: %i\n", test_index);
        GMozillaWebGetTypeStruct* test_item_data =
            (GMozillaWebGetTypeStruct*)g_list_nth_data(testdata.g_mozilla_web_get_type.table, test_index);
        testdata.g_mozilla_web_get_type.index++;
        GType retvalue;
        if(testdata.basics) {
            retvalue = g_mozilla_web_get_type();
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            GType expected_retvalue = test_item_data->expected_retvalue;
            retvalue = g_mozilla_web_get_type();
            CU_ASSERT_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_mozilla_web_pause_all_transfer_item(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_web_pause_all_transfer_item");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.g_mozilla_web_pause_all_transfer_item.index;
        printf("Index of test data: %i\n", test_index);
        GMozillaWebPauseAllTransferItemStruct* test_item_data =
            (GMozillaWebPauseAllTransferItemStruct*)g_list_nth_data(testdata.g_mozilla_web_pause_all_transfer_item.table, test_index);
        testdata.g_mozilla_web_pause_all_transfer_item.index++;
        GMozillaWeb* self = test_item_data->self;
        if(testdata.basics) {
            g_mozilla_web_pause_all_transfer_item(self);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            g_mozilla_web_pause_all_transfer_item(self);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_mozilla_web_prompt(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_web_prompt");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.g_mozilla_web_prompt.index;
        printf("Index of test data: %i\n", test_index);
        GMozillaWebPromptStruct* test_item_data =
            (GMozillaWebPromptStruct*)g_list_nth_data(testdata.g_mozilla_web_prompt.table, test_index);
        testdata.g_mozilla_web_prompt.index++;
        GMozillaEngine* engine = test_item_data->engine;
        const gchar* dialog_title = test_item_data->dialog_title;
        const gchar* dialog_msg = test_item_data->dialog_msg;
        gchar** default_msg = test_item_data->default_msg;
        const gchar* check_msg = test_item_data->check_msg;
        gboolean* check_value = test_item_data->check_value;
        gboolean retvalue;
        if(testdata.basics) {
            retvalue = g_mozilla_web_prompt(engine,dialog_title,dialog_msg,default_msg,check_msg,check_value);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            gboolean expected_retvalue = test_item_data->expected_retvalue;
            retvalue = g_mozilla_web_prompt(engine,dialog_title,dialog_msg,default_msg,check_msg,check_value);
            CU_ASSERT_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_mozilla_web_prompt_auth(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_web_prompt_auth");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.g_mozilla_web_prompt_auth.index;
        printf("Index of test data: %i\n", test_index);
        GMozillaWebPromptAuthStruct* test_item_data =
            (GMozillaWebPromptAuthStruct*)g_list_nth_data(testdata.g_mozilla_web_prompt_auth.table, test_index);
        testdata.g_mozilla_web_prompt_auth.index++;
        GMozillaEngine* engine = test_item_data->engine;
        GObject* mozembed = test_item_data->mozembed;
        const gchar* dialog_title = test_item_data->dialog_title;
        const gchar* dialog_msg = test_item_data->dialog_msg;
        gchar** user_name = test_item_data->user_name;
        gchar** user_passwd = test_item_data->user_passwd;
        const gchar* check_msg = test_item_data->check_msg;
        gboolean* check_value = test_item_data->check_value;
        gboolean retvalue;
        if(testdata.basics) {
            retvalue = g_mozilla_web_prompt_auth(engine,mozembed,dialog_title,dialog_msg,user_name,user_passwd,check_msg,check_value);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            gboolean expected_retvalue = test_item_data->expected_retvalue;
            retvalue = g_mozilla_web_prompt_auth(engine,mozembed,dialog_title,dialog_msg,user_name,user_passwd,check_msg,check_value);
            CU_ASSERT_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_mozilla_web_select(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_web_select");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.g_mozilla_web_select.index;
        printf("Index of test data: %i\n", test_index);
        GMozillaWebSelectStruct* test_item_data =
            (GMozillaWebSelectStruct*)g_list_nth_data(testdata.g_mozilla_web_select.table, test_index);
        testdata.g_mozilla_web_select.index++;
        GMozillaEngine* engine = test_item_data->engine;
        const gchar* dialog_title = test_item_data->dialog_title;
        const gchar* dialog_text = test_item_data->dialog_text;
        gpointer dialog_options = test_item_data->dialog_options;
        gpointer dialog_choice = test_item_data->dialog_choice;
        gboolean retvalue;
        if(testdata.basics) {
            retvalue = g_mozilla_web_select(engine,dialog_title,dialog_text,dialog_options,dialog_choice);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            gboolean expected_retvalue = test_item_data->expected_retvalue;
            retvalue = g_mozilla_web_select(engine,dialog_title,dialog_text,dialog_options,dialog_choice);
            CU_ASSERT_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_mozilla_web_set_default_home_page(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_web_set_default_home_page");

    if(testdata.automatic)
    {
        CU_FAIL("//PRIVATE Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        /*
        gint test_index = testdata.g_mozilla_web_set_default_home_page.index;
        printf("Index of test data: %i\n", test_index);
        GMozillaWebSetDefaultHomePageStruct* test_item_data =
            (GMozillaWebSetDefaultHomePageStruct*)g_list_nth_data(testdata.g_mozilla_web_set_default_home_page.table, test_index);
        testdata.g_mozilla_web_set_default_home_page.index++;
        GMozillaWeb* self = test_item_data->self;
         const gchar* home_page = test_item_data->home_page;
        GWebStatus retvalue;
        if(testdata.basics) {
            retvalue = g_mozilla_web_set_default_home_page(self,home_page);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            GWebStatus expected_retvalue = test_item_data->expected_retvalue;
            retvalue = g_mozilla_web_set_default_home_page(self,home_page);
            CU_ASSERT_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }
         */
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_mozilla_web_set_home_page(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_web_set_home_page");

    if(testdata.automatic)
    {
        CU_FAIL("//PRIVATE Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        /*
        gint test_index = testdata.g_mozilla_web_set_home_page.index;
        printf("Index of test data: %i\n", test_index);
        GMozillaWebSetHomePageStruct* test_item_data =
            (GMozillaWebSetHomePageStruct*)g_list_nth_data(testdata.g_mozilla_web_set_home_page.table, test_index);
        testdata.g_mozilla_web_set_home_page.index++;
        GMozillaWeb* self = test_item_data->self;
         const gchar* home_page = test_item_data->home_page;
        GWebStatus retvalue;
        if(testdata.basics) {
            retvalue = g_mozilla_web_set_home_page(self,home_page);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            GWebStatus expected_retvalue = test_item_data->expected_retvalue;
            retvalue = g_mozilla_web_set_home_page(self,home_page);
            CU_ASSERT_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }*/
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_web_new(void)
{

    DEBUG_FUNCTIONS_STARTED("g_web_new");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.g_web_new.index;
        printf("Index of test data: %i\n", test_index);
        GWebNewStruct* test_item_data =
            (GWebNewStruct*)g_list_nth_data(testdata.g_web_new.table, test_index);
        testdata.g_web_new.index++;
        GObject* retvalue;
        if(testdata.basics) {
            retvalue = g_web_new();
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            GObject* expected_retvalue = test_item_data->expected_retvalue;
            retvalue = g_web_new();
            CU_ASSERT_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_web_set_env(void)
{

    DEBUG_FUNCTIONS_STARTED("g_web_set_env");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.g_web_set_env.index;
        printf("Index of test data: %i\n", test_index);
        GWebSetEnvStruct* test_item_data =
            (GWebSetEnvStruct*)g_list_nth_data(testdata.g_web_set_env.table, test_index);
        testdata.g_web_set_env.index++;
        if(testdata.basics) {
            g_web_set_env();
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            g_web_set_env();
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * Init function created by test creation script. It is success always.
 */
static int
testgmozillaweb_automatic_init()
{
    INIT_OR_CLEAN_STARTED("testgmozillaweb_init");
    //init_test_data();
    testdata.automatic = TRUE;
    return 0;
}

/**
 * Clean function created by test creation script. It is success always.
 */
static int
testgmozillaweb_automatic_clean()
{
    INIT_OR_CLEAN_STARTED("testgmozillaweb_clean");
    testdata.automatic = FALSE;
    return 0;
}

/**
 * Init function created by test creation script. It is success always.
 */
static int
testgmozillaweb_basics_init()
{
    INIT_OR_CLEAN_STARTED("testgmozillaweb_basics_init");
    g_type_init();
    init_test_data();
    testdata.basics = TRUE;
    GMozillaWebAskCookieStruct* tmp_g_mozilla_web_ask_cookie = g_new0(GMozillaWebAskCookieStruct, 1);
    /* GMozillaEngine* */tmp_g_mozilla_web_ask_cookie->engine = NULL;
    /* gboolean* */tmp_g_mozilla_web_ask_cookie->remember = NULL;
    /* gint* */tmp_g_mozilla_web_ask_cookie->action = NULL;
    /* gint */tmp_g_mozilla_web_ask_cookie->expire = 0;
    /* const gchar* */tmp_g_mozilla_web_ask_cookie->url = NULL;
    /* const gchar* */tmp_g_mozilla_web_ask_cookie->name = NULL;
    /* const gchar* */tmp_g_mozilla_web_ask_cookie->value = NULL;
    /* const gchar* */tmp_g_mozilla_web_ask_cookie->domain = NULL;
    /* const gchar* */tmp_g_mozilla_web_ask_cookie->path = NULL;
    testdata.g_mozilla_web_ask_cookie.table =
        g_list_append (testdata.g_mozilla_web_ask_cookie.table, tmp_g_mozilla_web_ask_cookie);
    testdata.g_mozilla_web_ask_cookie.index = 0;

    GMozillaWebCheckBusStruct* tmp_g_mozilla_web_check_bus = g_new0(GMozillaWebCheckBusStruct, 1);
    /* GMozillaWeb* */tmp_g_mozilla_web_check_bus->self = NULL;
    /* gboolean */tmp_g_mozilla_web_check_bus->expected_retvalue = 0;
    testdata.g_mozilla_web_check_bus.table =
        g_list_append (testdata.g_mozilla_web_check_bus.table, tmp_g_mozilla_web_check_bus);
    testdata.g_mozilla_web_check_bus.index = 0;

    GMozillaWebConfirmExStruct* tmp_g_mozilla_web_confirm_ex = g_new0(GMozillaWebConfirmExStruct, 1);
    /* GMozillaEngine* */tmp_g_mozilla_web_confirm_ex->engine = NULL;
    /* const char* */tmp_g_mozilla_web_confirm_ex->title = NULL;
    /* const char* */tmp_g_mozilla_web_confirm_ex->text = NULL;
    /* guint */tmp_g_mozilla_web_confirm_ex->bt_flags = 0;
    /* const char* */tmp_g_mozilla_web_confirm_ex->button1 = NULL;
    /* const char* */tmp_g_mozilla_web_confirm_ex->button2 = NULL;
    /* const char* */tmp_g_mozilla_web_confirm_ex->button3 = NULL;
    /* const char* */tmp_g_mozilla_web_confirm_ex->check_msg = NULL;
    /* gboolean* */tmp_g_mozilla_web_confirm_ex->check_val = NULL;
    /* gint */tmp_g_mozilla_web_confirm_ex->expected_retvalue = 0;
    testdata.g_mozilla_web_confirm_ex.table =
        g_list_append (testdata.g_mozilla_web_confirm_ex.table, tmp_g_mozilla_web_confirm_ex);
    testdata.g_mozilla_web_confirm_ex.index = 0;

    GMozillaWebCreateWebBusesStruct* tmp_g_mozilla_web_create_web_buses = g_new0(GMozillaWebCreateWebBusesStruct, 1);
    /* GMozillaWeb* */tmp_g_mozilla_web_create_web_buses->self = NULL;
    testdata.g_mozilla_web_create_web_buses.table =
        g_list_append (testdata.g_mozilla_web_create_web_buses.table, tmp_g_mozilla_web_create_web_buses);
    testdata.g_mozilla_web_create_web_buses.index = 0;

    GMozillaWebDestroyWebBusStruct* tmp_g_mozilla_web_destroy_web_bus = g_new0(GMozillaWebDestroyWebBusStruct, 1);
    /* GMozillaWeb* */tmp_g_mozilla_web_destroy_web_bus->self = NULL;
    testdata.g_mozilla_web_destroy_web_bus.table =
        g_list_append (testdata.g_mozilla_web_destroy_web_bus.table, tmp_g_mozilla_web_destroy_web_bus);
    testdata.g_mozilla_web_destroy_web_bus.index = 0;

    GMozillaWebGetTypeStruct* tmp_g_mozilla_web_get_type = g_new0(GMozillaWebGetTypeStruct, 1);
    /* GType */tmp_g_mozilla_web_get_type->expected_retvalue = 0;
    testdata.g_mozilla_web_get_type.table =
        g_list_append (testdata.g_mozilla_web_get_type.table, tmp_g_mozilla_web_get_type);
    testdata.g_mozilla_web_get_type.index = 0;

    GMozillaWebPauseAllTransferItemStruct* tmp_g_mozilla_web_pause_all_transfer_item = g_new0(GMozillaWebPauseAllTransferItemStruct, 1);
    /* GMozillaWeb* */tmp_g_mozilla_web_pause_all_transfer_item->self = NULL;
    testdata.g_mozilla_web_pause_all_transfer_item.table =
        g_list_append (testdata.g_mozilla_web_pause_all_transfer_item.table, tmp_g_mozilla_web_pause_all_transfer_item);
    testdata.g_mozilla_web_pause_all_transfer_item.index = 0;

    GMozillaWebPromptStruct* tmp_g_mozilla_web_prompt = g_new0(GMozillaWebPromptStruct, 1);
    /* GMozillaEngine* */tmp_g_mozilla_web_prompt->engine = NULL;
    /* const gchar* */tmp_g_mozilla_web_prompt->dialog_title = NULL;
    /* const gchar* */tmp_g_mozilla_web_prompt->dialog_msg = NULL;
    /* gchar** */tmp_g_mozilla_web_prompt->default_msg = NULL;
    /* const gchar* */tmp_g_mozilla_web_prompt->check_msg = NULL;
    /* gboolean* */tmp_g_mozilla_web_prompt->check_value = NULL;
    /* gboolean */tmp_g_mozilla_web_prompt->expected_retvalue = 0;
    testdata.g_mozilla_web_prompt.table =
        g_list_append (testdata.g_mozilla_web_prompt.table, tmp_g_mozilla_web_prompt);
    testdata.g_mozilla_web_prompt.index = 0;

    GMozillaWebPromptAuthStruct* tmp_g_mozilla_web_prompt_auth = g_new0(GMozillaWebPromptAuthStruct, 1);
    /* GMozillaEngine* */tmp_g_mozilla_web_prompt_auth->engine = NULL;
    /* GObject* */tmp_g_mozilla_web_prompt_auth->mozembed = NULL;
    /* const gchar* */tmp_g_mozilla_web_prompt_auth->dialog_title = NULL;
    /* const gchar* */tmp_g_mozilla_web_prompt_auth->dialog_msg = NULL;
    /* gchar** */tmp_g_mozilla_web_prompt_auth->user_name = NULL;
    /* gchar** */tmp_g_mozilla_web_prompt_auth->user_passwd = NULL;
    /* const gchar* */tmp_g_mozilla_web_prompt_auth->check_msg = NULL;
    /* gboolean* */tmp_g_mozilla_web_prompt_auth->check_value = NULL;
    /* gboolean */tmp_g_mozilla_web_prompt_auth->expected_retvalue = 0;
    testdata.g_mozilla_web_prompt_auth.table =
        g_list_append (testdata.g_mozilla_web_prompt_auth.table, tmp_g_mozilla_web_prompt_auth);
    testdata.g_mozilla_web_prompt_auth.index = 0;

    GMozillaWebSelectStruct* tmp_g_mozilla_web_select = g_new0(GMozillaWebSelectStruct, 1);
    /* GMozillaEngine* */tmp_g_mozilla_web_select->engine = NULL;
    /* const gchar* */tmp_g_mozilla_web_select->dialog_title = NULL;
    /* const gchar* */tmp_g_mozilla_web_select->dialog_text = NULL;
    /* gpointer */tmp_g_mozilla_web_select->dialog_options = NULL;
    /* gpointer */tmp_g_mozilla_web_select->dialog_choice = NULL;
    /* gboolean */tmp_g_mozilla_web_select->expected_retvalue = 0;
    testdata.g_mozilla_web_select.table =
        g_list_append (testdata.g_mozilla_web_select.table, tmp_g_mozilla_web_select);
    testdata.g_mozilla_web_select.index = 0;

    GMozillaWebSetDefaultHomePageStruct* tmp_g_mozilla_web_set_default_home_page = g_new0(GMozillaWebSetDefaultHomePageStruct, 1);
    /* GMozillaWeb* */tmp_g_mozilla_web_set_default_home_page->self = NULL;
    /* const gchar* */tmp_g_mozilla_web_set_default_home_page->home_page = NULL;
    /* GWebStatus */tmp_g_mozilla_web_set_default_home_page->expected_retvalue = 0;
    testdata.g_mozilla_web_set_default_home_page.table =
        g_list_append (testdata.g_mozilla_web_set_default_home_page.table, tmp_g_mozilla_web_set_default_home_page);
    testdata.g_mozilla_web_set_default_home_page.index = 0;

    GMozillaWebSetHomePageStruct* tmp_g_mozilla_web_set_home_page = g_new0(GMozillaWebSetHomePageStruct, 1);
    /* GMozillaWeb* */tmp_g_mozilla_web_set_home_page->self = NULL;
    /* const gchar* */tmp_g_mozilla_web_set_home_page->home_page = NULL;
    /* GWebStatus */tmp_g_mozilla_web_set_home_page->expected_retvalue = 0;
    testdata.g_mozilla_web_set_home_page.table =
        g_list_append (testdata.g_mozilla_web_set_home_page.table, tmp_g_mozilla_web_set_home_page);
    testdata.g_mozilla_web_set_home_page.index = 0;

    GWebNewStruct* tmp_g_web_new = g_new0(GWebNewStruct, 1);
    /* GObject* */tmp_g_web_new->expected_retvalue = 0;
    testdata.g_web_new.table =
        g_list_append (testdata.g_web_new.table, tmp_g_web_new);
    testdata.g_web_new.index = 0;

    GWebSetEnvStruct* tmp_g_web_set_env = g_new0(GWebSetEnvStruct, 1);
    testdata.g_web_set_env.table =
        g_list_append (testdata.g_web_set_env.table, tmp_g_web_set_env);
    testdata.g_web_set_env.index = 0;

    return 0;
}

/**
 * Clean function created by test creation script. It is success always.
 */
static int
testgmozillaweb_basics_clean()
{
    INIT_OR_CLEAN_STARTED("testgmozillaweb_basics_clean");
    testdata.basics = FALSE;
    return 0;
}

/**
 * Init function created by test creation script. It is success always.
 */
static int
testgmozillaweb_advanced_init()
{
    INIT_OR_CLEAN_STARTED("testgmozillaweb_advanced_init");
    g_type_init();
    init_test_data();
    return 0;
}

/**
 * Clean function created by test creation script. It is success always.
 */
static int
testgmozillaweb_advanced_clean()
{
    INIT_OR_CLEAN_STARTED("testgmozillaweb_advanced_clean");
    return 0;
}


/**
 * All new test cases are going to start from here. They are also added to automatic suite.
 * DO NOT DELETE AUTOMATIC SUITE!
 */

static CU_TestInfo testgmozillaweb_automatic_added[] = {
        // Test is made { "test_g_mozilla_web_ask_cookie", test_g_mozilla_web_ask_cookie },
        /*NEW*/{ "test_g_mozilla_web_check_bus", test_g_mozilla_web_check_bus },
        // Test is made { "test_g_mozilla_web_confirm_ex", test_g_mozilla_web_confirm_ex },
        /*NEW*/{ "test_g_mozilla_web_create_web_buses", test_g_mozilla_web_create_web_buses },
        /*PRIVATE*/{ "test_g_mozilla_web_destroy_web_bus", test_g_mozilla_web_destroy_web_bus },
        // Test is made { "test_g_mozilla_web_get_type", test_g_mozilla_web_get_type },
        { "test_g_mozilla_web_pause_all_transfer_item", test_g_mozilla_web_pause_all_transfer_item },
        // Test is made { "test_g_mozilla_web_prompt", test_g_mozilla_web_prompt },
        // Test is made { "test_g_mozilla_web_prompt_auth", test_g_mozilla_web_prompt_auth },
        // Test is made { "test_g_mozilla_web_select", test_g_mozilla_web_select },
        /*PRIVATE*/{ "test_g_mozilla_web_set_default_home_page", test_g_mozilla_web_set_default_home_page },
        /*PRIVATE*/{ "test_g_mozilla_web_set_home_page", test_g_mozilla_web_set_home_page },
        // Test is made { "test_g_web_new", test_g_web_new },
        // Test is made { "test_g_web_set_env", test_g_web_set_env },
        CU_TEST_INFO_NULL, //null terminated
};
static CU_TestInfo testgmozillaweb_basics[] = {
        { "test_g_mozilla_web_ask_cookie", test_g_mozilla_web_ask_cookie },
        //NEW { "test_g_mozilla_web_check_bus", test_g_mozilla_web_check_bus },
        { "test_g_mozilla_web_confirm_ex", test_g_mozilla_web_confirm_ex },
        //NEW { "test_g_mozilla_web_create_web_buses", test_g_mozilla_web_create_web_buses },
        //NEW & PRIVATE { "test_g_mozilla_web_destroy_web_bus", test_g_mozilla_web_destroy_web_bus },
        { "test_g_mozilla_web_get_type", test_g_mozilla_web_get_type },
        //TODO: Segmentation fault, investigate { "test_g_mozilla_web_pause_all_transfer_item", test_g_mozilla_web_pause_all_transfer_item },
        { "test_g_mozilla_web_prompt", test_g_mozilla_web_prompt },
        { "test_g_mozilla_web_prompt_auth", test_g_mozilla_web_prompt_auth },
        { "test_g_mozilla_web_select", test_g_mozilla_web_select },
        //NEW & PRIVATE { "test_g_mozilla_web_set_default_home_page", test_g_mozilla_web_set_default_home_page },
        //PRIVATE { "test_g_mozilla_web_set_home_page", test_g_mozilla_web_set_home_page },
        { "test_g_web_new", test_g_web_new },
        { "test_g_web_set_env", test_g_web_set_env },
        CU_TEST_INFO_NULL, //null terminated
};
static CU_TestInfo testgmozillaweb_advanced[] = {
        //{ "test_g_mozilla_web_ask_cookie", test_g_mozilla_web_ask_cookie },
        ////NEW { "test_g_mozilla_web_check_bus", test_g_mozilla_web_check_bus },
        //{ "test_g_mozilla_web_confirm_ex", test_g_mozilla_web_confirm_ex },
        ////NEW { "test_g_mozilla_web_create_web_buses", test_g_mozilla_web_create_web_buses },
        ////NEW & PRIVATE { "test_g_mozilla_web_destroy_web_bus", test_g_mozilla_web_destroy_web_bus },
        //{ "test_g_mozilla_web_get_type", test_g_mozilla_web_get_type },
        //{ "test_g_mozilla_web_pause_all_transfer_item", test_g_mozilla_web_pause_all_transfer_item },
        //{ "test_g_mozilla_web_prompt", test_g_mozilla_web_prompt },
        //{ "test_g_mozilla_web_prompt_auth", test_g_mozilla_web_prompt_auth },
        //{ "test_g_mozilla_web_select", test_g_mozilla_web_select },
        ////NEW & PRIVATE { "test_g_mozilla_web_set_default_home_page", test_g_mozilla_web_set_default_home_page },
        ////PRIVATE { "test_g_mozilla_web_set_home_page", test_g_mozilla_web_set_home_page },
        //{ "test_g_web_new", test_g_web_new },
        //{ "test_g_web_set_env", test_g_web_set_env },
        CU_TEST_INFO_NULL, //null terminated
};

/**
 * Main table holding all the test cases.
 */
CU_SuiteInfo testgmozillaweb[] = {
        {"testgmozillaweb_automatic_added", testgmozillaweb_automatic_init, testgmozillaweb_automatic_clean, testgmozillaweb_automatic_added },
        {"testgmozillaweb_basics", testgmozillaweb_basics_init, testgmozillaweb_basics_clean, testgmozillaweb_basics },
        {"testgmozillaweb_advanced", testgmozillaweb_advanced_init, testgmozillaweb_advanced_clean, testgmozillaweb_advanced },
        CU_SUITE_INFO_NULL, //null terminated
};
