/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Nokia code.
 *
 * The Initial Developer of the Original Code is Novell.
 * Portions created by the Initial Developer are Copyright (C) 2008
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Aiken Tie <ext-tie.aiken@nokia.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#ifndef TESTGMCPPW_H
#define TESTGMCPPW_H

#include <cppunit/extensions/HelperMacros.h>
#include <gtk/gtk.h>
#include <glib.h>
#include "gmozillaweb.h"
#include "gmozillaengine.h"


class Testgmcppw : public CppUnit::TestFixture
{
	CPPUNIT_TEST_SUITE( Testgmcppw );
	CPPUNIT_TEST(test_clear_all_passwords);
	CPPUNIT_TEST(test_clear_passwords_by_index1);
	CPPUNIT_TEST(test_clear_passwords_by_index2);
	CPPUNIT_TEST(test_clear_authenticated_sessions);
	CPPUNIT_TEST(test_get_logins);
	CPPUNIT_TEST(test_get_logins1);
	CPPUNIT_TEST(test_get_history_list);
	CPPUNIT_TEST(test_history_list_remove_all);
	CPPUNIT_TEST(test_shistory_list_remove_all);
	CPPUNIT_TEST(test_shistory_list_remove_all1);
	CPPUNIT_TEST(test_history_list_remove);
	CPPUNIT_TEST(test_history_list_remove1);
	CPPUNIT_TEST(test_download_setup);
	CPPUNIT_TEST(test_download_setup1);
	CPPUNIT_TEST(test_download_start);
	CPPUNIT_TEST(test_download_start1);
	CPPUNIT_TEST(test_download_pause);
	CPPUNIT_TEST(test_download_pause1);
	CPPUNIT_TEST(test_download_cancel);
	CPPUNIT_TEST(test_download_cancel1);
	CPPUNIT_TEST(test_get_downloads_count);
	CPPUNIT_TEST(test_get_download_items);
	CPPUNIT_TEST(test_get_download_items1);
	CPPUNIT_TEST(test_save_target1);
	CPPUNIT_TEST(test_save_target2);
	CPPUNIT_TEST(test_save_target3);
	CPPUNIT_TEST(test_save_target4);
	CPPUNIT_TEST(test_save_target5);
	CPPUNIT_TEST(test_save_target6);
	CPPUNIT_TEST(test_get_server_cert);
	CPPUNIT_TEST(test_get_page_verifier_name);
	CPPUNIT_TEST(test_get_page_verifier_name1);
	CPPUNIT_TEST(test_observe1);
	CPPUNIT_TEST(test_observe2);
	CPPUNIT_TEST(test_save_prefs);
	CPPUNIT_TEST(test_get_pref1);
	CPPUNIT_TEST(test_get_pref2);
	CPPUNIT_TEST(test_set_pref1);
	CPPUNIT_TEST(test_set_pref2);
	CPPUNIT_TEST(test_get_pref_type1);
	CPPUNIT_TEST(test_get_pref_type2);
	CPPUNIT_TEST(test_reflow_content);
	CPPUNIT_TEST(test_get_encoding);
	CPPUNIT_TEST(test_set_encoding);
	CPPUNIT_TEST(test_get_shistory_list);
	CPPUNIT_TEST(test_get_shistory_index);
	CPPUNIT_TEST(test_shistory_goto_index1);
	CPPUNIT_TEST(test_shistory_goto_index2);
	CPPUNIT_TEST(test_clipboard1);
	CPPUNIT_TEST(test_clipboard2);
	CPPUNIT_TEST(test_clipboard3);
	CPPUNIT_TEST(test_get_plugins_list);
	CPPUNIT_TEST(test_set_extension_status1);
	CPPUNIT_TEST(test_set_extension_status2);
	CPPUNIT_TEST(test_set_extension_status3);
	CPPUNIT_TEST(test_set_image_policy1);
	CPPUNIT_TEST(test_set_image_policy2);
	CPPUNIT_TEST(test_load_image1);
	CPPUNIT_TEST(test_load_image2);
	CPPUNIT_TEST(test_notification_button_pressed);
	CPPUNIT_TEST(test_permit_unload);
	CPPUNIT_TEST(test_draw_layout1);
	CPPUNIT_TEST(test_draw_layout2);
	CPPUNIT_TEST(test_draw_layout3);
	CPPUNIT_TEST(test_draw_layout4);
	CPPUNIT_TEST(test_send_event_to_layout1);
	CPPUNIT_TEST(test_send_event_to_layout2);
	CPPUNIT_TEST(test_send_event_to_layout3);
	CPPUNIT_TEST(test_send_event_to_layout4);
	CPPUNIT_TEST(test_get_security_mode);
	CPPUNIT_TEST(test_get_thumbnail1);
	CPPUNIT_TEST(test_get_thumbnail2);
	CPPUNIT_TEST(test_evaluate_js);
	CPPUNIT_TEST(test_get_text_zoom);
	CPPUNIT_TEST(test_set_text_zoom);
	CPPUNIT_TEST(test_delete_session_history_manager);
	CPPUNIT_TEST(test_initialize_extensions);
	CPPUNIT_TEST(test_get_element_info);
	CPPUNIT_TEST(test_send_element_info);
	CPPUNIT_TEST(test_get_mouse_over_element_info1);
	CPPUNIT_TEST(test_get_mouse_over_element_info2);
	CPPUNIT_TEST(test_select_widget_item_selected);
	CPPUNIT_TEST(test_create_select_widget);
	CPPUNIT_TEST(test_send_focused_element_message1);
	CPPUNIT_TEST(test_send_focused_element_message2);
	CPPUNIT_TEST_SUITE_END();


	public:
	void test_clear_all_passwords();
	void test_clear_passwords_by_index1();
	void test_clear_passwords_by_index2();
	void test_clear_authenticated_sessions();
	void test_get_logins();
	void test_get_logins1();
	void test_get_history_list();
	void test_history_list_remove_all();
	void test_shistory_list_remove_all();
	void test_shistory_list_remove_all1();
	void test_history_list_remove();
	void test_history_list_remove1();
	void test_download_setup();
	void test_download_setup1();
	void test_download_start();
	void test_download_start1();
	void test_download_pause();
	void test_download_pause1();
	void test_download_cancel();
	void test_download_cancel1();
	void test_get_downloads_count();
	void test_get_download_items();
	void test_get_download_items1();
	void test_save_target1();
	void test_save_target2();
	void test_save_target3();
	void test_save_target4();
	void test_save_target5();
	void test_save_target6();
	void test_get_server_cert();
	void test_get_page_verifier_name();
	void test_get_page_verifier_name1();
	void test_observe1();
	void test_observe2();
	void test_save_prefs();
	void test_get_pref1();
	void test_get_pref2();
	void test_set_pref1();
	void test_set_pref2();
	void test_get_pref_type1();
	void test_get_pref_type2();
	void test_reflow_content();
	void test_get_encoding();
	void test_set_encoding();
	void test_get_shistory_list();
	void test_get_shistory_index();
	void test_shistory_goto_index1();
	void test_shistory_goto_index2();
	void test_clipboard1();
	void test_clipboard2();
	void test_clipboard3();
	void test_get_plugins_list();
	void test_set_extension_status1();
	void test_set_extension_status2();
	void test_set_extension_status3();
	void test_set_image_policy1();
	void test_set_image_policy2();
	void test_load_image1();
	void test_load_image2();
	void test_notification_button_pressed();
	void test_permit_unload();
	void test_draw_layout1();
	void test_draw_layout2();
	void test_draw_layout3();
	void test_draw_layout4();
	void test_send_event_to_layout1();
	void test_send_event_to_layout2();
	void test_send_event_to_layout3();
	void test_send_event_to_layout4();
	void test_get_security_mode();
	void test_get_thumbnail1();
	void test_get_thumbnail2();
	void test_evaluate_js();
	void test_get_text_zoom();
	void test_set_text_zoom();
	void test_delete_session_history_manager();
	void test_initialize_extensions();
	void test_get_element_info();
	void test_send_element_info();
	void test_get_mouse_over_element_info1();
	void test_get_mouse_over_element_info2();
	void test_select_widget_item_selected();
	void test_create_select_widget();
	void test_send_focused_element_message1();
	void test_send_focused_element_message2();
	void setUp();
	void tearDown();
	GMozillaEngine *mozengine;
	GWebEngine *webengine;
};


#endif //TESTGMCPPW_H
