/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Nokia code.
 *
 * The Initial Developer of the Original Code is Novell.
 * Portions created by the Initial Developer are Copyright (C) 2008
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Aiken Tie <ext-tie.aiken@nokia.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include <nsError.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gtkmozembed.h>
#include <neteal.h>
#include <stdio.h>

#include "testgmcppw.h"
#include "CppUnitSignalException.h"

#include "gmozillacppwrapper.h"
#include "gmozillahistorylist.h"
#include "gtkmicrob_context.h"
#include "microb_eal_components.h"

// some test data

const char* SOME_CONST_STRING = "www.nokia.com";
char* SOME_STRING = "www.nokia.com";
const char* IMAGE_URL = "http://www.nokia.com/NOKIA_COM_1/Microsites/wayfinder/images/logo.gif";


CPPUNIT_TEST_SUITE_REGISTRATION( Testgmcppw );

void Testgmcppw::setUp()
{
	void (* web_set_env) (void) = NULL;
	GWeb* (* web_get_new) (void) = NULL;
	guint32 server = 0;
	guint32 connection = 0;
	GArray *g;
	gtk_init(NULL, NULL);

	// initialize neteal
	neteal_init();
	neteal_glookup_discovery_server(1000, 6);
	g = neteal_servers_list();
	if (g) {
		if (g && !g->len) {
			GString *s = g_string_new("mytestserver");
			gchar* serverName = s->str;
			server = neteal_server_create_fork(serverName);
		} else {
			server = g_array_index(g, guint32, 0);
		}
		g_array_free(g, TRUE);
	}
	connection = neteal_server_connect(server);
	neteal_set_current(connection);

	GModule* module = g_module_open("../.libs/libmicrob-eal.so.0", G_MODULE_BIND_LAZY);
	if (g_module_error())
		printf("\tModule error: %s\n", g_module_error());
	if (!g_module_symbol (module, "g_web_set_env", (gpointer *)&web_set_env))
		printf("\tg_web_set_env Function opened unsuccessefully\n");
	else
		printf("\tg_web_set_env Function opened successefully\n");

	if (!g_module_symbol (module, "g_web_new", (gpointer *)&web_get_new))
		printf("\tg_web_new Function opened unsuccessefully\n");
	else
		printf("\tg_web_new Function opened successefully\n");

	web_set_env();
	GWeb* web = web_get_new ();
	g_web_set_ua_string(web, "microb-eal-test");

	g_web_create_web_buses(web, "eal", "ui");
	GObject *global = g_web_get_global(web);

	printf("Open new Engine: %s\n", SOME_STRING);
	microb_eal_components_init();
	microb_eal_components_static_init();
	webengine = g_web_new_web_engine_window_with_context(web, NULL, FALSE, FALSE);
	GObject *engine_widget = g_web_engine_get_engine_widget(webengine);
	if (engine_widget) {
		gtk_widget_show(GTK_WIDGET(engine_widget));
	}
	mozengine = (GMozillaEngine*)G_WEB_GET_CLASS(web)->new_web_engine_window(web);
	g_web_engine_load_url(webengine, SOME_STRING);
}

void Testgmcppw::tearDown()
{
	mozengine = NULL;
	webengine = NULL;
}

void Testgmcppw::test_clear_all_passwords()
{
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(g_mozilla_cpp_clear_all_passwords());

//	you could find NS_OK and FALSE are equal to 0 by uncommenting following lines
//	printf("NS_OK is %d\n", NS_OK);
//	printf("FALSE is %d\n", FALSE);
//	printf("TRUE is %d\n", TRUE);
//	printf("PR_TRUE is %d\n", PR_TRUE);
//	printf("PR_FALSE is %d\n", PR_FALSE);
}

void Testgmcppw::test_clear_passwords_by_index1()
{
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(g_mozilla_cpp_clear_passwords_by_index(0));
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(g_mozilla_cpp_clear_passwords_by_index(5));
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(g_mozilla_cpp_clear_passwords_by_index(999));
}

void Testgmcppw::test_clear_passwords_by_index2()
{
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(g_mozilla_cpp_clear_passwords_by_index(-7));
}


void Testgmcppw::test_clear_authenticated_sessions()
{
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(g_mozilla_cpp_clear_authenticated_sessions());
}

//this will return number of logins, return 0 if any error happens or no logins
void Testgmcppw::test_get_logins()
{
	int retvalue = 0;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_cpp_get_logins(NULL, NULL));
	CPPUNIT_ASSERT(retvalue == 0);
}

void Testgmcppw::test_get_logins1()
{
	int retvalue = 0;
	GList *list = NULL;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_cpp_get_logins(SOME_CONST_STRING, &list));
	CPPUNIT_ASSERT(retvalue == 0);
}


//this will return number of history list, return 0 if any error happens or no logins
void Testgmcppw::test_get_history_list()
{
	gint retvalue = 0;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_cpp_get_history_list(NULL));
	CPPUNIT_ASSERT(retvalue == 0);
}

//return NS_OK if everything fine. Problem with return type
void Testgmcppw::test_history_list_remove_all()
{
	gint retvalue = 0;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_cpp_history_list_remove_all());
	CPPUNIT_ASSERT(retvalue != NS_OK );
}

//return NS_OK if everything fine. Problem with return type
void Testgmcppw::test_shistory_list_remove_all()
{
	gint retvalue = 0;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_cpp_shistory_list_remove_all(NULL));
	CPPUNIT_ASSERT(retvalue != NS_OK );
}

void Testgmcppw::test_shistory_list_remove_all1()
{
	gint retvalue = 0;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_cpp_shistory_list_remove_all(G_MOZILLA_WEB(mozengine->global)));
}

//return NS_OK if everything fine. Problem with return type
void Testgmcppw::test_history_list_remove()
{
	gint retvalue = 0;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_cpp_history_list_remove(NULL));
	CPPUNIT_ASSERT(retvalue != NS_OK);
}

void Testgmcppw::test_history_list_remove1()
{
	gint retvalue = 0;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_cpp_history_list_remove(SOME_CONST_STRING));
	CPPUNIT_ASSERT(retvalue != NS_OK);
}


//return NS_OK if everything fine. Problem with return type
void Testgmcppw::test_download_setup()
{
	int retvalue = 0;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_engine_download_setup(NULL, NULL));
	CPPUNIT_ASSERT(retvalue != NS_OK);
}

void Testgmcppw::test_download_setup1()
{
	int retvalue = 0;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_engine_download_setup(NULL, mozengine->global));
	CPPUNIT_ASSERT(retvalue != NS_OK);
}

//return NS_OK if everything fine. Problem with return type
void Testgmcppw::test_download_start()
{
	int retvalue = 0;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_engine_download_start(NULL));
	CPPUNIT_ASSERT(retvalue != NS_OK);
}

void Testgmcppw::test_download_start1()
{
	int retvalue = 0;
	GMozillaTransferItem *item = (GMozillaTransferItem*)g_mozilla_transfer_item_new_with_url(SOME_CONST_STRING, "index.html");
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_engine_download_start(item));
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_engine_download_pause(item));
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_engine_download_cancel(item));
}

//return NS_OK if everything fine. Problem with return type
void Testgmcppw::test_download_pause()
{
	int retvalue = 0;
	GMozillaTransferItem *item = (GMozillaTransferItem*)g_mozilla_transfer_item_new_with_url(SOME_CONST_STRING, "index.html");
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_engine_download_pause(NULL));
}

void Testgmcppw::test_download_pause1()
{
	int retvalue = 0;
	GMozillaTransferItem *item = (GMozillaTransferItem*)g_mozilla_transfer_item_new_with_url(SOME_CONST_STRING, "index.html");
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_engine_download_pause(NULL));
}


//return NS_OK if everything fine. Problem with return type
void Testgmcppw::test_download_cancel()
{
	int retvalue = 0;
	GMozillaTransferItem *item = (GMozillaTransferItem*)g_mozilla_transfer_item_new_with_url(SOME_CONST_STRING, "index.html");
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_engine_download_cancel(NULL));
}

void Testgmcppw::test_download_cancel1()
{
	int retvalue = 0;
	GMozillaTransferItem *item = (GMozillaTransferItem*)g_mozilla_transfer_item_new_with_url(SOME_CONST_STRING, "index.html");
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_engine_download_cancel(NULL));
}

//return NS_OK if everything fine. Problem with return type
void Testgmcppw::test_get_downloads_count()
{
	int retvalue = 0;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_engine_get_downloads_count());
	CPPUNIT_ASSERT(retvalue != NS_OK);
}

//this will return empty list if nothing is downloading
void Testgmcppw::test_get_download_items()
{
	GList* retvalue = NULL;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_engine_get_download_items(NULL));
	CPPUNIT_ASSERT(g_list_length(retvalue) == 0);
}

void Testgmcppw::test_get_download_items1()
{
	GList* retvalue = NULL;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_engine_get_download_items(mozengine->global));
	CPPUNIT_ASSERT(g_list_length(retvalue) == 0);
}


//this will return TRUE when success, return FALSE when it fails and return NS_ERROR_INVALID_POINTER when it finds pointer is invalid 
//problem with return type
void Testgmcppw::test_save_target1()
{
	int retvalue = 0;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_engine_save_target(NULL, SOME_CONST_STRING, SOME_CONST_STRING, 1, NULL));
	CPPUNIT_ASSERT(retvalue == NS_ERROR_INVALID_POINTER);
}

//this will return TRUE when success, return FALSE when it fails and return NS_ERROR_INVALID_POINTER when it finds pointer is invalid 
//problem with return type
void Testgmcppw::test_save_target2()
{
	int retvalue = 0;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_engine_save_target(mozengine, SOME_CONST_STRING, SOME_CONST_STRING, 1, NULL));
/*	TRY{
		retvalue = g_mozilla_engine_save_target(mozengine, SOME_CONST_STRING, SOME_CONST_STRING, 1, NULL);
	}
	CATCH
	{
		printf("signal id: %d\n", e.getSignalId());
	}*/
	CPPUNIT_ASSERT(retvalue != TRUE);
}

//this will return TRUE when success, return FALSE when it fails and return NS_ERROR_INVALID_POINTER when it finds pointer is invalid 
//problem with return type
void Testgmcppw::test_save_target3()
{
	int retvalue = 0;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_engine_save_target(mozengine, SOME_CONST_STRING, SOME_CONST_STRING, -9, NULL));
	CPPUNIT_ASSERT(retvalue != TRUE);
}

//this will return TRUE when success, return FALSE when it fails and return NS_ERROR_INVALID_POINTER when it finds pointer is invalid 
//problem with return type
void Testgmcppw::test_save_target4()
{
	int retvalue = 0;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_engine_save_target(mozengine, SOME_CONST_STRING, NULL, 0, NULL));
	CPPUNIT_ASSERT(retvalue != TRUE);
}

//this will return TRUE when success, return FALSE when it fails and return NS_ERROR_INVALID_POINTER when it finds pointer is invalid 
//problem with return type
void Testgmcppw::test_save_target5()
{
	int retvalue = 0;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_engine_save_target(mozengine, NULL, SOME_CONST_STRING, 1, NULL));
	CPPUNIT_ASSERT(retvalue != TRUE);
}

//this will return TRUE when success, return FALSE when it fails and return NS_ERROR_INVALID_POINTER when it finds pointer is invalid 
//problem with return type
void Testgmcppw::test_save_target6()
{
	int retvalue = 0;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_engine_save_target(mozengine, NULL, NULL, 1, NULL));
	CPPUNIT_ASSERT(retvalue != TRUE);
}

//this will return FALSE when something wrong or can not do required action
//problem with return type
void Testgmcppw::test_get_server_cert()
{
	int retvalue = 0;
	gpointer serverCert = NULL;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_get_server_cert(GTK_MOZ_EMBED(mozengine), &serverCert, NULL));
	CPPUNIT_ASSERT(retvalue == FALSE);
}

//this will return FALSE when something wrong or can not do required action
//this is good example
void Testgmcppw::test_get_page_verifier_name()
{
	gboolean retvalue = 0;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_get_page_verifier_name(NULL, NULL));
	CPPUNIT_ASSERT(retvalue == FALSE);
}

void Testgmcppw::test_get_page_verifier_name1()
{
	gboolean retvalue = 0;
	gchar* verifier_name = NULL;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_get_page_verifier_name(GTK_MOZ_EMBED(mozengine), &verifier_name));
	CPPUNIT_ASSERT(retvalue == FALSE);
}

//this will return FALSE when something wrong or can not do required action
//serious problem with return type
void Testgmcppw::test_observe1()
{
	int retvalue = 0;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_engine_observe(SOME_CONST_STRING, NULL, SOME_CONST_STRING, NULL));
	CPPUNIT_ASSERT(retvalue == false);
}

//this will return FALSE when something wrong or can not do required action
//serious problem with return type
void Testgmcppw::test_observe2()
{
	int retvalue = 0;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_engine_observe(NULL, NULL, NULL, NULL));
	CPPUNIT_ASSERT(retvalue == false);
}


//this will return FALSE when something wrong or can not do required action
//but we are not sure what should happen here
//problem with return type
void Testgmcppw::test_save_prefs()
{
	int retvalue = 0;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_engine_save_prefs());
}

//this will return FALSE when something wrong or can not do required action
//problem with return type
void Testgmcppw::test_get_pref1()
{
	int retvalue = 0;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_engine_get_pref(GTK_TYPE_BOOL, SOME_CONST_STRING, NULL));
	CPPUNIT_ASSERT(retvalue == FALSE);
}

//this will return FALSE when something wrong or can not do required action
//problem with return type
void Testgmcppw::test_get_pref2()
{
	int retvalue = 0;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_engine_get_pref(G_TYPE_INVALID, NULL, NULL));
	CPPUNIT_ASSERT(retvalue == FALSE);
}

//this will return FALSE when something wrong or can not do required action
//problem with return type
void Testgmcppw::test_set_pref1()
{
	int retvalue = 0;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_engine_set_pref(GTK_TYPE_BOOL, SOME_CONST_STRING, NULL));
	CPPUNIT_ASSERT(retvalue == FALSE);
}

//this will return FALSE when something wrong or can not do required action
//problem with return type
void Testgmcppw::test_set_pref2()
{
	int retvalue = 0;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_engine_set_pref(G_TYPE_INVALID, NULL, NULL));
	CPPUNIT_ASSERT(retvalue == FALSE);
}

//return G_TYPE_INVALID if anything wrong or the type is not the one of G_TYPE_STRING_INT_OR_BOOLEAN
//problem with return type
void Testgmcppw::test_get_pref_type1()
{
	int retvalue = 0;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_engine_get_pref_type(SOME_CONST_STRING));
	CPPUNIT_ASSERT(retvalue == G_TYPE_INVALID);
}

//return G_TYPE_INVALID if anything wrong or the type is not the one of G_TYPE_STRING_INT_OR_BOOLEAN
//problem with return type
void Testgmcppw::test_get_pref_type2()
{
	int retvalue = 0;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_engine_get_pref_type(NULL));
	CPPUNIT_ASSERT(retvalue == G_TYPE_INVALID);
}


//return NS_OK if everything fine. Problem with return type
void Testgmcppw::test_reflow_content()
{
	int retvalue = 0;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_reflow_content(NULL));
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_reflow_content(GTK_MOZ_EMBED(mozengine)));
	CPPUNIT_ASSERT(retvalue != NS_OK);
}

//return NULL if anything wrong or could not get content.
void Testgmcppw::test_get_encoding()
{
	char* retvalue = NULL;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_moz_engine_get_encoding(NULL, 0));
	CPPUNIT_ASSERT(retvalue == NULL);
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_moz_engine_get_encoding(GTK_MOZ_EMBED(mozengine), 0));
}

//return NS_OK if everything fine. Problem with return type
void Testgmcppw::test_set_encoding()
{
	int retvalue = 0;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_moz_engine_set_encoding(NULL, SOME_CONST_STRING, 0));
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_moz_engine_set_encoding(NULL, NULL, 0));
	CPPUNIT_ASSERT(retvalue != NS_OK);
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_moz_engine_set_encoding(GTK_MOZ_EMBED(mozengine), SOME_CONST_STRING, 0));
}

//returns the history item count or 0 if failed to get it
void Testgmcppw::test_get_shistory_list()
{
	int retvalue = 0;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_engine_get_shistory_list(NULL, NULL, G_TYPE_INVALID));
	CPPUNIT_ASSERT(retvalue == 0);
	GObject *h;
	GObject **history = &h;
	*history = G_OBJECT(g_object_new(g_mozilla_history_list_get_type(), NULL));
	G_MOZILLA_HISTORY_LIST(*history)->isSHistory = TRUE;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(g_mozilla_engine_get_shistory_list(mozengine, (GtkWebHistoryItem**)&G_MOZILLA_HISTORY_LIST(*history)->items, GTK_MOZ_COMMON_BACK_SHISTORY));
}

//returns the history item count or -1 if failed to get it
void Testgmcppw::test_get_shistory_index()
{
	int retvalue = 0;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_engine_get_shistory_index(NULL));
	CPPUNIT_ASSERT(retvalue == -1);
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_engine_get_shistory_index(GTK_MOZ_EMBED(mozengine)));
}

//return NS_OK if everything fine. Problem with return type
void Testgmcppw::test_shistory_goto_index1()
{
	int retvalue = 0;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_engine_shistory_goto_index(NULL, 1));
	CPPUNIT_ASSERT(retvalue != NS_OK);
}

//return NS_OK if everything fine. Problem with return type
void Testgmcppw::test_shistory_goto_index2()
{
	int retvalue = 0;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_engine_shistory_goto_index(GTK_MOZ_EMBED(mozengine), -999));
	CPPUNIT_ASSERT(retvalue != NS_OK);
}

//this will return FALSE when something wrong or can not do required action
//problem with return type
void Testgmcppw::test_clipboard1()
{
	int retvalue = 0;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_engine_clipboard(GTK_MOZ_EMBED(mozengine), GTK_MOZ_CLIPBOARD_SELECT_ALL));
	CPPUNIT_ASSERT(retvalue == FALSE);
}

//this will return FALSE when something wrong or can not do required action
//problem with return type
void Testgmcppw::test_clipboard2()
{
	int retvalue = 0;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_engine_clipboard(GTK_MOZ_EMBED(mozengine), -999));
	CPPUNIT_ASSERT(retvalue == FALSE);
}

//this will return FALSE when something wrong or can not do required action
//problem with return type
void Testgmcppw::test_clipboard3()
{
	int retvalue = 0;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_engine_clipboard(NULL, -999));
	CPPUNIT_ASSERT(retvalue == FALSE);
}

//returns 0 or the length of the list
void Testgmcppw::test_get_plugins_list()
{
	int retvalue = 0;
	GList *list = NULL;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_get_plugins_list(NULL));
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_get_plugins_list(&list));
}

//this will return FALSE when something wrong or can not do required action
//problem with return type
void Testgmcppw::test_set_extension_status1()
{
	int retvalue = 0;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_set_extension_status(SOME_STRING, 0));
	CPPUNIT_ASSERT(retvalue == FALSE);
}

//this will return FALSE when something wrong or can not do required action
//problem with return type
void Testgmcppw::test_set_extension_status2()
{
	int retvalue = 0;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_set_extension_status(SOME_STRING, 1));
	CPPUNIT_ASSERT(retvalue == FALSE);
}

//this will return FALSE when something wrong or can not do required action
//problem with return type
void Testgmcppw::test_set_extension_status3()
{
	int retvalue = 0;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_set_extension_status(NULL, 0));
	CPPUNIT_ASSERT(retvalue == FALSE);
}

//this will return FALSE or NS_ERROR_FAILURE when something wrong or can not do required action
//problem with return type
void Testgmcppw::test_set_image_policy1()
{
	int retvalue = 0;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_set_image_policy(NULL, 0));
	CPPUNIT_ASSERT(retvalue != TRUE);
}

//this will return FALSE or NS_ERROR_FAILURE when something wrong or can not do required action
//problem with return type
void Testgmcppw::test_set_image_policy2()
{
	int retvalue = 0;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_set_image_policy(mozengine, 0));
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_set_image_policy(mozengine, 2));
}


//this will return FALSE when something wrong or can not do required action
//problem with return type
void Testgmcppw::test_load_image1()
{
	int retvalue = 0;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_load_image(gtk_microb_context_get_node((GtkMicroBContext*)mozengine->ctx), IMAGE_URL));
	CPPUNIT_ASSERT(retvalue == FALSE);
}

//this will return FALSE when something wrong or can not do required action
//problem with return type
void Testgmcppw::test_load_image2()
{
	int retvalue = 0;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_load_image(NULL, NULL));
	CPPUNIT_ASSERT(retvalue == FALSE);
}


void Testgmcppw::test_notification_button_pressed()
{
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(g_mozilla_notification_button_pressed(NULL, NULL));
}

//this function return TRUE if anything wrong or when it should permit unload
void Testgmcppw::test_permit_unload()
{
	gboolean retvalue = 0;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_moz_engine_permit_unload(NULL, 0, 0, 0));
	CPPUNIT_ASSERT(retvalue == TRUE);
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_moz_engine_permit_unload(GTK_MOZ_EMBED(mozengine), 1, 1, 1));
}

void Testgmcppw::test_draw_layout1()
{
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(draw_layout(NULL, 1, 2, 3, 4, 5, 6));
}


void Testgmcppw::test_draw_layout2()
{
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(draw_layout(mozengine, -10, -2, -3, -4, -5, -6));
}

void Testgmcppw::test_draw_layout3()
{
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(draw_layout(mozengine, 199, 299, 399, 4999, 5999, 6999));
}

void Testgmcppw::test_draw_layout4()
{
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(draw_layout(mozengine, 0, 0, 0, 0, 0, 0));
}

//this will return NS_OK when it success, problem with return type
void Testgmcppw::test_send_event_to_layout1()
{
	int retvalue = 0;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = send_event_to_layout(NULL, 1, 2, 3, 4, 5, 6, 7));
	CPPUNIT_ASSERT(retvalue != NS_OK);
}


//this will return NS_OK when it success, problem with return type
void Testgmcppw::test_send_event_to_layout2()
{
	int retvalue = 0;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = send_event_to_layout(mozengine, -10, -2, -3, -4, -5, -6, -7));
	CPPUNIT_ASSERT(retvalue != NS_OK);
}

//this will return NS_OK when it success, problem with return type
void Testgmcppw::test_send_event_to_layout3()
{
	int retvalue = 0;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = send_event_to_layout(mozengine, 199, 299, 399, 4999, 5999, 6999, 7999));
	CPPUNIT_ASSERT(retvalue != NS_OK);
}

//this will return NS_OK when it success, problem with return type
void Testgmcppw::test_send_event_to_layout4()
{
	int retvalue = 0;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = send_event_to_layout(mozengine, 0, 0, 0, 0, 0, 0, 0));
	CPPUNIT_ASSERT(retvalue != NS_OK);
}

//this will return G_WEBENGINE_UNKNOWN_SECURITY when it can not figure out
void Testgmcppw::test_get_security_mode()
{
	unsigned int retvalue = 0;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_engine_get_security_mode(0));
	CPPUNIT_ASSERT(retvalue == G_WEBENGINE_UNKNOWN_SECURITY);
}

//this will return TRUE when it success, problem with return type
void Testgmcppw::test_get_thumbnail1()
{
	gboolean retvalue = 0;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_get_thumbnail(NULL, -3, -2));
	CPPUNIT_ASSERT(retvalue != TRUE);
}

//this will return TRUE when it success, problem with return type
void Testgmcppw::test_get_thumbnail2()
{
	gboolean retvalue = 0;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_get_thumbnail(SOME_CONST_STRING, 3, 2));
	CPPUNIT_ASSERT(retvalue != TRUE);
}

//this will return NS_OK when it success, problem with return type
void Testgmcppw::test_evaluate_js()
{
	int retvalue = 0;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_evaluate_js(NULL, NULL));
	CPPUNIT_ASSERT(retvalue != NS_OK);
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_evaluate_js(mozengine, NULL));
}

//this will return -1 when it failes
void Testgmcppw::test_get_text_zoom()
{
	gint retvalue = 0;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_get_text_zoom(NULL));
	CPPUNIT_ASSERT(retvalue == -1);
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_get_text_zoom(GTK_MOZ_EMBED(mozengine)));
}

//this will return TRUE when it seccess
void Testgmcppw::test_set_text_zoom()
{
	gboolean retvalue = 0;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_set_text_zoom(NULL, -3));
	CPPUNIT_ASSERT(retvalue != TRUE);
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_set_text_zoom(GTK_MOZ_EMBED(mozengine), -3));
}

void Testgmcppw::test_delete_session_history_manager()
{
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(delete_session_history_manager(NULL));
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(delete_session_history_manager(mozengine));
}

//return PR_TRUE if needs restart
void Testgmcppw::test_initialize_extensions()
{
	PRBool retvalue = PR_FALSE;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = g_mozilla_initialize_extensions());
}

//this will return NS_OK when it success, problem with return type
void Testgmcppw::test_get_element_info()
{
	int retvalue = 0;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = get_element_info(NULL, 0, 0, 0, NULL));
	CPPUNIT_ASSERT(retvalue != NS_OK);
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = get_element_info(mozengine, 0, 0, 0, NULL));
}

//this will return TRUE when it success
void Testgmcppw::test_get_mouse_over_element_info1()
{
	int retvalue = NULL;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = get_mouse_over_element_info(NULL, NULL));
	CPPUNIT_ASSERT(retvalue != TRUE);
}

//this will return TRUE when it success
void Testgmcppw::test_get_mouse_over_element_info2()
{
	int retvalue = NULL;
	mozengine->ctx_node = gtk_microb_context_get_node((GtkMicroBContext*)mozengine->ctx);
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = get_mouse_over_element_info(mozengine, mozengine->ctx_node));
	CPPUNIT_ASSERT(retvalue != TRUE);
}


// return 0 when it fails AND success, problem with return type
void Testgmcppw::test_send_element_info()
{
	int retvalue = NULL;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = send_element_info(mozengine, 4, 5.3, 2.5, 4.8, 6.1, 4));
	CPPUNIT_ASSERT(retvalue != TRUE);
}


void Testgmcppw::test_select_widget_item_selected()
{
	gint index = 0;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(g_mozilla_select_widget_item_selected(NULL, NULL, NULL, 0));
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(g_mozilla_select_widget_item_selected(mozengine, mozengine->select_node, &index, 1));
}

void Testgmcppw::test_create_select_widget()
{
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(create_select_widget(NULL, NULL, NULL));
	mozengine->ctx_node = gtk_microb_context_get_node((GtkMicroBContext*)mozengine->ctx);
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(create_select_widget(mozengine, mozengine->ctx_node, gtk_microb_context_get_original_node((GtkMicroBContext*)mozengine->ctx)));
}


// return NS_OK when it success
void Testgmcppw::test_send_focused_element_message1()
{
	int retvalue = 0;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = send_focused_element_message(mozengine, NULL));
	CPPUNIT_ASSERT(retvalue != NS_OK);
}

// return NS_OK when it success
void Testgmcppw::test_send_focused_element_message2()
{
	int retvalue = 0;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = send_focused_element_message(NULL, NULL));
	CPPUNIT_ASSERT(retvalue != NS_OK);
}



