/* vim:set ts=2 sw=2 sts=2 tw=80 et cindent: */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is mozilla.org code.
 *
 * The Initial Developer of the Original Code is
 * Christopher Blizzard.
 * Portions created by the Initial Developer are Copyright (C) 2001
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Oleg Romashin <romaxa@gmail.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#ifndef __MicrobEalObserver_h
#define __MicrobEalObserver_h

#include "nsIObserver.h"
#include "nsIObserverService.h"
#include "nsWeakReference.h"
#include "nsIGenericFactory.h"
#include "nsServiceManagerUtils.h"

#include "libosso.h"

// {9c9c6931-64e2-49af-afd4-b3f954f21626}
#define NS_EMBED_MICROB_OBSERVER_CID \
  {0x9c9c6931, 0x64e2, 0x49af, \
    { 0xaf, 0xd4, 0xb3, 0xf9, 0x54, 0xf2, 0x16, 0x26 }}

#define NS_EMBED_CLIENT_OBSERVER_CONTRACTID "@browser/engine-client-observer;1"

class MicrobEalObserver : public nsIObserver,
                          public nsSupportsWeakReference
{
  public:
    NS_DECL_ISUPPORTS
    NS_DECL_NSIOBSERVER

    static NS_METHOD Create (nsISupports * aOuter, REFNSIID aIID,
                             void **aResult);

    static NS_METHOD RegisterSelf (nsIComponentManager * aCompMgr,
                                   nsIFile * aPath,
                                   const char *aLoaderStr,
                                   const char *aType,
                                   const nsModuleComponentInfo * aInfo);
    static NS_METHOD UnregisterSelf(nsIComponentManager* aCompMgr,
                                    nsIFile* aPath, const char *aLoaderStr,
                                    const nsModuleComponentInfo *aInfo);

    NS_DEFINE_STATIC_CID_ACCESSOR (NS_EMBED_MICROB_OBSERVER_CID)


  private:

    nsresult Init ();
    MicrobEalObserver ();
    virtual ~MicrobEalObserver ();

    nsresult CleanAuthData ();

    static void OssoDisplayCallback(osso_display_state_t state, gpointer data);
    static void OssoHardwareCallback(osso_hw_state_t *state, gpointer data);

    nsCOMPtr<nsIObserverService> mObserverService;
    void *mGWeb;
    osso_hw_state_t mHwState;
    osso_context_t *mOssoContext;
};

#endif /* __MicrobEalObserver_h */
