/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 tw=80 et cindent: */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#ifndef __MICROBEALNOTIFICATIONBUTTON_H__
#define __MICROBEALNOTIFICATIONBUTTON_H__

#include "nsINotificationBox.h"
#include "nsStringAPI.h"

#define NOTIFICATIONBUTTON_CONTRACTID "@browser.garage.maemo.org/microb/notificationbutton;1"
#define NOTIFICATIONBUTTON_CLASSNAME "MicroB NotificationBox button"
//7229ba9d-73bb-4228-ac07-8664f8c4a927
#define NOTIFICATIONBUTTON_CID  { 0x7229ba9d, 0x73bb, 0x4228, { 0xac, 0x07, 0x86, 0x64, 0xf8, 0xc4, 0xa9, 0x27 } }

class MicrobEalNotificationButtonHandler;

/* Header file */
class MicrobEalNotificationButton : public nsINotificationButton
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSINOTIFICATIONBUTTON

  MicrobEalNotificationButton();

  nsresult ButtonPressed();

private:
  ~MicrobEalNotificationButton();
  nsString mLabel;
  nsString mAccessKey;
  nsString mPopup;

  nsINotificationButtonHandler *mCallbackHandler;

protected:
  // None
};

class MicrobEalNotificationButtonHandler : public nsINotificationButtonHandler
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSINOTIFICATIONBUTTONHANDLER

  MicrobEalNotificationButtonHandler();

private:
  ~MicrobEalNotificationButtonHandler();

protected:
  /* additional members */
};

#endif // __MICROBEALNOTIFICATIONBUTTON_H__
