/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Nokia code.
 *
 * The Initial Developer of the Original Code is Novell.
 * Portions created by the Initial Developer are Copyright (C) 2008
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Aiken Tie <ext-tie.aiken@nokia.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include <nsError.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gtkmozembed.h>
#include <neteal.h>
#include <stdio.h>
#include <dbus/dbus-glib.h>

#include "testmicrobeal.h"
#include "CppUnitSignalException.h"

#include "MicrobEalDownloadMgr.h"
#include "MicrobEalCertificate.h"
#include "MicrobEalXshmRenderer.h"
#include "MicrobEalContextMenuInfo.h"
#include "MicrobEalFilePicker.h"
#include "nsINotificationBox.h"
#include "MicrobEalNotificationBox.h"
#include "MicrobEalNotificationButton.h"
#include "MicrobEalObserver.h"
#include "MicrobEalPromptService.h"
#include "MicrobEalUtils.h"
#include "microb_eal_components.h"
#include "gtkmicrob_context.h"

#include "gmozillaweb.h"
#include "gmozillaengine.h"

#include "microb_eal_components.h"
// some test data

extern const char* SOME_CONST_STRING;
extern char* SOME_STRING;

//unsigned long UNSIGNED_LONG = 4294967295;
//int INT = 2147483647;

CPPUNIT_TEST_SUITE_REGISTRATION( Testmicrobeal );

//#include "MicrobEalDownloadMgr.h"

void Testmicrobeal::test_MicrobEalDownloadMgr()
{
//	MicrobEalDownloadMgr* dm;
//	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(dm = new MicrobEalDownloadMgr());
//	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(delete dm;);
}

void Testmicrobeal::test_InitTransferItem()
{
	MicrobEalDownloadMgr* dm;
	nsresult retvalue;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = MicrobEalDownloadMgr::InitTransferItem(NULL, NULL));
	CPPUNIT_ASSERT(retvalue != NS_OK);
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = MicrobEalDownloadMgr::InitTransferItem(SOME_CONST_STRING, SOME_CONST_STRING));
	CPPUNIT_ASSERT(retvalue != NS_OK);
}

void Testmicrobeal::test_SetupDownloadListener()
{
	nsresult retvalue;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = MicrobEalDownloadMgr::SetupDownloadListener(NULL));
	CPPUNIT_ASSERT(retvalue != NS_OK);
}

void Testmicrobeal::test_StartDownload()
{
	nsresult retvalue;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = MicrobEalDownloadMgr::StartDownload(1));
	CPPUNIT_ASSERT(retvalue != NS_OK);
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = MicrobEalDownloadMgr::StartDownload(0));
	CPPUNIT_ASSERT(retvalue != NS_OK);
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = MicrobEalDownloadMgr::StartDownload(-10));
	CPPUNIT_ASSERT(retvalue != NS_OK);
}


//#include "MicrobEalCertificate.h"

void Testmicrobeal::test_MicrobEalCertificate()
{
	MicrobEalCertificate* obj;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(obj = new MicrobEalCertificate());
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(delete obj;);
}


void Testmicrobeal::test_MicrobEalCertificate_Init()
{
	MicrobEalCertificate* obj = new MicrobEalCertificate();
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(obj->Init());
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(delete obj;);
}

void Testmicrobeal::test_MicrobEalCertificate_SetUp()
{
	MicrobEalCertificate* obj = new MicrobEalCertificate();
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(obj->SetUp(NULL));
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(delete obj;);
}


#include "MicrobEalXshmRenderer.h"

void Testmicrobeal::test_MicrobShmBufData()
{
	MicrobShmBufData* obj;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(obj = new MicrobShmBufData());
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(delete obj;);
}

//SetData member did not implemented, it is wrongly defined, I mean that unsigned long
/*
void Testmicrobeal::test_MicrobShmBufData_SetData()
{
	MicrobShmBufData* obj = new MicrobShmBufData();
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(obj->SetData(UNSIGNED_LONG, INT, INT, INT));
	CPPUNIT_ASSERT(obj->id == UNSIGNED_LONG);
	CPPUNIT_ASSERT(obj->width == INT);
	CPPUNIT_ASSERT(obj->height == INT);
	CPPUNIT_ASSERT(obj->depth == INT);
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(delete obj;);
}
*/

void Testmicrobeal::test_MicrobShmBufData_SetBlocked()
{
	MicrobShmBufData* obj;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(obj = new MicrobShmBufData());
	CPPUNIT_ASSERT(obj->IsBlocked() == 0);
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(obj->SetBlocked(12));
	CPPUNIT_ASSERT(obj->IsBlocked() == 0); //because blocked pointer value has not been initialized
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(delete obj;);
}

void Testmicrobeal::test_MicrobEalXshmRenderer()
{
	MicrobEalXshmRenderer* obj;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(obj = new MicrobEalXshmRenderer());
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(delete obj;);
}

void Testmicrobeal::test_MicrobEalXshmRenderer_Init()
{
	MicrobEalXshmRenderer* obj;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(obj = new MicrobEalXshmRenderer());
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(obj->Init(NULL));
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(delete obj;);
}

void Testmicrobeal::test_MicrobEalXshmRenderer_SetUp1()
{
	MicrobEalXshmRenderer* obj;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(obj = new MicrobEalXshmRenderer());
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(obj->SetUp(NULL));
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(delete obj;);
}

void Testmicrobeal::test_MicrobEalXshmRenderer_SetUp2()
{
	MicrobEalXshmRenderer* obj;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(obj = new MicrobEalXshmRenderer());
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(obj->SetUp(G_MOZILLA_ENGINE(g_mozilla_engine_new())));
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(delete obj;);
}


void Testmicrobeal::test_MicrobEalXshmRenderer_UnSetup()
{
	MicrobEalXshmRenderer* obj;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(obj = new MicrobEalXshmRenderer());
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(obj->UnSetup(NULL));
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(delete obj;);
}

//void Testmicrobeal::test_MicrobEalXshmRenderer_CreateSharedImageData()
//{
	//MicrobEalXshmRenderer* obj;
	//CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(obj = new MicrobEalXshmRenderer());
	//CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(obj->CreateSharedImageData(12, 23, 24));
	//CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(delete obj;);
//}

//void Testmicrobeal::test_MicrobEalXshmRenderer_DrawRectToXshm()
//{
	//gfxRect rect;
	//MicrobShmBufData data;
	//CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(MicrobEalXshmRenderer::DrawRectToXshm(NULL, rect, data, 12));
//}

//void Testmicrobeal::test_MicrobEalXshmRenderer_byte_per_pixel()
//{
	//CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(MicrobEalXshmRenderer::byte_per_pixel(32));
//}

//#include "MicrobEalContextMenuInfo.h"

void Testmicrobeal::test_MicrobEalContextMenuInfo()
{
	MicrobEalContextMenuInfo* obj;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(obj = new MicrobEalContextMenuInfo(NULL));
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(delete obj;);
}

void Testmicrobeal::test_MicrobEalContextMenuInfo_UpdateContextData()
{
	MicrobEalContextMenuInfo* obj;
	nsresult retvalue;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(obj = new MicrobEalContextMenuInfo(NULL));
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = obj->UpdateContextData(NULL));
	CPPUNIT_ASSERT(retvalue != NS_OK);
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(delete obj;);
}

void Testmicrobeal::test_MicrobEalContextMenuInfo_UpdateContextDataFromNode()
{
	MicrobEalContextMenuInfo* obj;
	nsresult retvalue;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(obj = new MicrobEalContextMenuInfo(NULL));
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = obj->UpdateContextDataFromNode(NULL));
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(delete obj;);
}


void Testmicrobeal::test_MicrobEalContextMenuInfo_UpdateContextDataFromElement()
{
	MicrobEalContextMenuInfo* obj;
	nsresult retvalue;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(obj = new MicrobEalContextMenuInfo(NULL));
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = obj->UpdateContextDataFromElement(NULL));
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(delete obj;);
}

void Testmicrobeal::test_MicrobEalContextMenuInfo_GetContextText()
{
	MicrobEalContextMenuInfo* obj;
	nsresult retvalue;
	nsString aString;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(obj = new MicrobEalContextMenuInfo(NULL));
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = obj->GetContextText(aString));
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(delete obj;);
}

void Testmicrobeal::test_MicrobEalContextMenuInfo_GetJSHandledInfo()
{
	MicrobEalContextMenuInfo* obj;
	nsresult retvalue;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(obj = new MicrobEalContextMenuInfo(NULL));
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = obj->GetJSHandledInfo(NULL));
	CPPUNIT_ASSERT(retvalue != NS_OK);
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(delete obj;);
}

void Testmicrobeal::test_MicrobEalContextMenuInfo_InsertTextToNode()
{
	MicrobEalContextMenuInfo* obj;
	nsresult retvalue;
	nsString aString;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(obj = new MicrobEalContextMenuInfo(NULL));
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = obj->InsertTextToNode(NULL, aString, 12, 999));
	CPPUNIT_ASSERT(retvalue != NS_OK);
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(delete obj;);
}

void Testmicrobeal::test_MicrobEalContextMenuInfo_GetCSSBackground()
{
	MicrobEalContextMenuInfo* obj;
	nsresult retvalue;
	nsString aString;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(obj = new MicrobEalContextMenuInfo(NULL));
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = obj->GetCSSBackground(NULL, aString));
	CPPUNIT_ASSERT(retvalue != NS_OK);
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(delete obj;);
}

void Testmicrobeal::test_MicrobEalContextMenuInfo_CheckDomImageElement()
{
	nsresult retvalue;
	nsString aString;
	PRInt32 aWidth;
	PRInt32 aHeight;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = MicrobEalContextMenuInfo::CheckDomImageElement(NULL, aString, aWidth, aHeight));
	CPPUNIT_ASSERT(retvalue != NS_OK);
}

void Testmicrobeal::test_MicrobEalContextMenuInfo_GetImageRequest()
{
	nsresult retvalue;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = MicrobEalContextMenuInfo::GetImageRequest(NULL, NULL));
	CPPUNIT_ASSERT(retvalue != NS_OK);
}

void Testmicrobeal::test_MicrobEalContextMenuInfo_ScrollToSelectedNode()
{
	nsresult retvalue;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = MicrobEalContextMenuInfo::ScrollToSelectedNode(NULL));
	CPPUNIT_ASSERT(retvalue != NS_OK);
}

void Testmicrobeal::test_MicrobEalContextMenuInfo_DoCommand()
{
	nsresult retvalue;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = MicrobEalContextMenuInfo::DoCommand(NULL, SOME_CONST_STRING, 8));
	CPPUNIT_ASSERT(retvalue != NS_OK);
}

//#include "MicrobEalFilePicker.h"

void Testmicrobeal::test_MicrobEalFilePicker()
{
	MicrobEalFilePicker* obj;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(obj = new MicrobEalFilePicker());
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(delete obj;);
}

void Testmicrobeal::test_MicrobEalFilePicker_Init()
{
	MicrobEalFilePicker* obj;
	nsString title;
	PRInt16 mode = 9;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(obj = new MicrobEalFilePicker());
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(obj->Init(NULL, title, mode));
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(delete obj;);
}

void Testmicrobeal::test_MicrobEalFilePicker_AppendFilters()
{
	MicrobEalFilePicker* obj;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(obj = new MicrobEalFilePicker());
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(obj->AppendFilters(0xffff));
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(delete obj;);
}

void Testmicrobeal::test_MicrobEalFilePicker_AppendFilter()
{
	MicrobEalFilePicker* obj;
	const nsString aFilter;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(obj = new MicrobEalFilePicker());
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(obj->AppendFilter(aFilter, aFilter));
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(delete obj;);
}

void Testmicrobeal::test_MicrobEalFilePicker_GetFile()
{
	MicrobEalFilePicker* obj;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(obj = new MicrobEalFilePicker());
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(obj->GetFile(NULL));
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(delete obj;);
}

void Testmicrobeal::test_MicrobEalFilePicker_GetFileURL()
{
	MicrobEalFilePicker* obj;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(obj = new MicrobEalFilePicker());
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(obj->GetFileURL(NULL));
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(delete obj;);
}

void Testmicrobeal::test_MicrobEalFilePicker_Show()
{
	MicrobEalFilePicker* obj;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(obj = new MicrobEalFilePicker());
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(obj->Show(NULL));
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(delete obj;);
}


//#include "nsINotificationBox.h"
//#include "MicrobEalNotification.h"

void Testmicrobeal::test_MicrobEalNotification()
{
	nsINotification* obj;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(obj = new MicrobEalNotification());
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(delete obj;);
}



//#include "MicrobEalNotificationBox.h"

void Testmicrobeal::test_MicrobEalNotificationBox()
{
	MicrobEalNotificationBox* obj;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(obj = new MicrobEalNotificationBox());
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(delete obj;);
}

void Testmicrobeal::test_MicrobEalNotificationBox_AppendNotification()
{
	MicrobEalNotificationBox* obj;
	nsString aString;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(obj = new MicrobEalNotificationBox());
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(obj->AppendNotification(aString, aString, aString, 0, NULL, NULL));
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(delete obj;);
}

void Testmicrobeal::test_MicrobEalNotificationBox_GetNotificationWithValue()
{
	MicrobEalNotificationBox* obj;
	nsString aString;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(obj = new MicrobEalNotificationBox());
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(obj->GetNotificationWithValue(aString, NULL));
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(delete obj;);
}

void Testmicrobeal::test_MicrobEalNotificationBox_RemoveAllNotifications()
{
	MicrobEalNotificationBox* obj;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(obj = new MicrobEalNotificationBox());
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(obj->RemoveAllNotifications(TRUE));
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(delete obj;);
}


void Testmicrobeal::test_MicrobEalNotificationBox_RemoveCurrentNotification()
{
	MicrobEalNotificationBox* obj;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(obj = new MicrobEalNotificationBox());
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(obj->RemoveCurrentNotification());
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(delete obj;);
}


void Testmicrobeal::test_MicrobEalNotificationBox_RemoveNotification()
{
	MicrobEalNotificationBox* obj;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(obj = new MicrobEalNotificationBox());
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(obj->RemoveNotification(NULL));
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(delete obj;);
}


void Testmicrobeal::test_MicrobEalNotificationBox_ButtonPressed()
{
	MicrobEalNotificationBox* obj;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(obj = new MicrobEalNotificationBox());
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(obj->ButtonPressed(NULL, NULL));
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(delete obj;);
}


//#include "MicrobEalNotificationButton.h"


void Testmicrobeal::test_MicrobEalNotificationButton()
{
	nsINotificationButton* obj;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(obj = new MicrobEalNotificationButton());
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(delete obj;);
}



//#include "MicrobEalObserver.h"


void Testmicrobeal::test_MicrobEalObserver_Create()
{
	nsIID id;
	void* result = NULL;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(MicrobEalObserver::Create(NULL, id, &result));
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(MicrobEalObserver::Create(NULL, id, NULL));
}

void Testmicrobeal::test_MicrobEalObserver_RegisterSelf()
{
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(MicrobEalObserver::RegisterSelf(NULL, NULL, NULL, NULL, NULL));
}

void Testmicrobeal::test_MicrobEalObserver_UnregisterSelf()
{
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(MicrobEalObserver::UnregisterSelf(NULL, NULL, NULL, NULL));
}



//#include "MicrobEalPromptService.h"


void Testmicrobeal::test_MicrobEalPromptService()
{
	MicrobEalPromptService* obj;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(obj = new MicrobEalPromptService());
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(delete obj;);
}


//#include "MicrobEalUtils.h"

void Testmicrobeal::test_GetGMozEngineForDOMWindow()
{
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(GetGMozEngineForDOMWindow(NULL));
}

void Testmicrobeal::test_GetDOMWindowByNode()
{
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(GetDOMWindowByNode(NULL, NULL));
}

void Testmicrobeal::test_GetContentViewer()
{
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(GetContentViewer(NULL, NULL));
}



//#include "microb_eal_components.h"


void Testmicrobeal::test_components_static_init()
{
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(microb_eal_components_static_init());
}

void Testmicrobeal::test_components_init()
{
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(microb_eal_components_init());
}

void Testmicrobeal::test_components_del()
{
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(microb_eal_components_del());
}



//#include "gtkmicrob_context.h"


GWebDialogButton g_web_signal_modal_dialog(GObject *global,
                                           const gchar* caption,
                                           const gchar* message,
                                           GWebDialogMessageType type,
                                           GWebDialogButton button1,
                                           GWebDialogButton button2,
                                           GWebDialogButton button3)
{
  return (GWebDialogButton)0;
}

void Testmicrobeal::init()
{
	void (* web_set_env) (void) = NULL;
	GWeb* (* web_get_new) (void) = NULL;
	guint32 server = 0;
	guint32 connection = 0;
	GArray *g;
	gtk_init(NULL, NULL);

	// initialize neteal
	neteal_init();
	neteal_glookup_discovery_server(1000, 6);
	g = neteal_servers_list();
	if (g) {
		if (g && !g->len) {
			GString *s = g_string_new("mytestserver");
			gchar* serverName = s->str;
			server = neteal_server_create_fork(serverName);
		} else {
			server = g_array_index(g, guint32, 0);
		}
		g_array_free(g, TRUE);
	}
	connection = neteal_server_connect(server);
	neteal_set_current(connection);

	dbus_g_thread_init();
	GModule* module = g_module_open("../.libs/libmicrob-eal.so.0", G_MODULE_BIND_LAZY);
	if (g_module_error())
		printf("\tModule error: %s\n", g_module_error());
	if (!g_module_symbol (module, "g_web_set_env", (gpointer *)&web_set_env))
		printf("\tg_web_set_env Function opened unsuccessefully\n");
	else
		printf("\tg_web_set_env Function opened successefully\n");

	if (!g_module_symbol (module, "g_web_new", (gpointer *)&web_get_new))
		printf("\tg_web_new Function opened unsuccessefully\n");
	else
		printf("\tg_web_new Function opened successefully\n");

	web_set_env();
	GWeb* web = web_get_new ();
	g_web_set_ua_string(web, "microb-eal-test");
	printf("Open new Engine: %s\n", SOME_STRING);

	g_web_create_web_buses(web, "eal", "ui");
	GObject *global = g_web_get_global(web);

	g_signal_connect(global, G_WEB_SIGNAL_MODAL_DIALOG, G_CALLBACK(g_web_signal_modal_dialog), NULL);
	microb_eal_components_init();
	microb_eal_components_static_init();

	webengine = g_web_new_web_engine_window_with_context(web, NULL, FALSE, FALSE);
	engine_widget = g_web_engine_get_engine_widget(webengine);
	if (engine_widget) {
		GtkWidget *window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
		gtk_container_add(GTK_CONTAINER(window), GTK_WIDGET(engine_widget));
		gtk_widget_show(GTK_WIDGET(engine_widget));
		gtk_widget_show(window);
	}
	mozengine = (GMozillaEngine*)G_WEB_GET_CLASS(web)->new_web_engine_window(web);
	g_web_engine_load_url(webengine, SOME_STRING);
}


void Testmicrobeal::test_microb_context()
{
	GtkMicroBContext* obj;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(obj = gtk_microb_context_new());
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(GTK_IS_MICROB_CONTEXT(obj));
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(g_object_unref(obj));
}

void Testmicrobeal::test_microb_context_set_prop1()
{
	GtkMicroBContext* obj;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(obj = gtk_microb_context_new());
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(gtk_microb_context_set_prop(NULL, NULL, NULL));
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(g_object_unref(obj));
}


void Testmicrobeal::test_microb_context_set_prop2()
{
	init();
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(gtk_microb_context_set_prop(((GtkMicroBContext*)mozengine->ctx), SOME_CONST_STRING, NULL));
}

void Testmicrobeal::test_microb_context_get_prop1()
{
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(gtk_microb_context_get_prop(NULL, NULL));
}


void Testmicrobeal::test_microb_context_get_prop2()
{
	init();
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(gtk_microb_context_get_prop(((GtkMicroBContext*)mozengine->ctx), SOME_CONST_STRING));
}

void Testmicrobeal::test_microb_context_update_from_event()
{
	init();
	GdkEventExpose* event = g_new0(GdkEventExpose, 1);
	event->type = GDK_EXPOSE;
	if (engine_widget)
		event->window = GTK_WIDGET(engine_widget)->window;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(gtk_microb_context_update_from_event(((GtkMicroBContext*)mozengine->ctx), (gpointer)event));
}

void Testmicrobeal::test_microb_context_update_from_element()
{
	init();
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(gtk_microb_context_update_from_element(((GtkMicroBContext*)mozengine->ctx), NULL));
}

void Testmicrobeal::test_microb_context_get_node()
{
	init();
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(gtk_microb_context_get_node(((GtkMicroBContext*)mozengine->ctx)));
}

void Testmicrobeal::test_microb_context_get_text1()
{
	gchar* ret;
	gint ret2;
	init();
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(gtk_microb_context_get_text(((GtkMicroBContext*)mozengine->ctx), NULL, NULL));
}


void Testmicrobeal::test_microb_context_get_text2()
{
	gchar* ret;
	gint ret2;
	init();
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(gtk_microb_context_get_text(((GtkMicroBContext*)mozengine->ctx), &ret, &ret2));
}

void Testmicrobeal::test_microb_context_insert_text1()
{
	gchar* ret;
	gint ret2;
	init();
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(gtk_microb_context_insert_text(((GtkMicroBContext*)mozengine->ctx), NULL, NULL, INT_MAX, INT_MAX));
}

void Testmicrobeal::test_microb_context_insert_text2()
{
	gchar* ret;
	gint ret2;
	init();
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(gtk_microb_context_insert_text(((GtkMicroBContext*)mozengine->ctx), SOME_CONST_STRING, NULL, INT_MAX, INT_MAX));
}





