/* vim:set ts=2 sw=2 sts=2 tw=80 et cindent: */
/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "nsTouchInteractListener.h"
#include "nsIDOMEvent.h"
#include "nsCOMPtr.h"
#include "nsIComponentManager.h"
#include "nsIComponentRegistrar.h"
#include "nsIWidget.h"

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsTouchInteractListener, nsITouchInteractListener)

nsTouchInteractListener* nsTouchInteractListener::sTouchInteractListener;

nsTouchInteractListener::nsTouchInteractListener()
{
  /* member initializers and constructor code */
}

nsTouchInteractListener::~nsTouchInteractListener()
{
  /* destructor code */
}

NS_IMETHODIMP
nsTouchInteractListener::OnMouseLongPress(nsIDOMEvent *aDOMEvent, nsIWidget *aWidget)
{
  NS_ENSURE_TRUE(aDOMEvent, NS_ERROR_FAILURE);
  NS_ENSURE_TRUE(aWidget, NS_ERROR_FAILURE);
  GtkMozEmbed *gtkmozembed = GTK_MOZ_EMBED(GetGtkMozEmbedFromWidget(aWidget));
  NS_ENSURE_TRUE(gtkmozembed, NS_ERROR_FAILURE);
  GMozillaEngine *mozengine = GetGMozillaEngine(gtkmozembed);
  NS_ENSURE_TRUE(mozengine, NS_ERROR_FAILURE);

  mozengine->mouse_down = TRUE;
  dom_mouse_long_press_cb(gtkmozembed, aDOMEvent, mozengine);

  return NS_OK;
}

NS_IMETHODIMP
nsTouchInteractListener::OnMouseDownPan(nsIDOMEvent *aDOMEvent, nsIWidget *aWidget)
{
  NS_ENSURE_TRUE(aDOMEvent, NS_ERROR_FAILURE);
  NS_ENSURE_TRUE(aWidget, NS_ERROR_FAILURE);
  GtkMozEmbed *gtkmozembed = GTK_MOZ_EMBED(GetGtkMozEmbedFromWidget(aWidget));
  NS_ENSURE_TRUE(gtkmozembed, NS_ERROR_FAILURE);
  GMozillaEngine *mozengine = GetGMozillaEngine(gtkmozembed);
  NS_ENSURE_TRUE(mozengine, NS_ERROR_FAILURE);

  dom_mouse_down_cb(gtkmozembed, aDOMEvent, mozengine);
  return NS_OK;
}

NS_IMETHODIMP
nsTouchInteractListener::OnMouseMovePan(nsIDOMEvent *aDOMEvent, nsIWidget *aWidget)
{
  NS_ENSURE_TRUE(aDOMEvent, NS_ERROR_FAILURE);
  NS_ENSURE_TRUE(aWidget, NS_ERROR_FAILURE);
  GtkMozEmbed *gtkmozembed = GTK_MOZ_EMBED(GetGtkMozEmbedFromWidget(aWidget));
  NS_ENSURE_TRUE(gtkmozembed, NS_ERROR_FAILURE);
  GMozillaEngine *mozengine = GetGMozillaEngine(gtkmozembed);
  NS_ENSURE_TRUE(mozengine, NS_ERROR_FAILURE);

  return NS_OK;
}

NS_IMETHODIMP
nsTouchInteractListener::OnMouseUpPan(nsIDOMEvent *aDOMEvent, nsIWidget *aWidget)
{
  NS_ENSURE_TRUE(aDOMEvent, NS_ERROR_FAILURE);
  NS_ENSURE_TRUE(aWidget, NS_ERROR_FAILURE);
  GtkMozEmbed *gtkmozembed = GTK_MOZ_EMBED(GetGtkMozEmbedFromWidget(aWidget));
  NS_ENSURE_TRUE(gtkmozembed, NS_ERROR_FAILURE);
  GMozillaEngine *mozengine = GetGMozillaEngine(gtkmozembed);
  NS_ENSURE_TRUE(mozengine, NS_ERROR_FAILURE);

  return NS_OK;
}

NS_IMETHODIMP
nsTouchInteractListener::OnMouseDownHover(nsIDOMEvent *aDOMEvent, nsIWidget *aWidget)
{
  NS_ENSURE_TRUE(aDOMEvent, NS_ERROR_FAILURE);
  NS_ENSURE_TRUE(aWidget, NS_ERROR_FAILURE);
  GtkMozEmbed *gtkmozembed = GTK_MOZ_EMBED(GetGtkMozEmbedFromWidget(aWidget));
  NS_ENSURE_TRUE(gtkmozembed, NS_ERROR_FAILURE);
  GMozillaEngine *mozengine = GetGMozillaEngine(gtkmozembed);
  NS_ENSURE_TRUE(mozengine, NS_ERROR_FAILURE);

  //content_set_cursor(mozengine, GDK_HEART);
  return NS_OK;
}

NS_IMETHODIMP
nsTouchInteractListener::OnMouseMoveHover(nsIDOMEvent *aDOMEvent, nsIWidget *aWidget)
{
  NS_ENSURE_TRUE(aDOMEvent, NS_ERROR_FAILURE);
  NS_ENSURE_TRUE(aWidget, NS_ERROR_FAILURE);
  GtkMozEmbed *gtkmozembed = GTK_MOZ_EMBED(GetGtkMozEmbedFromWidget(aWidget));
  NS_ENSURE_TRUE(gtkmozembed, NS_ERROR_FAILURE);
  GMozillaEngine *mozengine = GetGMozillaEngine(gtkmozembed);
  NS_ENSURE_TRUE(mozengine, NS_ERROR_FAILURE);

  //content_set_cursor(mozengine, GDK_HEART);
  return NS_OK;
}

NS_IMETHODIMP
nsTouchInteractListener::OnMouseUpHover(nsIDOMEvent *aDOMEvent, nsIWidget *aWidget)
{
  NS_ENSURE_TRUE(aDOMEvent, NS_ERROR_FAILURE);
  NS_ENSURE_TRUE(aWidget, NS_ERROR_FAILURE);
  GtkMozEmbed *gtkmozembed = GTK_MOZ_EMBED(GetGtkMozEmbedFromWidget(aWidget));
  NS_ENSURE_TRUE(gtkmozembed, NS_ERROR_FAILURE);
  GMozillaEngine *mozengine = GetGMozillaEngine(gtkmozembed);
  NS_ENSURE_TRUE(mozengine, NS_ERROR_FAILURE);

  //content_set_cursor(mozengine, GDK_HEART);
  return NS_OK;
}

NS_IMETHODIMP
nsTouchInteractListener::OnMouseDownInput(nsIDOMEvent *aDOMEvent, nsIWidget *aWidget)
{
  NS_ENSURE_TRUE(aDOMEvent, NS_ERROR_FAILURE);
  NS_ENSURE_TRUE(aWidget, NS_ERROR_FAILURE);
  GtkMozEmbed *gtkmozembed = GTK_MOZ_EMBED(GetGtkMozEmbedFromWidget(aWidget));
  NS_ENSURE_TRUE(gtkmozembed, NS_ERROR_FAILURE);
  GMozillaEngine *mozengine = GetGMozillaEngine(gtkmozembed);
  NS_ENSURE_TRUE(mozengine, NS_ERROR_FAILURE);

  dom_mouse_down_cb(gtkmozembed, aDOMEvent, mozengine);
  //content_set_cursor(mozengine, GDK_MAN);
  return NS_OK;
}

NS_IMETHODIMP
nsTouchInteractListener::OnMouseMoveInput(nsIDOMEvent *aDOMEvent, nsIWidget *aWidget)
{
  NS_ENSURE_TRUE(aDOMEvent, NS_ERROR_FAILURE);
  NS_ENSURE_TRUE(aWidget, NS_ERROR_FAILURE);
  GtkMozEmbed *gtkmozembed = GTK_MOZ_EMBED(GetGtkMozEmbedFromWidget(aWidget));
  NS_ENSURE_TRUE(gtkmozembed, NS_ERROR_FAILURE);
  GMozillaEngine *mozengine = GetGMozillaEngine(gtkmozembed);
  NS_ENSURE_TRUE(mozengine, NS_ERROR_FAILURE);

  //content_set_cursor(mozengine, GDK_MAN);
  return NS_OK;
}

NS_IMETHODIMP
nsTouchInteractListener::OnMouseUpInput(nsIDOMEvent *aDOMEvent, nsIWidget *aWidget)
{
  NS_ENSURE_TRUE(aDOMEvent, NS_ERROR_FAILURE);
  NS_ENSURE_TRUE(aWidget, NS_ERROR_FAILURE);
  GtkMozEmbed *gtkmozembed = GTK_MOZ_EMBED(GetGtkMozEmbedFromWidget(aWidget));
  NS_ENSURE_TRUE(gtkmozembed, NS_ERROR_FAILURE);
  GMozillaEngine *mozengine = GetGMozillaEngine(gtkmozembed);
  NS_ENSURE_TRUE(mozengine, NS_ERROR_FAILURE);

  //content_set_cursor(mozengine, GDK_MAN);
  return NS_OK;
}

NS_IMETHODIMP nsTouchInteractListener::OnMouseDownMono(nsIDOMEvent *aDOMEvent, nsIWidget *aWidget)
{
  NS_ENSURE_TRUE(aDOMEvent, NS_ERROR_FAILURE);
  NS_ENSURE_TRUE(aWidget, NS_ERROR_FAILURE);
  GtkMozEmbed *gtkmozembed = GTK_MOZ_EMBED(GetGtkMozEmbedFromWidget(aWidget));
  NS_ENSURE_TRUE(gtkmozembed, NS_ERROR_FAILURE);
  GMozillaEngine *mozengine = GetGMozillaEngine(gtkmozembed);
  NS_ENSURE_TRUE(mozengine, NS_ERROR_FAILURE);

  dom_mouse_down_cb(gtkmozembed, aDOMEvent, mozengine);
  return NS_OK;
}

NS_IMETHODIMP nsTouchInteractListener::OnMouseMoveMono(nsIDOMEvent *aDOMEvent, nsIWidget *aWidget)
{
  NS_ENSURE_TRUE(aDOMEvent, NS_ERROR_FAILURE);
  NS_ENSURE_TRUE(aWidget, NS_ERROR_FAILURE);
  GtkMozEmbed *gtkmozembed = GTK_MOZ_EMBED(GetGtkMozEmbedFromWidget(aWidget));
  NS_ENSURE_TRUE(gtkmozembed, NS_ERROR_FAILURE);
  GMozillaEngine *mozengine = GetGMozillaEngine(gtkmozembed);
  NS_ENSURE_TRUE(mozengine, NS_ERROR_FAILURE);

  return NS_OK;
}

NS_IMETHODIMP nsTouchInteractListener::OnMouseUpMono(nsIDOMEvent *aDOMEvent, nsIWidget *aWidget)
{
  NS_ENSURE_TRUE(aDOMEvent, NS_ERROR_FAILURE);
  NS_ENSURE_TRUE(aWidget, NS_ERROR_FAILURE);
  GtkMozEmbed *gtkmozembed = GTK_MOZ_EMBED(GetGtkMozEmbedFromWidget(aWidget));
  NS_ENSURE_TRUE(gtkmozembed, NS_ERROR_FAILURE);
  GMozillaEngine *mozengine = GetGMozillaEngine(gtkmozembed);
  NS_ENSURE_TRUE(mozengine, NS_ERROR_FAILURE);

  return NS_OK;
}

//static
GtkMozEmbed*
nsTouchInteractListener::GetGtkMozEmbedFromWidget(nsIWidget *aWidget)
{
  NS_ENSURE_TRUE(aWidget, nsnull);
  GdkWindow *gtkwin = GDK_WINDOW(aWidget->GetNativeData(NS_NATIVE_WIDGET));
  NS_ENSURE_TRUE(gtkwin, nsnull);
  gpointer user_data = NULL;
  gdk_window_get_user_data(gtkwin, &user_data);
  NS_ENSURE_TRUE(user_data, nsnull);
  //this should be a MozContainer, and his parent should be gtkmozembed
  GtkWidget *gtkwidget = GTK_WIDGET(user_data);
  NS_ENSURE_TRUE(gtkwidget, nsnull);

  return GTK_MOZ_EMBED(gtk_widget_get_parent(gtkwidget));
}

//static
GMozillaEngine*
nsTouchInteractListener::GetGMozillaEngine(GtkMozEmbed *aGtkMozEmbed)
{
  return G_MOZILLA_ENGINE(g_object_get_data(G_OBJECT(aGtkMozEmbed), "eal_parent"));
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////
/* static */
nsTouchInteractListener*
nsTouchInteractListener::GetInstance()
{
  if (!sTouchInteractListener) {
    sTouchInteractListener = new nsTouchInteractListener();
    NS_ENSURE_TRUE(sTouchInteractListener, nsnull);
    NS_ADDREF(sTouchInteractListener); // addref the global
  } else
    NS_ADDREF(sTouchInteractListener); // addref the return result

  return sTouchInteractListener;
}

/* static */
void nsTouchInteractListener::DeleteInstance()
{
  delete sTouchInteractListener;
  sTouchInteractListener = nsnull;
}

/* End of implementation class template. */
