/* vim:set ts=2 sw=2 sts=2 tw=80 et cindent: */
/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#ifndef nsSHistoryThumbnailManager_h__
#define nsSHistoryThumbnailManager_h__

#include "nsISHistoryThumbnailManager.h"
#include <nsISHistoryListener.h>
#include <nsWeakReference.h>
#include <nsStringAPI.h>
#include <nsCOMPtr.h>
#include <nsVoidArray.h>
#include <nsIURI.h>
#include <nsIWebProgressListener.h>
#include <nsIDOMEventTarget.h>
#include <nsIDOMEventListener.h>
#include "gmozillaengine.h"
#include "gwebcommon.h"

class HistoryListener : public nsISHistoryListener,
                        public nsSupportsWeakReference
{
  GMozillaEngine* mEngine;
  nsCOMPtr<nsIURI> mURI;

  GWebEngineEncoding GetEncoding(void);
public:
  HistoryListener() {}
  virtual ~HistoryListener() { mEngine = nsnull; }

  void SetEngine(GMozillaEngine* engine) { mEngine = engine; }

  NS_DECL_ISUPPORTS
  NS_DECL_NSISHISTORYLISTENER
};

class nsThumbnailProvider : public nsIThumbnailProvider
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSITHUMBNAILPROVIDER

  nsThumbnailProvider();

private:
  ~nsThumbnailProvider();

protected:
  /* additional members */
};

class nsISHistory;
class nsIDOMEvent;

class nsSHistoryThumbnailManager : public nsISHistoryThumbnailManager,
                                   public nsISHistoryListener,
                                   public nsIWebProgressListener,
                                   public nsSupportsWeakReference
{
public:

    nsSHistoryThumbnailManager();
    nsresult Init();

private:
    ~nsSHistoryThumbnailManager();

    NS_DECL_ISUPPORTS
    NS_DECL_NSISHISTORYTHUMBNAILMANAGER
    NS_DECL_NSISHISTORYLISTENER
    NS_DECL_NSIWEBPROGRESSLISTENER

    nsresult RemoveDataFiles();
    static nsresult GetSessionHistory(
            nsIDOMWindow* aDOMWindow, 
            nsISHistory** aSessionHistory);
    nsresult GetThumbnailFolder(nsILocalFile** aFolder);
    nsresult doCreateThumbnail();
    nsresult GetWindowEventTarget(nsIDOMEventTarget** aEventTarget);

    class SHistoryThumbnailItem 
    {
    public:
        inline SHistoryThumbnailItem(nsCString* aUri, 
                                     nsCString* aThumbnailFileName) 
        : mUri(aUri), 
          mThumbnailFileName(aThumbnailFileName)
        {};
        inline ~SHistoryThumbnailItem() 
        {
            delete mUri;
            delete mThumbnailFileName;
        };
        nsCString* mUri;                // Owned
        nsCString* mThumbnailFileName;  // Owned
    };

    void ClearThumbnailContainer();
    SHistoryThumbnailItem* SHistoryItemByUri(nsACString &aURI);

    
private:
    nsCOMPtr<nsIDOMWindow> mDOMWindow;
    nsCOMPtr<nsIThumbnailProvider> mThumbnailProvider;
    nsVoidArray mThumbnailContainer;
    nsCAutoString mThumbnailFolder;
    PRInt32 mWidth; 
    PRInt32 mHeight;
    nsIURI* mNewURI;
    HistoryListener* mHistoryListener;
    PRBool mRedirecting;
    nsCAutoString mRedirectedUri;

};

#endif // nsSHistoryThumbnailManager_h__
