/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 tw=80 et cindent: */
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Mozilla browser.
 *
 * The Original Code is mozilla.org code.
 *
 * The Initial Developer of the Original Code is
 * Oleg Romashin.
 * Portions created by the Initial Developer are Copyright (C) 2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Oleg Romashin <romaxa@gmail.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */
#ifndef MicrobEalContextMenuInfo_h__
#define MicrobEalContextMenuInfo_h__

#include "nsCOMPtr.h"
#include "nsStringGlue.h"
#include "gtkmicrob_context.h"
#include "common.h"

class nsIDOMEvent;
class nsIDOMNode;
class nsIDOMWindow;
class nsIDOMDocument;
class nsIDOMViewCSS;
class imgIRequest;
class nsIURI;
class nsIDOMNSElement;
class nsIScrollableView;
class nsIDOMElement;

//*****************************************************************************
// class MicrobEalContextMenuInfo
//
//*****************************************************************************
class MicrobEalContextMenuInfo : public nsISupports
{
public:
  MicrobEalContextMenuInfo (GtkMicroBContext *ctx, const void *aEmbed = nsnull);
  virtual ~MicrobEalContextMenuInfo (void);

  NS_DECL_ISUPPORTS

  nsresult UpdateContextData (nsIDOMEvent *aDOMEvent);
  nsresult UpdateContextDataFromNode (nsIDOMNode *aDOMNode);
  nsresult UpdateContextDataFromElement(nsIDOMNSElement* aDOMElement);
  nsresult GetContextText (nsAString &aString, PRBool aSelection = PR_TRUE, PRInt32 *aSelStart = nsnull);
  nsresult GetJSHandledInfo (nsIDOMEvent *aEvent, PRInt32 *aIsJSHandled = nsnull);
  nsresult InsertTextToNode (nsIDOMNode *aDOMNode, nsAString &aString, PRInt32 surr1, PRInt32 surr2);
  nsresult GetCSSBackground   (nsIDOMNode *node, nsAString& url);
  static int GetScrollableType(nsIScrollableView *aScrollView, PRBool aIgnoreHidden = PR_FALSE);
  int GetScrollableType(PRBool aIgnoreHidden = PR_FALSE);
  nsresult UpdateScrollableView(nsIDOMNode *aDOMNode = nsnull, int aDirection = 0);
  nsresult ScrollScrollableView(PRInt32 aDX, PRInt32 aDY);

// Utils
  static nsresult CheckDomImageElement (nsIDOMNode *node, nsString& aHref, PRInt32 &aWidth, PRInt32 &aHeight, PRUint32 *aSize = nsnull);
  static nsresult GetImageRequest (imgIRequest **aRequest, nsIDOMNode *aDOMNode);
  static nsresult ScrollToSelectedNode(nsISupports *element);
  static nsresult DoCommand(nsISupports *aContext, const char *aCommand, PRInt32 aCount);
  static nsresult GetDomWindowScrollInfo(nsIDOMWindow *aDOMWindow, PRInt32 *aW, PRInt32 *aH, PRInt32 *aScrMX, PRInt32 *aScrMY, PRInt32 *aScrX, PRInt32 *aScrY, PRBool aFlush = PR_FALSE);
  static nsresult GetViewToScroll(nsIDOMNode *aDOMNode, nsIScrollableView **aScrollView, int aDirection);

  nsCOMPtr<nsIDOMNode>       mEventNode;
  nsCOMPtr<nsIDOMNode>       mOrigNode;

private:

  nsresult SetFramePosition(void);
  nsresult CheckRichEdit(void);
  nsresult CheckFormControl(nsIDOMNode* aNode = nsnull);
  nsresult CheckDomHtmlNode(nsIDOMNode* aNode, PRBool &aHasImage);
  nsresult GetEventData ();
  nsresult ResolveBaseURL     (const nsAString &relurl, nsACString &url);
  nsresult SetIntProperty     (const char *name, int value);
  nsresult SetStringProperty  (const char *name, const char *value);
  nsresult SetStringProperty  (const char *name, const nsAString &value);
  nsresult GetElementTitle    (nsIDOMNode *aNode, nsString &title);

  GtkMicroBContext           *mCtx;
  const void                 *mEmbed;

  nsCOMPtr<nsIDOMEvent>      mCtxEvent;
  nsCOMPtr<nsIDOMViewCSS>    mViewCSS;
  nsCOMPtr<nsIURI>           mBaseURI;

  nsCOMPtr<nsIDOMDocument>   mCtxDocument;

  PRUint32                   mCtxFormType;

  PRUint32                   mIsScrollableElement;
  PRUint32                   mIsJSHandledElement;
  nsCOMPtr<nsIDOMNode>       mInsertNode;
  nsIScrollableView*         mScrollableView;

}; // class MicrobEalContextMenuInfo

#endif // MicrobEalContextMenuInfo_h__
