
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the MICROB EAL package.
 *
 * The Initial Developer of the Original Code is Nokia Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contact: Oleg Romashin <oleg.romashin@nokia.com>
 *
 * ***** END LICENSE BLOCK ***** */



#include "testgmozillatransferitemlist.h"
#include "tests_common.h"

#include <assert.h>
#include <Automated.h>

#include <stdio.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "common.h"
#include <gwebtransferitem.h>
#include "gmozillatransferitemlist.h"
#include "gmozillacppwrapper.h"

typedef struct {
    GType expected_retvalue;
} GMozillaTransferItemListGetTypeStruct;
typedef struct {
    void* global;
    GObject* expected_retvalue;
} GMozillaTransferItemListNewStruct;
typedef struct {
    GMozillaTransferItemList** test_self_pp;
    GMozillaTransferItemList* self;
    GWebTransferItemListIface* iface;
    GMozillaTransferItem** testReferenceItems;
} IfaceGMozillaTransferItemListDestroyStruct;
typedef struct {
    GMozillaTransferItemList** test_self_pp;
    GMozillaTransferItemList* self;
    GWebTransferItemListIface* iface;
    GObject** expected_retvalue;
    GMozillaTransferItem** testReferenceItems;
} IfaceGMozillaTransferItemListGetItemsStruct;
typedef struct {
    GMozillaTransferItemList** test_self_pp;
    GMozillaTransferItemList* self;
    GWebTransferItemListIface* iface;
    gint expected_retvalue;
    GMozillaTransferItem** testReferenceItems;
} IfaceGMozillaTransferItemListGetItemsCountStruct;
typedef struct {
    GMozillaTransferItemList** test_self_pp;
    GMozillaTransferItemList* self;
    GWebTransferItemListIface* iface;
    int pos;
    GObject* expected_retvalue;
    GMozillaTransferItem** testReferenceItems;
} IfaceGMozillaTransferItemListGetItemStruct;

typedef struct {
    gboolean automatic;
    gboolean basics;
    TestTableData g_mozilla_transfer_item_list_get_type;
    TestTableData g_mozilla_transfer_item_list_new;
    TestTableData iface_g_mozilla_transfer_item_list_destroy;
    TestTableData iface_g_mozilla_transfer_item_list_get_item;
    TestTableData iface_g_mozilla_transfer_item_list_get_items_count;
    TestTableData iface_g_mozilla_transfer_item_list_get_items;
} TestData;
TestData testdata;

static void init_test_data()
{
    testdata.automatic = FALSE;
    testdata.basics = FALSE;

    g_list_free(testdata.g_mozilla_transfer_item_list_get_type.table);
    testdata.g_mozilla_transfer_item_list_get_type.table = NULL;
    testdata.g_mozilla_transfer_item_list_get_type.index = -1;

    g_list_free(testdata.g_mozilla_transfer_item_list_new.table);
    testdata.g_mozilla_transfer_item_list_new.table = NULL;
    testdata.g_mozilla_transfer_item_list_new.index = -1;

    g_list_free(testdata.iface_g_mozilla_transfer_item_list_destroy.table);
    testdata.iface_g_mozilla_transfer_item_list_destroy.table = NULL;
    testdata.iface_g_mozilla_transfer_item_list_destroy.index = -1;

    g_list_free(testdata.iface_g_mozilla_transfer_item_list_get_item.table);
    testdata.iface_g_mozilla_transfer_item_list_get_item.table = NULL;
    testdata.iface_g_mozilla_transfer_item_list_get_item.index = -1;

    g_list_free(testdata.iface_g_mozilla_transfer_item_list_get_items_count.table);
    testdata.iface_g_mozilla_transfer_item_list_get_items_count.table = NULL;
    testdata.iface_g_mozilla_transfer_item_list_get_items_count.index = -1;

    g_list_free(testdata.iface_g_mozilla_transfer_item_list_get_items.table);
    testdata.iface_g_mozilla_transfer_item_list_get_items.table = NULL;
    testdata.iface_g_mozilla_transfer_item_list_get_items.index = -1;

}

static GMozillaTransferItemList* testmozillatransferitemlist_create_transfer_list_with_items(int childCount, GMozillaTransferItem** copyOfItems);

/**
 * New test case added automatically by test creation script.
 */
void test_g_mozilla_transfer_item_list_get_type(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_transfer_item_list_get_type");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.g_mozilla_transfer_item_list_get_type.index;
        printf("Index of test data: %i\n", test_index);
        GMozillaTransferItemListGetTypeStruct* test_item_data =
            (GMozillaTransferItemListGetTypeStruct*)g_list_nth_data(testdata.g_mozilla_transfer_item_list_get_type.table, test_index);
        testdata.g_mozilla_transfer_item_list_get_type.index++;
        GType retvalue;
        if(testdata.basics) {
            retvalue = g_mozilla_transfer_item_list_get_type();
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            GType expected_retvalue = test_item_data->expected_retvalue;
            retvalue = g_mozilla_transfer_item_list_get_type();
            CU_ASSERT_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_mozilla_transfer_item_list_new(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_transfer_item_list_new");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.g_mozilla_transfer_item_list_new.index;
        printf("Index of test data: %i\n", test_index);
        GMozillaTransferItemListNewStruct* test_item_data =
            (GMozillaTransferItemListNewStruct*)g_list_nth_data(testdata.g_mozilla_transfer_item_list_new.table, test_index);
        testdata.g_mozilla_transfer_item_list_new.index++;
        void* global = test_item_data->global;
        GObject* retvalue;
        if(testdata.basics) {
            retvalue = g_mozilla_transfer_item_list_new(global);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            GObject* expected_retvalue = test_item_data->expected_retvalue;
            retvalue = g_mozilla_transfer_item_list_new(global);
            CU_ASSERT_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_iface_g_mozilla_transfer_item_list_destroy(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_transfer_item_list_destroy");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.iface_g_mozilla_transfer_item_list_destroy.index;
        printf("Index of test data: %i\n", test_index);
        IfaceGMozillaTransferItemListDestroyStruct* test_item_data =
            (IfaceGMozillaTransferItemListDestroyStruct*)g_list_nth_data(testdata.iface_g_mozilla_transfer_item_list_destroy.table, test_index);
        testdata.iface_g_mozilla_transfer_item_list_destroy.index++;

        GMozillaTransferItemList* self = test_item_data->self;
        GWebTransferItemListIface* iface = test_item_data->iface;
        GMozillaTransferItem** testReferenceItems = test_item_data->testReferenceItems;
        if(testdata.basics) {
            iface->destroy(G_WEB_TRANSFER_ITEM_LIST(self));
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            iface->destroy(G_WEB_TRANSFER_ITEM_LIST(self));
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_iface_g_mozilla_transfer_item_list_get_items(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_transfer_item_list_get_items");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.iface_g_mozilla_transfer_item_list_get_items.index;
        printf("Index of test data: %i\n", test_index);
        IfaceGMozillaTransferItemListGetItemsStruct* test_item_data =
            (IfaceGMozillaTransferItemListGetItemsStruct*)g_list_nth_data(testdata.iface_g_mozilla_transfer_item_list_get_items.table, test_index);
        testdata.iface_g_mozilla_transfer_item_list_get_items.index++;

        GMozillaTransferItemList* self = test_item_data->self;
        GWebTransferItemListIface* iface = test_item_data->iface;
        GMozillaTransferItem** testReferenceItems = test_item_data->testReferenceItems;
        GObject** retvalue;
        if(testdata.basics) {
            retvalue = iface->get_items(G_WEB_TRANSFER_ITEM_LIST(self));
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            GObject** expected_retvalue = test_item_data->expected_retvalue;
            retvalue = iface->get_items(G_WEB_TRANSFER_ITEM_LIST(self));
            CU_ASSERT_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}
/**
 * New test case added automatically by test creation script.
 */
void test_iface_g_mozilla_transfer_item_list_get_items_count(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_transfer_item_list_get_items_count");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.iface_g_mozilla_transfer_item_list_get_items_count.index;
        printf("Index of test data: %i\n", test_index);
        IfaceGMozillaTransferItemListGetItemsCountStruct* test_item_data =
            (IfaceGMozillaTransferItemListGetItemsCountStruct*)g_list_nth_data(testdata.iface_g_mozilla_transfer_item_list_get_items_count.table, test_index);
        testdata.iface_g_mozilla_transfer_item_list_get_items_count.index++;

        GMozillaTransferItemList* self = test_item_data->self;
        GWebTransferItemListIface* iface = test_item_data->iface;
        GMozillaTransferItem** testReferenceItems = test_item_data->testReferenceItems;
        gint retvalue;
        if(testdata.basics) {
            retvalue = iface->get_items_count(G_WEB_TRANSFER_ITEM_LIST(self));
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            gint expected_retvalue = test_item_data->expected_retvalue;
            retvalue = iface->get_items_count(G_WEB_TRANSFER_ITEM_LIST(self));
            CU_ASSERT_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_iface_g_mozilla_transfer_item_list_get_item(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_transfer_item_list_get_item");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.iface_g_mozilla_transfer_item_list_get_item.index;
        printf("Index of test data: %i\n", test_index);
        IfaceGMozillaTransferItemListGetItemStruct* test_item_data =
            (IfaceGMozillaTransferItemListGetItemStruct*)g_list_nth_data(testdata.iface_g_mozilla_transfer_item_list_get_item.table, test_index);
        testdata.iface_g_mozilla_transfer_item_list_get_item.index++;

        GMozillaTransferItemList* self = test_item_data->self;
        GWebTransferItemListIface* iface = test_item_data->iface;
        GMozillaTransferItem** testReferenceItems = test_item_data->testReferenceItems;
        int pos = test_item_data->pos;
        GMozillaTransferItem* retvalue;
        if(testdata.basics) {
            if(!self->items)
            {
                printf("TESTS: Pointer to items not found!");
            }
            else
            {
                printf("TESTS: Pointer to items: %X\n", (int)self->items);
            }
            retvalue = (GMozillaTransferItem*)iface->get_item(G_WEB_TRANSFER_ITEM_LIST(self), pos);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            GObject* expected_retvalue = test_item_data->expected_retvalue;
            retvalue = iface->get_item(G_WEB_TRANSFER_ITEM_LIST(self), pos);
            CU_ASSERT_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}
/**
 * Init function created by test creation script. It is success always.
 */
static int
testgmozillatransferitemlist_automatic_init()
{
    INIT_OR_CLEAN_STARTED("testgmozillatransferitemlist_init");
    //init_test_data();
    testdata.automatic = TRUE;
    return 0;
}

/**
 * Clean function created by test creation script. It is success always.
 */
static int
testgmozillatransferitemlist_automatic_clean()
{
    INIT_OR_CLEAN_STARTED("testgmozillatransferitemlist_clean");
    testdata.automatic = FALSE;
    return 0;
}

/**
 * Init function created by test creation script. It is success always.
 */
static int
testgmozillatransferitemlist_basics_init()
{
    INIT_OR_CLEAN_STARTED("testgmozillatransferitemlist_basics_init");
    g_type_init();
    init_test_data();
    testdata.basics = TRUE;
    GMozillaTransferItemListGetTypeStruct* tmp_g_mozilla_transfer_item_list_get_type = g_new0(GMozillaTransferItemListGetTypeStruct, 1);
    /* GType */tmp_g_mozilla_transfer_item_list_get_type->expected_retvalue = 0;
    testdata.g_mozilla_transfer_item_list_get_type.table =
        g_list_append (testdata.g_mozilla_transfer_item_list_get_type.table, tmp_g_mozilla_transfer_item_list_get_type);
    testdata.g_mozilla_transfer_item_list_get_type.index = 0;

    GMozillaTransferItemListNewStruct* tmp_g_mozilla_transfer_item_list_new = g_new0(GMozillaTransferItemListNewStruct, 1);
    /* void* */tmp_g_mozilla_transfer_item_list_new->global = NULL;
    /* GObject* */tmp_g_mozilla_transfer_item_list_new->expected_retvalue = 0;
    testdata.g_mozilla_transfer_item_list_new.table =
        g_list_append (testdata.g_mozilla_transfer_item_list_new.table, tmp_g_mozilla_transfer_item_list_new);
    testdata.g_mozilla_transfer_item_list_new.index = 0;

    return 0;
}

/**
 * Clean function created by test creation script. It is success always.
 */
static int
testgmozillatransferitemlist_basics_clean()
{
    INIT_OR_CLEAN_STARTED("testgmozillatransferitemlist_basics_clean");
    testdata.basics = FALSE;
    return 0;
}

/**
 * Init function created by test creation script. It is success always.
 */
static int
testgmozillatransferitemlist_advanced_init()
{
    INIT_OR_CLEAN_STARTED("testgmozillatransferitemlist_advanced_init");
    g_type_init();
    init_test_data();
    return 0;
}

/**
 * Clean function created by test creation script. It is success always.
 */
static int
testgmozillatransferitemlist_advanced_clean()
{
    INIT_OR_CLEAN_STARTED("testgmozillatransferitemlist_advanced_clean");
    return 0;
}

/**
 * Init function created by test creation script. It is success always.
 */
static int
testgmozillatransferitemlist_interface_init()
{
    INIT_OR_CLEAN_STARTED("testgmozillatransferitemlist_interface_init");
    g_type_init();
    init_test_data();

    testdata.basics = TRUE;

    int childCount = 0;
    GMozillaTransferItem** copyOfItems = NULL;
    GMozillaTransferItemList* list = G_MOZILLA_TRANSFER_ITEM_LIST(testmozillatransferitemlist_create_transfer_list_with_items(childCount, copyOfItems));
    if(list == NULL)
    {
        return 1;
    }

    IfaceGMozillaTransferItemListGetItemsStruct* tmp_iface_g_mozilla_transfer_item_list_get_items =
        g_new0(IfaceGMozillaTransferItemListGetItemsStruct, 1);
    /* GMozillaTransferItemList* */tmp_iface_g_mozilla_transfer_item_list_get_items->self = list;
    /* GMozillaTransferItem** */tmp_iface_g_mozilla_transfer_item_list_get_items->testReferenceItems = copyOfItems;
    /* GWebTransferItemListInterface* */tmp_iface_g_mozilla_transfer_item_list_get_items->iface =
        g_type_interface_peek (g_type_class_peek (G_OBJECT_TYPE (tmp_iface_g_mozilla_transfer_item_list_get_items->self)), G_TYPE_WEB_TRANSFER_ITEM);
    testdata.iface_g_mozilla_transfer_item_list_get_items.table =
        g_list_append (testdata.iface_g_mozilla_transfer_item_list_get_items.table,
                tmp_iface_g_mozilla_transfer_item_list_get_items);
    testdata.iface_g_mozilla_transfer_item_list_get_items.index = 0;

    IfaceGMozillaTransferItemListGetItemsCountStruct* tmp_iface_g_mozilla_transfer_item_list_get_items_count =
        g_new0(IfaceGMozillaTransferItemListGetItemsCountStruct, 1);
    /* GMozillaTransferItemList* */tmp_iface_g_mozilla_transfer_item_list_get_items_count->self = list;
    /* GMozillaTransferItem** */tmp_iface_g_mozilla_transfer_item_list_get_items_count->testReferenceItems = copyOfItems;
    /* GWebTransferItemListInterface* */tmp_iface_g_mozilla_transfer_item_list_get_items_count->iface =
        g_type_interface_peek (g_type_class_peek (G_OBJECT_TYPE (tmp_iface_g_mozilla_transfer_item_list_get_items_count->self)), G_TYPE_WEB_TRANSFER_ITEM);
    testdata.iface_g_mozilla_transfer_item_list_get_items_count.table =
        g_list_append (testdata.iface_g_mozilla_transfer_item_list_get_items_count.table,
                tmp_iface_g_mozilla_transfer_item_list_get_items_count);
    testdata.iface_g_mozilla_transfer_item_list_get_items_count.index = 0;

    IfaceGMozillaTransferItemListGetItemStruct* tmp_iface_g_mozilla_transfer_item_list_get_item =
        g_new0(IfaceGMozillaTransferItemListGetItemStruct, 1);
    /* GMozillaTransferItemList* */tmp_iface_g_mozilla_transfer_item_list_get_item->self = list;
    /* gint* */tmp_iface_g_mozilla_transfer_item_list_get_item->pos = 0;
    /* GMozillaTransferItem** */tmp_iface_g_mozilla_transfer_item_list_get_item->testReferenceItems = copyOfItems;
    /* GWebTransferItemListInterface* */tmp_iface_g_mozilla_transfer_item_list_get_item->iface =
        g_type_interface_peek (g_type_class_peek (G_OBJECT_TYPE (tmp_iface_g_mozilla_transfer_item_list_get_item->self)), G_TYPE_WEB_TRANSFER_ITEM);
    testdata.iface_g_mozilla_transfer_item_list_get_item.table =
        g_list_append (testdata.iface_g_mozilla_transfer_item_list_get_item.table,
                tmp_iface_g_mozilla_transfer_item_list_get_item);
    testdata.iface_g_mozilla_transfer_item_list_get_item.index = 0;

    IfaceGMozillaTransferItemListDestroyStruct* tmp_iface_g_mozilla_transfer_item_list_destroy =
        g_new0(IfaceGMozillaTransferItemListDestroyStruct, 1);
    /* GMozillaTransferItemList* */tmp_iface_g_mozilla_transfer_item_list_destroy->self = list;
    /* GMozillaTransferItem** */tmp_iface_g_mozilla_transfer_item_list_destroy->testReferenceItems = copyOfItems;
    /* GWebTransferItemListInterface* */tmp_iface_g_mozilla_transfer_item_list_destroy->iface =
        g_type_interface_peek (g_type_class_peek (G_OBJECT_TYPE (tmp_iface_g_mozilla_transfer_item_list_destroy->self)), G_TYPE_WEB_TRANSFER_ITEM);
    testdata.iface_g_mozilla_transfer_item_list_destroy.table =
        g_list_append (testdata.iface_g_mozilla_transfer_item_list_destroy.table,
                tmp_iface_g_mozilla_transfer_item_list_destroy);
    testdata.iface_g_mozilla_transfer_item_list_destroy.index = 0;


    return 0;
}

/**
 * Clean function created by test creation script. It is success always.
 */
static int
testgmozillatransferitemlist_interface_clean()
{
    INIT_OR_CLEAN_STARTED("testgmozillatransferitemlist_interface_clean");
    testdata.basics = FALSE;
    return 0;
}

/**
 * Init function created by test creation script. It is success always.
 */
static int
testgmozillatransferitemlist_interface2_init()
{
    INIT_OR_CLEAN_STARTED("testgmozillatransferitemlist_interface2_init");
    g_type_init();
    init_test_data();

    testdata.basics = TRUE;

    int childCount = 10;
    GMozillaTransferItem** copyOfItems = g_try_new0(GMozillaTransferItem*, childCount);
    if(!copyOfItems)
    {
        return 1;
    }
    GMozillaTransferItemList* list = G_MOZILLA_TRANSFER_ITEM_LIST(testmozillatransferitemlist_create_transfer_list_with_items(childCount, copyOfItems));
    if(list == NULL)
    {
        return 1;
    }

    IfaceGMozillaTransferItemListGetItemsStruct* tmp_iface_g_mozilla_transfer_item_list_get_items =
        g_new0(IfaceGMozillaTransferItemListGetItemsStruct, 1);
    /* GMozillaTransferItemList* */tmp_iface_g_mozilla_transfer_item_list_get_items->self = list;
    /* GMozillaTransferItem** */tmp_iface_g_mozilla_transfer_item_list_get_items->testReferenceItems = copyOfItems;
    /* GWebTransferItemListInterface* */tmp_iface_g_mozilla_transfer_item_list_get_items->iface =
        g_type_interface_peek (g_type_class_peek (G_OBJECT_TYPE (tmp_iface_g_mozilla_transfer_item_list_get_items->self)), G_TYPE_WEB_TRANSFER_ITEM);
    testdata.iface_g_mozilla_transfer_item_list_get_items.table =
        g_list_append (testdata.iface_g_mozilla_transfer_item_list_get_items.table,
                tmp_iface_g_mozilla_transfer_item_list_get_items);
    testdata.iface_g_mozilla_transfer_item_list_get_items.index = 0;

    IfaceGMozillaTransferItemListGetItemsCountStruct* tmp_iface_g_mozilla_transfer_item_list_get_items_count =
        g_new0(IfaceGMozillaTransferItemListGetItemsCountStruct, 1);
    /* GMozillaTransferItemList* */tmp_iface_g_mozilla_transfer_item_list_get_items_count->self = list;
    /* GMozillaTransferItem** */tmp_iface_g_mozilla_transfer_item_list_get_items_count->testReferenceItems = copyOfItems;
    /* GWebTransferItemListInterface* */tmp_iface_g_mozilla_transfer_item_list_get_items_count->iface =
        g_type_interface_peek (g_type_class_peek (G_OBJECT_TYPE (tmp_iface_g_mozilla_transfer_item_list_get_items_count->self)), G_TYPE_WEB_TRANSFER_ITEM);
    testdata.iface_g_mozilla_transfer_item_list_get_items_count.table =
        g_list_append (testdata.iface_g_mozilla_transfer_item_list_get_items_count.table,
                tmp_iface_g_mozilla_transfer_item_list_get_items_count);
    testdata.iface_g_mozilla_transfer_item_list_get_items_count.index = 0;

    IfaceGMozillaTransferItemListGetItemStruct* tmp_iface_g_mozilla_transfer_item_list_get_item =
        g_new0(IfaceGMozillaTransferItemListGetItemStruct, 1);
    /* GMozillaTransferItemList* */tmp_iface_g_mozilla_transfer_item_list_get_item->self = list;
    /* gint* */tmp_iface_g_mozilla_transfer_item_list_get_item->pos = 0;
    /* GMozillaTransferItem** */tmp_iface_g_mozilla_transfer_item_list_get_item->testReferenceItems = copyOfItems;
    /* GWebTransferItemListInterface* */tmp_iface_g_mozilla_transfer_item_list_get_item->iface =
        g_type_interface_peek (g_type_class_peek (G_OBJECT_TYPE (tmp_iface_g_mozilla_transfer_item_list_get_item->self)), G_TYPE_WEB_TRANSFER_ITEM);
    testdata.iface_g_mozilla_transfer_item_list_get_item.table =
        g_list_append (testdata.iface_g_mozilla_transfer_item_list_get_item.table,
                tmp_iface_g_mozilla_transfer_item_list_get_item);
    testdata.iface_g_mozilla_transfer_item_list_get_item.index = 0;

    IfaceGMozillaTransferItemListDestroyStruct* tmp_iface_g_mozilla_transfer_item_list_destroy =
        g_new0(IfaceGMozillaTransferItemListDestroyStruct, 1);
    /* GMozillaTransferItemList* */tmp_iface_g_mozilla_transfer_item_list_destroy->self = list;
    /* GMozillaTransferItem** */tmp_iface_g_mozilla_transfer_item_list_destroy->testReferenceItems = copyOfItems;
    /* GWebTransferItemListInterface* */tmp_iface_g_mozilla_transfer_item_list_destroy->iface =
        g_type_interface_peek (g_type_class_peek (G_OBJECT_TYPE (tmp_iface_g_mozilla_transfer_item_list_destroy->self)), G_TYPE_WEB_TRANSFER_ITEM);
    testdata.iface_g_mozilla_transfer_item_list_destroy.table =
        g_list_append (testdata.iface_g_mozilla_transfer_item_list_destroy.table,
                tmp_iface_g_mozilla_transfer_item_list_destroy);
    testdata.iface_g_mozilla_transfer_item_list_destroy.index = 0;


    return 0;
}

/**
 * Clean function created by test creation script. It is success always.
 */
static int
testgmozillatransferitemlist_interface2_clean()
{
    INIT_OR_CLEAN_STARTED("testgmozillatransferitemlist_interface2_clean");
    testdata.basics = FALSE;
    return 0;
}

/******************************************************************************
 * Private functions
 ******************************************************************************/
/**
 * Creates history list with number of items given in parameter.
 */
static GMozillaTransferItemList*
testmozillatransferitemlist_create_transfer_list_with_items(int childCount, GMozillaTransferItem** copyOfItems)
{
    GMozillaTransferItemList* list = G_MOZILLA_TRANSFER_ITEM_LIST(g_mozilla_transfer_item_list_new (NULL));
    if(list == NULL)
    {
        return NULL;
    }
    GMozillaTransferItem** transferItems = NULL;
    if(childCount > 0)
    {
        transferItems = g_try_new0(GMozillaTransferItem*, childCount);
        if (!transferItems) {
            g_free(list);
            list = NULL;
            return NULL;
        }
        int i = 0;
        while (i < childCount) {
            transferItems[i] = (GMozillaTransferItem*)g_mozilla_transfer_item_new();
            copyOfItems[i] = transferItems[i];
            ++i;
        }
    }
    G_MOZILLA_TRANSFER_ITEM_LIST(list)->items = (GObject**)transferItems;
    G_MOZILLA_TRANSFER_ITEM_LIST(list)->num_items = childCount;
    return list;
}

/**
 * All new test cases are going to start from here. They are also added to automatic suite.
 * DO NOT DELETE AUTOMATIC SUITE!
 */

static CU_TestInfo testgmozillatransferitemlist_automatic_added[] = {
        // Test is made { "test_g_mozilla_transfer_item_list_get_type", test_g_mozilla_transfer_item_list_get_type },
        // Test is made { "test_g_mozilla_transfer_item_list_new", test_g_mozilla_transfer_item_list_new },
        CU_TEST_INFO_NULL, //null terminated
};
static CU_TestInfo testgmozillatransferitemlist_basics[] = {
        { "test_g_mozilla_transfer_item_list_get_type", test_g_mozilla_transfer_item_list_get_type },
        { "test_g_mozilla_transfer_item_list_new", test_g_mozilla_transfer_item_list_new },
        CU_TEST_INFO_NULL, //null terminated
};
static CU_TestInfo testgmozillatransferitemlist_advanced[] = {
        //{ "test_g_mozilla_transfer_item_list_get_type", test_g_mozilla_transfer_item_list_get_type },
        //{ "test_g_mozilla_transfer_item_list_new", test_g_mozilla_transfer_item_list_new },
        CU_TEST_INFO_NULL, //null terminated
};

static CU_TestInfo testgmozillatransferitemlist_interface[] = {
        { "test_iface_g_mozilla_transfer_item_list_get_items", test_iface_g_mozilla_transfer_item_list_get_items },
        { "test_iface_g_mozilla_transfer_item_list_get_items_count", test_iface_g_mozilla_transfer_item_list_get_items_count },
        { "test_iface_g_mozilla_transfer_item_list_get_item", test_iface_g_mozilla_transfer_item_list_get_item },
        { "test_iface_g_mozilla_transfer_item_list_destroy", test_iface_g_mozilla_transfer_item_list_destroy },
        CU_TEST_INFO_NULL, //null terminated
};

/**
 * Main table holding all the test cases.
 */
CU_SuiteInfo testgmozillatransferitemlist[] = {
        {"testgmozillatransferitemlist_automatic_added", testgmozillatransferitemlist_automatic_init, testgmozillatransferitemlist_automatic_clean, testgmozillatransferitemlist_automatic_added },
        {"testgmozillatransferitemlist_basics", testgmozillatransferitemlist_basics_init, testgmozillatransferitemlist_basics_clean, testgmozillatransferitemlist_basics },
        {"testgmozillatransferitemlist_advanced", testgmozillatransferitemlist_advanced_init, testgmozillatransferitemlist_advanced_clean, testgmozillatransferitemlist_advanced },
        {"testgmozillatransferitemlist_interface", testgmozillatransferitemlist_interface_init, testgmozillatransferitemlist_interface_clean, testgmozillatransferitemlist_interface },
        {"testgmozillatransferitemlist_interface2", testgmozillatransferitemlist_interface2_init, testgmozillatransferitemlist_interface2_clean, testgmozillatransferitemlist_interface },
        CU_SUITE_INFO_NULL, //null terminated
};
