/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* vim:expandtab:shiftwidth=4:tabstop=4: */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is mozilla.org code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *  Brian Ryner <bryner@brianryner.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#ifndef __MicrobEalPromptService_h
#define __MicrobEalPromptService_h

#include "nsIPromptService2.h"
#include "nsINonBlockingAlertService.h"
#include "nsICookiePromptService.h"
#include "nsICookie.h"

class nsIDOMWindow;

class MicrobEalPromptService : public nsIPromptService2,
                               public nsINonBlockingAlertService,
                               public nsICookiePromptService
{
public:
    MicrobEalPromptService();
    virtual ~MicrobEalPromptService();

    NS_DECL_ISUPPORTS
    NS_DECL_NSIPROMPTSERVICE
    NS_DECL_NSIPROMPTSERVICE2
    NS_DECL_NSINONBLOCKINGALERTSERVICE
    NS_DECL_NSICOOKIEPROMPTSERVICE

};

#define MICROB_EAL_PROMPT_SERVICE_CID \
 {0x2a137abf, 0xcc6e, 0x43e8, {0x9d, 0x2f, 0x37, 0xa8, 0xdc, 0x4a, 0xec, 0x67}}

#define NS_NONBLOCKINGALERTSERVICE_CID \
 {0x59779c60, 0x6795, 0x4faa, {0x8d, 0x44, 0xf9, 0x7d, 0x5f, 0xf4, 0x3d, 0xd9}}

#define NS_COOKIEPROMPTSERVICE_CID \
 {0x1c677891, 0x1d8e, 0x4170, {0xad, 0xbd, 0x4b, 0x3b, 0xa0, 0x76, 0x19, 0x92}}

#endif /* __MicrobEalPromptService_h */
