#!/bin/sh
# maemo-optify-auto-opt
#######################################################
# Copyright: (C) 2010 Nokia
# License:   DO WHAT YOU WANT TO PUBLIC LICENSE
# Authors:   Leonid Moiseichuk, leonid.moiseichuk@nokia.com
#            Gary Birkett, gary.birkett@collabora.co.uk
#######################################################

# auto-opt script
# ensure a set of folders and files are optified
# run after installation, and each boot to relocate a set of folders

optifyroot="/opt"
optifyoptionspath="/etc/maemo-optify-auto-opt.conf"
protocol="$optifyroot/maemo-optify-auto-opt.log"
session=`date +"%F %T"`

#######################################################

log() {
  echo "$session :: $1" >> $protocol
}

optify_one () {
  # optify a single item (file or folder) if required
  # first sanity check the file exists and it is not a link
  src="$1"
  # remove noise from comments by treating src as a string here 
  # (otherwise it is expanded and tries to be parsed resulting in errors on comments)
  if [ -e "$src" ] && [ ! -L "$src" ]
  then
    # now we know the file exists, lets check if its a root item and not link
    srcdir=`dirname $src`
    srcname=`basename $src`

    dstdir="$optifyroot$srcdir"
    dst="$dstdir/$srcname"

    log "optifying $src to $dst"
    if [ -e $dst ]
    then
      log "optify_one removing preexisting $dst"
      rm -rf $dst
    fi

    # create folder structure upto required level
    mkdir --parent "$dstdir"
    cp -a $src $dstdir/
    sync
    rm -rf $src
    ln -s $dst $src
    sync
  fi
}

#######################################################

if [ ! -e /targets/links/scratchbox.config ] && [ -d $optifyroot ]
then
  log "*** optification session started `date +"%F %T"` ***"

  while read inputline
  do
    optify_one "$inputline"
  done < $optifyoptionspath

  log "*** optification session completed `date +"%F %T"` ***"
fi
return 0



