#include <stdlib.h>

#include "dbus-common.h"

#define BLUEZ_SERVICE "org.bluez"

#define BLUEZ_MANAGER_PATH "/"
#define BLUEZ_MANAGER_INTERFACE "org.bluez.Manager"
#define BLUEZ_ADAPTER_INTERFACE "org.bluez.Adapter"


DBusGProxy* bluez_get_manager(DBusGConnection *connection)
{
	return dbus_g_proxy_new_for_name(connection, BLUEZ_SERVICE,
					BLUEZ_MANAGER_PATH,
					BLUEZ_MANAGER_INTERFACE);
}


DBusGProxy* manager_get_default_adapter(DBusGProxy *manager,
					DBusGConnection *connection)
{
	GError *error = NULL;
	const gchar* adapter_path;

	if (!dbus_g_proxy_call(manager, "DefaultAdapter", &error,
				G_TYPE_INVALID,
				DBUS_TYPE_G_OBJECT_PATH, &adapter_path,
				G_TYPE_INVALID)) {

		g_debug("Couldn't get DefaultAdapter: %s", error->message);
		g_error_free(error);
		return NULL;
	}

	return dbus_g_proxy_new_for_name(connection, BLUEZ_SERVICE,
					adapter_path, BLUEZ_ADAPTER_INTERFACE);
}

void adapter_set_property_string(DBusGProxy* adapter, const gchar* attribute,
					const gchar* value)
{
	GError *error = NULL;
	GValue g_value = {0};

	g_value_init(&g_value, G_TYPE_STRING);
	g_value_set_string(&g_value, value);

	if (dbus_g_proxy_call(adapter, "SetProperty", &error,G_TYPE_STRING,
				attribute, G_TYPE_VALUE, &g_value,
				G_TYPE_INVALID, G_TYPE_INVALID ) != TRUE) {
		g_debug("Couldn't set string Properties: %s", error->message);
		g_error_free(error);
	}

	g_value_unset(&g_value);
}

const gchar* adapter_get_property_string(DBusGProxy* adapter,
					const gchar* attribute)
{
	GHashTable *table;
	GError *error = NULL;
	GValue *value;

	if (dbus_g_proxy_call(adapter, "GetProperties", &error, G_TYPE_INVALID,
					dbus_g_type_get_map("GHashTable",
								G_TYPE_STRING,
								G_TYPE_VALUE),
					&table, G_TYPE_INVALID) != FALSE) {
		value = g_hash_table_lookup(table, attribute);
		return g_value_get_string(value);
	} else {
		g_debug("Couldn't get string Properties: %s", error->message);
		g_error_free(error);
		return NULL;
	}
}

void adapter_set_property_boolean(DBusGProxy* adapter, const gchar* attribute,
					const gboolean value)
{
	GError *error = NULL;
	GValue g_value = {0};

	g_value_init(&g_value, G_TYPE_BOOLEAN);
	g_value_set_boolean(&g_value, value);

	if (dbus_g_proxy_call(adapter, "SetProperty", &error, G_TYPE_STRING,
				attribute, G_TYPE_VALUE, &g_value,
				G_TYPE_INVALID, G_TYPE_INVALID) != TRUE) {
		g_debug("Couldn't set boolean Properties: %s", error->message);
		g_error_free(error);
	}

	g_value_unset(&g_value);
}

gboolean adapter_get_property_boolean(DBusGProxy* adapter,
					const gchar* attribute)
{
	GHashTable *table;
	GError *error = NULL;
	GValue *value;

	if (dbus_g_proxy_call(adapter, "GetProperties", &error, G_TYPE_INVALID,
					dbus_g_type_get_map ("GHashTable",
								G_TYPE_STRING,
								G_TYPE_VALUE),
					&table, G_TYPE_INVALID) != FALSE) {
		value = g_hash_table_lookup(table, attribute);
		return g_value_get_boolean(value);
	} else {
		g_debug("Couldn't get boolean Properties: %s", error->message);
		g_error_free(error);
		return FALSE;
	}
}

void adapter_set_property_uint(DBusGProxy* adapter,const gchar* attribute,
				guint value)
{
	GError *error = NULL;
	GValue g_value = {0};

	g_value_init(&g_value, G_TYPE_UINT);
	g_value_set_uint(&g_value, value);

	if (dbus_g_proxy_call(adapter, "SetProperty", &error, G_TYPE_STRING,
				attribute, G_TYPE_VALUE, &g_value,
				G_TYPE_INVALID, G_TYPE_INVALID) != TRUE) {
		g_debug("Couldn't set int Properties: %s", error->message);
		g_error_free(error);
	}

	g_value_unset(&g_value);
}

guint adapter_get_property_uint(DBusGProxy* adapter, const gchar* attribute)
{
	GHashTable *table;
	GError *error = NULL;
	GValue *value;

	if (dbus_g_proxy_call(adapter, "GetProperties", &error, G_TYPE_INVALID,
					dbus_g_type_get_map("GHashTable",
								G_TYPE_STRING,
								G_TYPE_VALUE),
					&table, G_TYPE_INVALID) != FALSE) {
		value = g_hash_table_lookup(table, attribute);
		return g_value_get_uint(value);
	} else {
		g_debug("Couldn't get int Properties: %s", error->message);
		g_error_free(error);
		return 0;
	}
}

GPtrArray* adapter_get_property_objectpath_array(DBusGProxy* adapter,
							const gchar* attribute)
{
	GHashTable *table;
	GError *error = NULL;
	GValue *value;

	if (dbus_g_proxy_call(adapter, "GetProperties", &error, G_TYPE_INVALID,
					dbus_g_type_get_map("GHashTable",
								G_TYPE_STRING,
								G_TYPE_VALUE),
					&table, G_TYPE_INVALID) != FALSE) {
		value = g_hash_table_lookup(table, attribute);
		return g_value_get_boxed(value);
	} else {
		g_debug("Couldn't get object array Properties: %s",
							error->message);
		return NULL;
	}
}
