/*
 * This file is a part of hildon-fm tests
 *
 * Copyright (C) 2006-2008 Nokia Corporation, all rights reserved.
 *
 * Based on hildon-1 equivalent by: 
 * Michael Dominic Kostrzewa <michael.kostrzewa@nokia.com>
 *
 * Author: Jukka Kauppinen <jukka.p.kauppinen@nokia.com>
 *
 * Contacts: Richard Sun <richard.sun@nokia.com>
 *           Attila Domokos <attila.domokos@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <X11/Xlibint.h>
#include <gtk/gtk.h>
#include <gconf/gconf-client.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <pwd.h>

/* This is used for the Gconf availability check */
#define GCONF_TEST_PATH "/hildon/tests/flag"

/**
 * Create test folders for certain test suites
 */
static void
create_temp_folders()
{
    uid_t user_id = getuid ();
    struct passwd *info = getpwuid (user_id);
    char *home_folder =  info->pw_dir;
    char *target_folder = (char *) malloc ((strlen(home_folder) + 23) * sizeof(char));
    mode_t mode = (S_IRWXU | S_IRWXG | S_IRWXO | S_ISUID | S_ISVTX);
    int res = 0;
    FILE *tmp_file1 = NULL;
    FILE *tmp_file2 = NULL;
    FILE *tmp_file2_1 = NULL;
    FILE *tmp_file3 = NULL;

    strcpy (target_folder, home_folder);
    strcat (target_folder, "/MyDocs/hildonfmtests");
    res = mkdir (target_folder, mode);

    if (res == 0)
        printf ("Test directory created at %s.\n", target_folder);
    else
        printf("Test directory exists at %s or creation failed.\nIf you have modified its contents and are having problems running tests try removing the folder and running this again to regenerate the filestructure.\n", target_folder);

    char *sub_folder = (char *) malloc ((strlen(home_folder) + 41) * sizeof(char));

    strcpy (sub_folder, target_folder);
    strcat (sub_folder, "/folder1");
    mkdir (sub_folder, mode);

    strcpy (sub_folder, target_folder);
    strcat (sub_folder, "/folder2");
    mkdir (sub_folder, mode);

    strcpy (sub_folder, target_folder);
    strcat (sub_folder, "/folder3");
    mkdir (sub_folder, mode);

    strcat (sub_folder, "/subfolder");
    mkdir (sub_folder, mode);

    strcpy (sub_folder, target_folder);
    strcat (sub_folder, "/file1.txt");
    tmp_file1 = fopen (sub_folder, "w");
    fprintf (tmp_file1,
             "This test file has been generated by hildon-fm unit testing\n\n");
    fclose (tmp_file1);

    strcpy (sub_folder, target_folder);
    strcat (sub_folder, "/file2.txt");
    tmp_file2 = fopen (sub_folder, "w");
    fprintf (tmp_file2,
             "This test file has been generated by hildon-fm unit testing\n\n");
    fclose (tmp_file2);

    strcpy (sub_folder, target_folder);
    strcat (sub_folder, "/file2 (1).txt");
    tmp_file2_1 = fopen (sub_folder, "w");
    fprintf (tmp_file2_1,
             "This test file has been generated by hildon-fm unit testing\n\n");
    fclose (tmp_file2_1);

    strcpy (sub_folder, target_folder);
    strcat (sub_folder, "/folder3");
    strcat (sub_folder, "/file3.txt");
    tmp_file3 = fopen (sub_folder, "w");
    fprintf (tmp_file3,
             "This test file has been generated by hildon-fm unit testing\n\n");
    fclose (tmp_file3);

    free (target_folder);
    free (sub_folder);
}

/**
 * --------------------------------------------------------------------------
 * Main program
 * --------------------------------------------------------------------------
 */
int
main (int    argc,
      char** argv)
{
    GConfClient *client = NULL;
    GError *gconf_error = NULL;

    /* Create test folders for certain test suites */
    create_temp_folders ();
    /* Check environment is ok to run the tests */
    gtk_init (&argc, &argv);
    client = gconf_client_get_default ();
    gconf_client_get (client, GCONF_TEST_PATH ,&gconf_error);
    if (gconf_error)
    {
        printf ("GConf not running, please run af-sb-init.sh.");
        return EXIT_FAILURE;
    }
    return EXIT_SUCCESS;
}
