/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Nokia code.
 *
 * The Initial Developer of the Original Code is Novell.
 * Portions created by the Initial Developer are Copyright (C) 2008
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Aiken Tie <ext-tie.aiken@nokia.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "testgtkmozembed.h"
#include "CppUnitSignalException.h"
#include "gtkmozembed_internal.h"
#include "gtkmozembed_internal2.h"
#include "gtkmozembedprivate.h"
#include "stdlib.h"

const char* PATH = "../gtk/src/.libs";
const char* URI = "http://www.google.fi";
const char* URI2 = "http://www.google.com";

CPPUNIT_TEST_SUITE_REGISTRATION( TestGtkMozEmbed );

void
TestGtkMozEmbed::setUp()
{
	path = PATH;
	uri = URI;
	gtk_init(NULL, NULL);
}



void
TestGtkMozEmbed::testConstructor()
{
	GtkWidget* widget;
	widget = gtk_moz_embed_new();
	CPPUNIT_ASSERT(widget != NULL);
	CPPUNIT_ASSERT(GTK_IS_MOZ_EMBED(widget));
}

void
TestGtkMozEmbed::testDestructor()
{
	GtkWidget* widget;
	widget = gtk_moz_embed_new();
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(gtk_widget_destroy(widget));
}

/*
 * private initilize GtkMozEmbed class
 */
void
TestGtkMozEmbed::initGtkMozEmbed()
{
	mWidget = gtk_moz_embed_new();
	mEmbed = GTK_MOZ_EMBED(mWidget);
	gtk_moz_embed_set_comp_path(path);
	GtkWidget *window;
	window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_container_add(GTK_CONTAINER(window), mWidget);
	gtk_widget_show(mWidget);
	gtk_widget_show(window);
}

void
TestGtkMozEmbed::testPushStartup()
{
	initGtkMozEmbed();
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(gtk_moz_embed_push_startup());
}

void
TestGtkMozEmbed::testPopStartup()
{
	initGtkMozEmbed();
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(gtk_moz_embed_pop_startup());
}

void
TestGtkMozEmbed::testSetPathWithNULL()
{
	initGtkMozEmbed();
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(gtk_moz_embed_set_path(NULL));
}

void
TestGtkMozEmbed::testSetPath()
{
	initGtkMozEmbed();
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(gtk_moz_embed_set_path(path));
}

void
TestGtkMozEmbed::testSetCompPathWithNULL()
{
	initGtkMozEmbed();
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(gtk_moz_embed_set_comp_path(NULL));
}

void
TestGtkMozEmbed::testSetCompPath()
{
	initGtkMozEmbed();
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(gtk_moz_embed_set_comp_path(path));
}

void
TestGtkMozEmbed::testSetProfilePathWithNULL()
{
	initGtkMozEmbed();
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(gtk_moz_embed_set_profile_path(NULL, NULL));
}

void
TestGtkMozEmbed::testSetProfilePath()
{
	initGtkMozEmbed();
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(gtk_moz_embed_set_profile_path(path, path));
}

void
TestGtkMozEmbed::testLoadUrlWithNULL()
{
	initGtkMozEmbed();
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(gtk_moz_embed_load_url(NULL, NULL));
}

void
TestGtkMozEmbed::testLoadUrl1()
{
	initGtkMozEmbed();
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(gtk_moz_embed_load_url(mEmbed, uri));
}

void
TestGtkMozEmbed::testLoadUrl2()
{
	initGtkMozEmbed();
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(gtk_moz_embed_load_url(mEmbed, NULL));
}


void
TestGtkMozEmbed::testStopLoadWithNULL()
{
	initGtkMozEmbed();
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(gtk_moz_embed_stop_load(NULL));
}

void
TestGtkMozEmbed::testStopLoad()
{
	initGtkMozEmbed();
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(gtk_moz_embed_load_url(mEmbed, uri));
	system("sleep 1");
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(gtk_moz_embed_stop_load(mEmbed));
}

void
TestGtkMozEmbed::testCanGoBackWithNULL()
{
	initGtkMozEmbed();
	gboolean retvalue;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = gtk_moz_embed_can_go_back(NULL));
	CPPUNIT_ASSERT(!retvalue);
}

void
TestGtkMozEmbed::testCanGoBack()
{
	initGtkMozEmbed();
	gboolean retvalue;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = gtk_moz_embed_can_go_back(mEmbed));
	CPPUNIT_ASSERT(!retvalue); //at first it can't go back
}


void
TestGtkMozEmbed::testBackwardForward()
{
	initGtkMozEmbed();
	gboolean retvalue;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = gtk_moz_embed_can_go_back(mEmbed));
	CPPUNIT_ASSERT(!retvalue); //at first it can't go back
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(gtk_moz_embed_load_url(mEmbed, uri));
	system("sleep 2");
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(gtk_moz_embed_load_url(mEmbed, URI2));
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = gtk_moz_embed_can_go_back(mEmbed));
	CPPUNIT_ASSERT(retvalue);  //after load 2 url, it should can go back
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(gtk_moz_embed_go_back(mEmbed));
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = gtk_moz_embed_can_go_back(mEmbed));
	CPPUNIT_ASSERT(!retvalue); //after go back, it should can't go back anymore
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = gtk_moz_embed_can_go_forward(mEmbed));
	CPPUNIT_ASSERT(retvalue);  //but can go forward
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(gtk_moz_embed_go_forward(mEmbed));
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = gtk_moz_embed_can_go_forward(mEmbed));
	CPPUNIT_ASSERT(retvalue);  //after go forward, it should can't go forward anymore
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = gtk_moz_embed_can_go_back(mEmbed));
	CPPUNIT_ASSERT(retvalue);  //but it should can go back
}

void
TestGtkMozEmbed::testCanGoForwardWithNULL()
{
	gboolean retvalue ;
	initGtkMozEmbed();
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = gtk_moz_embed_can_go_forward(NULL));
	CPPUNIT_ASSERT(!retvalue);
}

void
TestGtkMozEmbed::testCanGoForward()
{
	gboolean retvalue ;
	initGtkMozEmbed();
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = gtk_moz_embed_can_go_forward(mEmbed));
	CPPUNIT_ASSERT(!retvalue);
}

void
TestGtkMozEmbed::testGoBackWithNULL()
{
	initGtkMozEmbed();
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(gtk_moz_embed_go_back(NULL));
}

void
TestGtkMozEmbed::testGoBack()
{
	initGtkMozEmbed();
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(gtk_moz_embed_go_back(mEmbed));
}

void
TestGtkMozEmbed::testGoForwardWithNULL()
{
	initGtkMozEmbed();
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(gtk_moz_embed_go_forward(NULL));
}

void
TestGtkMozEmbed::testGoForward()
{
	initGtkMozEmbed();
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(gtk_moz_embed_go_forward(mEmbed));
}

void
TestGtkMozEmbed::testRenderDataWithNULL()
{
	initGtkMozEmbed();
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(gtk_moz_embed_render_data(NULL, NULL, 0, NULL, NULL));
}

void
TestGtkMozEmbed::testRenderData()
{
	initGtkMozEmbed();
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(gtk_moz_embed_render_data(mEmbed, NULL, 0, NULL, NULL));
}

void
TestGtkMozEmbed::testOpenStreamWithNULL()
{
	initGtkMozEmbed();
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(gtk_moz_embed_open_stream(NULL, NULL, NULL));
}

void
TestGtkMozEmbed::testOpenStream1()
{
	initGtkMozEmbed();
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(gtk_moz_embed_open_stream(mEmbed, uri, NULL));
}

void
TestGtkMozEmbed::testOpenStream2()
{
	initGtkMozEmbed();
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(gtk_moz_embed_open_stream(mEmbed, NULL, NULL));
}


void
TestGtkMozEmbed::testAppendDataWithNULL()
{
	initGtkMozEmbed();
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(gtk_moz_embed_append_data(NULL, NULL, 0));
}

void
TestGtkMozEmbed::testAppendData1()
{
	initGtkMozEmbed();
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(gtk_moz_embed_append_data(mEmbed, NULL, 0));
}

void
TestGtkMozEmbed::testAppendData2()
{
	initGtkMozEmbed();
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(gtk_moz_embed_append_data(mEmbed, uri, 0));
}


void
TestGtkMozEmbed::testCloseStreamWithNULL()
{
	initGtkMozEmbed();
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(gtk_moz_embed_close_stream(NULL));
}

void
TestGtkMozEmbed::testCloseStream()
{
	initGtkMozEmbed();
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(gtk_moz_embed_close_stream(mEmbed));
}

void
TestGtkMozEmbed::testGetLinkMessageWithNULL()
{
	initGtkMozEmbed();
	char* retvalue;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = gtk_moz_embed_get_link_message(NULL));
	CPPUNIT_ASSERT(retvalue == NULL);
}

void
TestGtkMozEmbed::testGetLinkMessage()
{
	initGtkMozEmbed();
	char* retvalue;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = gtk_moz_embed_get_link_message(mEmbed));
	CPPUNIT_ASSERT(retvalue != NULL);
}

void
TestGtkMozEmbed::testGetJsStatusWithNULL()
{
	initGtkMozEmbed();
	char* retvalue;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = gtk_moz_embed_get_js_status(NULL));
	CPPUNIT_ASSERT(retvalue == NULL);
}

void
TestGtkMozEmbed::testGetJsStatus()
{
	initGtkMozEmbed();
	char* retvalue;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = gtk_moz_embed_get_js_status(mEmbed));
	CPPUNIT_ASSERT(retvalue != NULL);
}

void
TestGtkMozEmbed::testGetTitleWithNULL()
{
	initGtkMozEmbed();
	char* retvalue;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = gtk_moz_embed_get_title(NULL));
	CPPUNIT_ASSERT(retvalue == NULL);
}

void
TestGtkMozEmbed::testGetTitle()
{
	initGtkMozEmbed();
	char* retvalue;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = gtk_moz_embed_get_title(mEmbed));
	CPPUNIT_ASSERT(retvalue != NULL);
}

void
TestGtkMozEmbed::testGetLocationWithNULL()
{
	initGtkMozEmbed();
	char* retvalue;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = gtk_moz_embed_get_location(NULL));
	CPPUNIT_ASSERT(retvalue == NULL);
}

void
TestGtkMozEmbed::testGetLocation1()
{
	initGtkMozEmbed();
	char* retvalue;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = gtk_moz_embed_get_location(mEmbed));
	CPPUNIT_ASSERT(retvalue == NULL);
}


void
TestGtkMozEmbed::testGetLocation2()
{
	initGtkMozEmbed();
	char* retvalue;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(gtk_moz_embed_load_url(mEmbed, uri));
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = gtk_moz_embed_get_location(mEmbed));
	CPPUNIT_ASSERT(retvalue != NULL);
}


void
TestGtkMozEmbed::testReloadWithNULL()
{
	initGtkMozEmbed();
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(gtk_moz_embed_reload(NULL, 0));
}

void
TestGtkMozEmbed::testReload()
{
	initGtkMozEmbed();
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(gtk_moz_embed_reload(mEmbed, 0));
}


void
TestGtkMozEmbed::testSetChromeMaskWithNULL()
{
	initGtkMozEmbed();
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(gtk_moz_embed_set_chrome_mask(NULL, 0));
}

void
TestGtkMozEmbed::testSetChromeMask()
{
	initGtkMozEmbed();
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(gtk_moz_embed_set_chrome_mask(mEmbed, 0));
}

void
TestGtkMozEmbed::testGetChromeMaskWithNULL()
{
	initGtkMozEmbed();
	int retvalue;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = gtk_moz_embed_get_chrome_mask(NULL));
	CPPUNIT_ASSERT(retvalue == 0);
}

void
TestGtkMozEmbed::testGetChromeMask()
{
	initGtkMozEmbed();
	int retvalue;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = gtk_moz_embed_get_chrome_mask(mEmbed));
	CPPUNIT_ASSERT(retvalue != 0);
}

//#include "gtkmozembed_internal.h"
//#include "gtkmozembed_internal2.h"

void
TestGtkMozEmbed::test_get_nsIWebBrowser1()
{
	initGtkMozEmbed();
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(gtk_moz_embed_get_nsIWebBrowser(NULL, NULL));
}

void
TestGtkMozEmbed::test_get_nsIWebBrowser2()
{
	nsIWebBrowser* retval = NULL;
	initGtkMozEmbed();
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(gtk_moz_embed_get_nsIWebBrowser(mEmbed, &retval));
}

void
TestGtkMozEmbed::test_get_nsIWebBrowser3()
{
	nsIWebBrowser** retval = NULL;
	initGtkMozEmbed();
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(gtk_moz_embed_get_nsIWebBrowser(mEmbed, retval));
}


void
TestGtkMozEmbed::test_get_title_unichar1()
{
	initGtkMozEmbed();
	PRUnichar* retvalue;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = gtk_moz_embed_get_title_unichar(NULL));
	CPPUNIT_ASSERT(retvalue == NULL);
}

void
TestGtkMozEmbed::test_get_title_unichar2()
{
	initGtkMozEmbed();
	PRUnichar* retvalue;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = gtk_moz_embed_get_title_unichar(mEmbed));
	CPPUNIT_ASSERT(retvalue != NULL);
}

void
TestGtkMozEmbed::test_get_js_status_unichar1()
{
	initGtkMozEmbed();
	PRUnichar* retvalue;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = gtk_moz_embed_get_js_status_unichar(NULL));
	CPPUNIT_ASSERT(retvalue == NULL);
}

void
TestGtkMozEmbed::test_get_js_status_unichar2()
{
	initGtkMozEmbed();
	PRUnichar* retvalue;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = gtk_moz_embed_get_js_status_unichar(mEmbed));
	CPPUNIT_ASSERT(retvalue != NULL);
}

void
TestGtkMozEmbed::test_get_link_message_unichar1()
{
	initGtkMozEmbed();
	PRUnichar* retvalue;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = gtk_moz_embed_get_link_message_unichar(NULL));
	CPPUNIT_ASSERT(retvalue == NULL);
}

void
TestGtkMozEmbed::test_get_link_message_unichar2()
{
	initGtkMozEmbed();
	PRUnichar* retvalue;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = gtk_moz_embed_get_link_message_unichar(mEmbed));
	CPPUNIT_ASSERT(retvalue != NULL);
}

void
TestGtkMozEmbed::test_set_directory_service_provider()
{
	initGtkMozEmbed();
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(gtk_moz_embed_set_directory_service_provider(NULL));
}

void
TestGtkMozEmbed::test_set_app_components()
{
	initGtkMozEmbed();
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(gtk_moz_embed_set_app_components(NULL, 0));
}

void
TestGtkMozEmbed::test_set_static_components()
{
	initGtkMozEmbed();
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(gtk_moz_embed_set_static_components(NULL, 0));
}


//#include "gtkmozembedprivate.h"


void
TestGtkMozEmbed::test_single_create_window()
{
	initGtkMozEmbed();
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(gtk_moz_embed_single_create_window(&mEmbed, 0));
}


/*

void
TestGtkMozEmbed::testGetZoomLevelWithNULL()
{
	initGtkMozEmbed();
	gboolean retvalue = gtk_moz_embed_get_zoom_level(NULL, NULL, NULL);
	CPPUNIT_ASSERT(!retvalue);
}

void
TestGtkMozEmbed::testSetZoomLevelWithNULL()
{
	initGtkMozEmbed();
	gboolean retvalue = gtk_moz_embed_set_zoom_level(NULL, 0, NULL);
	CPPUNIT_ASSERT(!retvalue);
}

void
TestGtkMozEmbed::testFindTextWithNULL()
{
	initGtkMozEmbed();
	gboolean retvalue = gtk_moz_embed_find_text(NULL, NULL, false, false, false, false, 0);
	CPPUNIT_ASSERT(!retvalue);
}

void
TestGtkMozEmbed::testNotifyPluginsWithNULL()
{
	initGtkMozEmbed();
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(gtk_moz_embed_notify_plugins(NULL, 0));
}

void
TestGtkMozEmbed::testCheckLoginsWithNULL()
{
	initGtkMozEmbed();
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(gtk_moz_embed_check_logins(NULL));
}

void
TestGtkMozEmbed::testLoadImageWithNULL()
{
	initGtkMozEmbed();
	gboolean retvalue = gtk_moz_embed_load_image(NULL, NULL);
	CPPUNIT_ASSERT(!retvalue);
}

void
TestGtkMozEmbed::testGetDocInfoWithNULL()
{
	initGtkMozEmbed();
	gboolean retvalue = gtk_moz_embed_get_doc_info(NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL);
	CPPUNIT_ASSERT(!retvalue);
}

*/


