/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 tw=80 et cindent: */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is mozilla.org code.
 *
 * The Initial Developer of the Original Code is
 * Christopher Blizzard.
 *
 * Portions created by the Initial Developer are Copyright (C) 2001
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Christopher Blizzard <blizzard@mozilla.org>
 *   Ramiro Estrugo <ramiro@eazel.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include <stdio.h>
#include "gtkmozembed.h"
#include "gtkmozembed_common.h"
#include "gtkmozembedprivate.h"
#include "gtkmozembed_internal.h"
#include "EmbedPrivate.h"
#include "EmbedWindow.h"

#include "nsIObserver.h"

// so we can do our get_nsIWebBrowser later...
#include "nsIWebBrowser.h"
#include "nsIComponentManager.h"
#include "nsIServiceManager.h"
#include "nsIPref.h"
#include "nsICookieManager.h"
#include "nsIPermissionManager.h"
#include "nsNetCID.h"
#include "nsICookie.h"
#include "nsIX509Cert.h"
// for strings
#ifdef MOZILLA_INTERNAL_API
#include "nsXPIDLString.h"
#include "nsReadableUtils.h"
#include "nsString.h"
#else
#include "nsStringAPI.h"
#include "nsComponentManagerUtils.h"
#include "nsServiceManagerUtils.h"
#endif
// for plugins
#include "nsIDOMNavigator.h"
#include "nsIDOMPluginArray.h"
#include "nsIDOMPlugin.h"
#include "nsIPluginHost.h"
#include "nsIDOMMimeType.h"
#include "nsIObserverService.h"

#ifdef MOZ_RDF
#include "nsIRDFDataSource.h"
#include "nsIRDFService.h"
#include "nsIExtensionManager.h"
#endif

//for security
#include "nsIWebProgressListener.h"

//for cache
#include "nsICacheService.h"
#include "nsICache.h"
#include "EmbedGtkTools.h"

// for image loading
#include "nsIDOMDocument.h"
#include "nsIDOMNodeList.h"
#include "nsIImageLoadingContent.h"
#include "nsIDOMHTMLIFrameElement.h"
#include "nsIDOMHTMLFrameElement.h"
#include "nsIDOMHTMLDocument.h"
#include "nsIDOMHTMLCollection.h"
#include "nsIHttpAuthManager.h"
#include "nsIPluginDocument.h"
static NS_DEFINE_CID(kHttpAuthManagerCID,        NS_HTTPAUTHMANAGER_CID);

#include "gtkmozembedmarshal.h"
#define NEW_TOOLKIT_STRING(x) g_strdup(NS_ConvertUTF16toUTF8(x).get())
#define GET_TOOLKIT_STRING(x) NS_ConvertUTF16toUTF8(x).get()
#define GET_OBJECT_CLASS_TYPE(x) G_OBJECT_CLASS_TYPE(x)

#define EM_RDF_EXT_DES "http://www.mozilla.org/2004/em-rdf#description"
#define EM_RDF_EXT_CREATOR "http://www.mozilla.org/2004/em-rdf#creator"
#define EM_RDF_EXT_STATE "http://www.mozilla.org/2004/em-rdf#userDisabled"
#define EM_RDF_EXT_APP_DISABLED "http://www.mozilla.org/2004/em-rdf#appDisabled"

#define UNACCEPTABLE_CRASHY_GLIB_ALLOCATION(newed) PR_BEGIN_MACRO \
  /* OOPS this code is using a glib allocation function which     \
   * will cause the application to crash when it runs out of      \
   * memory. This is not cool. either g_try methods should be     \
   * used or malloc, or new (note that gecko /will/ be replacing  \
   * its operator new such that new will not throw exceptions).   \
   * XXX please fix me.                                           \
   */                                                             \
  if (!newed) {                                                   \
  }                                                               \
  PR_END_MACRO

#define ALLOC_NOT_CHECKED(newed) PR_BEGIN_MACRO \
  /* This might not crash, but the code probably isn't really \
   * designed to handle it, perhaps the code should be fixed? \
   */                                                         \
  if (!newed) {                                               \
  }                                                           \
  PR_END_MACRO

// class and instance initialization

static void
gtk_moz_embed_common_class_init(GtkMozEmbedCommonClass *klass);

static void
gtk_moz_embed_common_init(GtkMozEmbedCommon *embed);

static GtkObjectClass *common_parent_class = NULL;

// GtkObject methods

static void
gtk_moz_embed_common_destroy(GtkObject *object);

guint moz_embed_common_signals[COMMON_LAST_SIGNAL] = { 0 };

// GtkObject + class-related functions
GtkType
gtk_moz_embed_common_get_type(void)
{
  static GtkType moz_embed_common_type = 0;
  if (!moz_embed_common_type)
  {
    static const GtkTypeInfo moz_embed_common_info =
    {
      "GtkMozEmbedCommon",
      sizeof(GtkMozEmbedCommon),
      sizeof(GtkMozEmbedCommonClass),
      (GtkClassInitFunc)gtk_moz_embed_common_class_init,
      (GtkObjectInitFunc)gtk_moz_embed_common_init,
      0,
      0,
      0
    };
    moz_embed_common_type = gtk_type_unique(GTK_TYPE_BIN, &moz_embed_common_info);
  }
  return moz_embed_common_type;
}

static void
gtk_moz_embed_common_class_init(GtkMozEmbedCommonClass *klass)
{
  GtkObjectClass     *object_class;
  object_class    = GTK_OBJECT_CLASS(klass);
  common_parent_class = (GtkObjectClass *)gtk_type_class(gtk_object_get_type());
  object_class->destroy = gtk_moz_embed_common_destroy;
  moz_embed_common_signals[COMMON_CERT_ERROR] =
    gtk_signal_new("certificate-error",
                   GTK_RUN_LAST,
                   GET_OBJECT_CLASS_TYPE(klass),
                   GTK_SIGNAL_OFFSET(GtkMozEmbedCommonClass,
                                     certificate_error),
                   gtkmozembed_BOOL__POINTER_UINT,
                   G_TYPE_BOOLEAN,
                   2,
                   GTK_TYPE_POINTER,
                   GTK_TYPE_UINT);
  moz_embed_common_signals[COMMON_SELECT_LOGIN] =
    gtk_signal_new("select-login",
                   GTK_RUN_LAST,
                   GET_OBJECT_CLASS_TYPE(klass),
                   GTK_SIGNAL_OFFSET(GtkMozEmbedCommonClass, select_login),
                   gtkmozembed_INT__POINTER_POINTER,
                   G_TYPE_INT,
                   2,
                   G_TYPE_POINTER, G_TYPE_POINTER);
  // set up our signals
  moz_embed_common_signals[COMMON_ASK_COOKIE] =
    gtk_signal_new("ask-cookie",
                   GTK_RUN_FIRST,
                   GET_OBJECT_CLASS_TYPE(klass),
                   GTK_SIGNAL_OFFSET(GtkMozEmbedCommonClass, ask_cookie),
                   gtkmozembed_VOID__POINTER_INT_STRING_STRING_STRING_STRING_STRING_BOOLEAN_INT,
                   G_TYPE_NONE, 9,
                   GTK_TYPE_POINTER,
                   GTK_TYPE_INT,
                   GTK_TYPE_STRING | G_SIGNAL_TYPE_STATIC_SCOPE,
                   GTK_TYPE_STRING | G_SIGNAL_TYPE_STATIC_SCOPE,
                   GTK_TYPE_STRING | G_SIGNAL_TYPE_STATIC_SCOPE,
                   GTK_TYPE_STRING | G_SIGNAL_TYPE_STATIC_SCOPE,
                   GTK_TYPE_STRING | G_SIGNAL_TYPE_STATIC_SCOPE,
                   GTK_TYPE_BOOL,
                   GTK_TYPE_INT);

  moz_embed_common_signals[COMMON_SERVICE_NOTIFY] =
    gtk_signal_new("on-service-notify",
                   GTK_RUN_LAST,
                   GET_OBJECT_CLASS_TYPE(klass),
                   GTK_SIGNAL_OFFSET(GtkMozEmbedCommonClass, on_service_notify),
                   gtkmozembed_INT__POINTER_STRING_STRING,
                   G_TYPE_INT, 3,
                   GTK_TYPE_POINTER,
                   GTK_TYPE_STRING,
                   GTK_TYPE_STRING);

/*
  moz_embed_common_signals[COMMON_CERT_DIALOG] =
    gtk_signal_new("certificate-dialog",
                   GTK_RUN_LAST,
                   GET_OBJECT_CLASS_TYPE(klass),
                   GTK_SIGNAL_OFFSET(GtkMozEmbedCommonClass,
                                     certificate_dialog),
                   gtk_marshal_BOOL__POINTER,
                   G_TYPE_BOOLEAN, 1, GTK_TYPE_POINTER);
  moz_embed_common_signals[COMMON_CERT_PASSWD_DIALOG] =
    gtk_signal_new("certificate-password-dialog",
                   GTK_RUN_FIRST,
                   GET_OBJECT_CLASS_TYPE(klass),
                   GTK_SIGNAL_OFFSET(GtkMozEmbedCommonClass,
                                     certificate_password_dialog),
                   gtkmozembed_VOID__STRING_STRING_POINTER,
                   G_TYPE_NONE,
                   3,
                   GTK_TYPE_STRING | G_SIGNAL_TYPE_STATIC_SCOPE,
                   GTK_TYPE_STRING | G_SIGNAL_TYPE_STATIC_SCOPE,
                   GTK_TYPE_POINTER);
  moz_embed_common_signals[COMMON_CERT_DETAILS_DIALOG] =
    gtk_signal_new("certificate-details",
                   GTK_RUN_FIRST,
                   GET_OBJECT_CLASS_TYPE(klass),
                   GTK_SIGNAL_OFFSET(GtkMozEmbedCommonClass,
                                     certificate_details),
                   gtk_marshal_VOID__POINTER,
                   G_TYPE_NONE,
                   1,
                   GTK_TYPE_POINTER);
  moz_embed_common_signals[COMMON_HISTORY_ADDED] =
    gtk_signal_new("global-history-item-added",
                   GTK_RUN_FIRST,
                   GET_OBJECT_CLASS_TYPE(klass),
                   GTK_SIGNAL_OFFSET(GtkMozEmbedCommonClass,
                                     history_added),
                   gtk_marshal_VOID__STRING,
                   G_TYPE_NONE,
                   1,
                   GTK_TYPE_STRING | G_SIGNAL_TYPE_STATIC_SCOPE);
  moz_embed_common_signals[COMMON_ON_SUBMIT_SIGNAL] =
    gtk_signal_new("on-submit",
                   GTK_RUN_LAST,
                   GET_OBJECT_CLASS_TYPE(klass),
                   GTK_SIGNAL_OFFSET(GtkMozEmbedCommonClass,
                                     on_submit),
                   gtkmozembed_INT__VOID,
                   G_TYPE_INT, 0);
  moz_embed_common_signals[COMMON_MODAL_DIALOG] =
    gtk_signal_new("modal_dialog",
                   GTK_RUN_LAST,
                   GET_OBJECT_CLASS_TYPE(klass),
                   GTK_SIGNAL_OFFSET(GtkMozEmbedCommonClass,
                      modal_dialog),
                   gtkmozembed_INT__STRING_STRING_INT_INT_INT_INT,
                   G_TYPE_INT,
                   6,
                   G_TYPE_STRING, G_TYPE_STRING,
                   G_TYPE_INT, G_TYPE_INT,
                   G_TYPE_INT, G_TYPE_INT);
  */
}

static void
gtk_moz_embed_common_init(GtkMozEmbedCommon *common)
{
  // this is a placeholder for later in case we need to stash data at
  // a later data and maintain backwards compatibility.
  common->data = nsnull;
  EmbedCommon *priv = EmbedCommon::GetInstance();
  priv->mCommon = GTK_OBJECT(common);
  common->data = priv;
}

static void
gtk_moz_embed_common_destroy(GtkObject *object)
{
  EmbedCommon::DeleteInstance();
}

GtkWidget *
gtk_moz_embed_common_new(void)
{
  GtkWidget *widget = (GtkWidget*) gtk_type_new(gtk_moz_embed_common_get_type());
  gtk_widget_set_name(widget, "gtkmozembedcommon");
  return (GtkWidget *) widget;
}

gboolean
gtk_moz_embed_common_set_pref(GtkType type, gchar *name, gpointer value)
{
  g_return_val_if_fail (name != NULL, FALSE);

  nsCOMPtr<nsIPref> pref = do_GetService(NS_PREF_CONTRACTID);

  if (pref) {
    nsresult rv = NS_ERROR_FAILURE;
    switch (type) {
    case GTK_TYPE_BOOL:
      {
        /* I doubt this cast pair is correct */
        rv = pref->SetBoolPref(name, !!*(int*)value);
        break;
      }
    case GTK_TYPE_INT:
      {
        /* I doubt this cast pair is correct */
        rv = pref->SetIntPref(name, *(int*)value);
        break;
      }
    case GTK_TYPE_STRING:
      {
        g_return_val_if_fail (value, FALSE);
        rv = pref->SetCharPref(name, (gchar*)value);
        break;
      }
    default:
      break;
    }
    return NS_SUCCEEDED(rv);
  }
  return FALSE;
}

gboolean
gtk_moz_embed_common_get_pref(GtkType type, gchar *name, gpointer value)
{
  g_return_val_if_fail (name != NULL, FALSE);

  nsCOMPtr<nsIPref> pref = do_GetService(NS_PREF_CONTRACTID);

  nsresult rv = NS_ERROR_FAILURE;
  if (pref){
    switch (type) {
    case GTK_TYPE_BOOL:
      {
        rv = pref->GetBoolPref(name, (gboolean*)value);
        break;
      }
    case GTK_TYPE_INT:
      {
        rv = pref->GetIntPref(name, (gint*)value);
        break;
      }
    case GTK_TYPE_STRING:
      {
        rv = pref->GetCharPref(name, (gchar**)value);
        break;
      }
    default:
      break;
    }
    return NS_SUCCEEDED(rv);
  }
  return FALSE;
}

gboolean
gtk_moz_embed_common_save_prefs()
{
  nsCOMPtr<nsIPrefService> prefService = do_GetService(NS_PREF_CONTRACTID);
  g_return_val_if_fail (prefService != nsnull, FALSE);
  if (prefService == nsnull)
    return FALSE;
  nsresult rv = prefService->SavePrefFile (nsnull);
  return NS_SUCCEEDED(rv);
}

gint
gtk_moz_embed_common_get_logins(const char* uri, GList **list)
{
  gint ret = 0;
  // Implementation moved to microb-eal
  return ret;
}

gboolean
gtk_moz_embed_common_remove_passwords(const gchar *host, const gchar *user, gint index)
{
  // Implementation moved to microb-eal
  return TRUE;
}

gint
gtk_moz_embed_common_get_history_list(GtkMozHistoryItem **GtkHI)
{
  // Implementation moved to microb-eal
  return 0;
}

gint
gtk_moz_embed_common_remove_history(gchar *url, gint time) 
{
  // Implementation moved to microb-eal
  return 0;
}

GSList*
gtk_moz_embed_common_get_cookie_list(void)
{
  GSList *cookies = NULL;
  nsresult result;
  nsCOMPtr<nsICookieManager> cookieManager =
    do_GetService(NS_COOKIEMANAGER_CONTRACTID);
  nsCOMPtr<nsISimpleEnumerator> cookieEnumerator;
  result = cookieManager->GetEnumerator(getter_AddRefs(cookieEnumerator));
  g_return_val_if_fail(NS_SUCCEEDED(result), NULL);
  PRBool enumResult;
  for (cookieEnumerator->HasMoreElements(&enumResult);
       enumResult == PR_TRUE;
       cookieEnumerator->HasMoreElements(&enumResult))
  {
    GtkMozCookieList *c;
    nsCOMPtr<nsICookie> nsCookie;
    result = cookieEnumerator->GetNext(getter_AddRefs(nsCookie));
    g_return_val_if_fail(NS_SUCCEEDED(result), NULL);
    c = g_new0(GtkMozCookieList, 1);
    UNACCEPTABLE_CRASHY_GLIB_ALLOCATION(c);
    nsCAutoString transfer;
    nsCookie->GetHost(transfer);
    c->domain = g_strdup(transfer.get());
    nsCookie->GetName(transfer);
    c->name = g_strdup(transfer.get());
    nsCookie->GetValue(transfer);
    c->value = g_strdup(transfer.get());
    nsCookie->GetPath(transfer);
    if (strchr(c->domain,'.'))
      c->path = g_strconcat("http://*",c->domain,"/",NULL);
    else
      c->path = g_strconcat("http://",c->domain,"/",NULL);
    cookies = g_slist_prepend(cookies, c);
  }
  cookies = g_slist_reverse(cookies);
  return cookies;
}

gboolean
gtk_moz_embed_common_delete_all_cookies(GSList *deletedCookies)
{
  nsCOMPtr<nsIPermissionManager> permissionManager =
    do_GetService(NS_PERMISSIONMANAGER_CONTRACTID);

  if (deletedCookies)
  {
    for (GSList* l = deletedCookies; l; l = g_slist_next(l)) {
      GtkMozCookieList *c = (GtkMozCookieList*) l->data;
      if (c) {
         g_free(c->domain);
         g_free(c->name);
         g_free(c->value);
         g_free(c->path);
         g_free(c);
      }
    }

    g_slist_free(deletedCookies);
  }

  g_return_val_if_fail(permissionManager, FALSE);
  permissionManager->RemoveAll();

  nsCOMPtr<nsICookieManager> cookieManager =
    do_GetService(NS_COOKIEMANAGER_CONTRACTID);

  g_return_val_if_fail(cookieManager, FALSE);
  cookieManager->RemoveAll();

  return TRUE;
}

unsigned char *
gtk_moz_embed_common_nsx509_to_raw(void *nsIX509Ptr, guint *len)
{
  if (!nsIX509Ptr)
    return NULL;
  unsigned char *data;
  ((nsIX509Cert*)nsIX509Ptr)->GetRawDER(len, (PRUint8 **)&data);
  if (!data)
    return NULL;
  return data;
}

#ifdef MOZ_RDF
static PRBool
gtk_moz_embed_common_get_node_value(nsIRDFDataSource *eDataSource,
                                    nsIRDFResource *itemResource,
                                    nsIRDFService *rdfService,
                                    gchar* nodeType, PRUnichar **retval)
{
  nsCOMPtr<nsIRDFResource> nodeRDFResource;
  rdfService->GetResource(NS_LITERAL_CSTRING(nodeType), getter_AddRefs(nodeRDFResource));
  if (!nodeRDFResource)
    return PR_FALSE;

  nsCOMPtr<nsIRDFNode> itemNode;
  eDataSource->GetTarget(itemResource, nodeRDFResource, PR_TRUE, getter_AddRefs(itemNode));
  if (!itemNode)
    return PR_FALSE;

  nsCOMPtr<nsIRDFLiteral> itemNodeLiteral = do_QueryInterface(itemNode);
  if (!itemNodeLiteral)
    return PR_FALSE;

  PRUnichar *itemType = nsnull;
  itemNodeLiteral->GetValue(&itemType);
  *retval= itemType;

  return PR_TRUE;
}
#endif

gboolean restart_notify(void *data)
{
  gint retval = 0;
  EmbedCommon *common = EmbedCommon::GetInstance();
  if (common)
    g_signal_emit_by_name (G_OBJECT (common->mCommon), "on-service-notify", common->mCommon, "components", "restart_required", &retval);
  return FALSE;
}

gboolean
gtk_moz_embed_common_set_extension_status(gchar *extensionID, gboolean status)
{
#ifdef MOZ_RDF
  g_return_val_if_fail (extensionID != NULL, FALSE);

  nsCOMPtr<nsIExtensionManager> eManager(do_GetService("@mozilla.org/extensions/manager;1"));
  if (!eManager)
    return FALSE;

  nsAutoString id;
  id.Append(NS_ConvertUTF8toUTF16(extensionID));

  if (status)
    eManager->EnableItem(id);
  else
    eManager->DisableItem(id);
  PRBool aNeedsRestart = PR_FALSE;
  eManager->Start(&aNeedsRestart);
  if (aNeedsRestart)
    g_idle_add(restart_notify, NULL);
#endif

  return TRUE;
}

static PRBool
gtk_moz_embed_common_get_component_list(PRUint32 *length, GList **pluginArray)
{
  PRUint32 count = 0;

#ifdef MOZ_RDF
  nsIUpdateItem **extensions = nsnull;

  nsCOMPtr<nsIExtensionManager> eManager(do_GetService("@mozilla.org/extensions/manager;1"));
  if (!eManager)
    return PR_FALSE;

  nsCOMPtr<nsIRDFService> rdfService;
  rdfService = do_GetService("@mozilla.org/rdf/rdf-service;1");
  if (!rdfService)
    return PR_FALSE;

  nsCOMPtr<nsIRDFDataSource> eDataSource;
  eManager->GetDatasource(getter_AddRefs(eDataSource));
  if (!eDataSource)
    return PR_FALSE;

  eManager->GetItemList(nsIUpdateItem::TYPE_EXTENSION, &count,
                                &extensions);

  for (PRUint32 i = 0; i < count; i++) {
    nsIUpdateItem *extension = extensions[i];
    if (extension) {
      GtkMozPlugin *list_item = g_new0(GtkMozPlugin, 1);
      nsAutoString itemName;
      extension->GetName(itemName);
      if (itemName.IsEmpty()) {
        g_free(list_item);
        continue;
      }

      nsAutoString itemId;
      extension->GetId(itemId);
      if (itemId.IsEmpty()) {
        g_free(list_item);
        continue;
      }

      nsCString resourceID("urn:mozilla:item:");
      resourceID.Append(NS_ConvertUTF16toUTF8(itemId));
      nsCOMPtr<nsIRDFResource> itemResource;
      rdfService->GetResource(resourceID, getter_AddRefs(itemResource));
      if (!itemResource) {
        g_free(list_item);
        continue;
      }

      PRUnichar *extAppDisabled = nsnull;
      gtk_moz_embed_common_get_node_value(eDataSource, itemResource, rdfService,
          EM_RDF_EXT_APP_DISABLED, &extAppDisabled);
      if ((extAppDisabled) && (nsDependentString(extAppDisabled).Equals(NS_LITERAL_STRING("true")))) {
        g_free(list_item);
        continue;
      }

      list_item->title = g_strdup((gchar *)NS_ConvertUTF16toUTF8(itemName).get());
      list_item->path =  g_strdup((gchar *)NS_ConvertUTF16toUTF8(itemId).get());

      PRUnichar *itemCreator = nsnull;
      gtk_moz_embed_common_get_node_value(eDataSource, itemResource, rdfService,
          EM_RDF_EXT_CREATOR, &itemCreator);
      if (itemCreator)
        list_item->creator = g_strdup(NS_ConvertUTF16toUTF8(itemCreator).get());

      PRUnichar *itemDescrption = nsnull;
      gtk_moz_embed_common_get_node_value(eDataSource, itemResource, rdfService,
          EM_RDF_EXT_DES, &itemDescrption);
      if(itemDescrption)
        list_item->type = g_strdup(NS_ConvertUTF16toUTF8(itemDescrption).get());

      PRUnichar *itemState = nsnull;
      gtk_moz_embed_common_get_node_value(eDataSource, itemResource, rdfService,
          EM_RDF_EXT_STATE, &itemState);
      if ((itemState) && (nsDependentString(itemState).Equals(NS_LITERAL_STRING("true"))))
        list_item->isDisabled = TRUE;
      else
        list_item->isDisabled = FALSE;

      list_item->isPlugin = FALSE;
      *pluginArray = g_list_append(*pluginArray, list_item);
      *length = *length + 1;
    }
  }
  return PR_TRUE;
#else
  return PR_FALSE;
#endif
}

static PRBool
gtk_moz_embed_common_get_npplugin_list(PRUint32 *aLength, GList **pluginArray)
{
  nsresult rv;
  nsCOMPtr<nsIPluginHost> pluginHost(do_GetService(MOZ_PLUGIN_HOST_CONTRACTID, &rv));
  NS_ENSURE_SUCCESS(rv, FALSE);

  pluginHost->ReloadPlugins(PR_FALSE);  //FIXME XXX MEMLEAK

  pluginHost->GetPluginCount(aLength);

  if (!pluginArray)
    return FALSE;

  nsIDOMPlugin **aItems = new nsIDOMPlugin*[*aLength];
  NS_ENSURE_TRUE(aItems, FALSE); // OUT OF Memory

  rv = pluginHost->GetPlugins(*aLength, aItems);
  if (NS_FAILED(rv)) {
    for (PRUint32 i = 0; i < *aLength; i++)
      NS_IF_RELEASE(aItems[i]);
    delete [] aItems;
    return FALSE;
  }

  nsString string;
  for (int plugin_index = 0; plugin_index < (gint) *aLength; plugin_index++) {
    GtkMozPlugin *list_item = g_new0(GtkMozPlugin, 1);
    UNACCEPTABLE_CRASHY_GLIB_ALLOCATION(list_item);

    rv = aItems[plugin_index]->GetName(string);
    if (!NS_FAILED(rv))
      list_item->title = g_strdup(NS_ConvertUTF16toUTF8(string).get());

    aItems[plugin_index]->GetFilename(string);
    if (!NS_FAILED(rv))
      list_item->path = g_strdup(NS_ConvertUTF16toUTF8(string).get());

    nsCOMPtr<nsIDOMMimeType> mimeType;
    PRUint32 mime_count = 0;
    rv = aItems[plugin_index]->GetLength(&mime_count);
    if (NS_FAILED(rv)) {
      g_free(list_item);
      continue;
    }

    nsString single_mime;
    string.SetLength(0);
    for (int mime_index = 0; mime_index < mime_count; ++mime_index) {
      rv = aItems[plugin_index]->Item(mime_index, getter_AddRefs(mimeType));
      if (NS_FAILED(rv))
        continue;
      rv = mimeType->GetDescription(single_mime);
      if (!NS_FAILED(rv)) {
        if (mime_index > 0)
          string.AppendLiteral("; ");
        string.Append(single_mime);
      }
    }

    list_item->type = g_strdup(NS_ConvertUTF16toUTF8(string).get());
    list_item->isPlugin = TRUE;

    if (!NS_FAILED(rv))
      *pluginArray = g_list_append(*pluginArray, list_item);
  }
  for (PRUint32 i = 0; i < *aLength; i++)
    NS_IF_RELEASE(aItems[i]);
  delete [] aItems;
  return TRUE;
}

gint
gtk_moz_embed_common_get_plugins_list(GList **pluginArray)
{
  PRUint32 aLength = 0;
  gtk_moz_embed_common_get_npplugin_list(&aLength, pluginArray);
  gtk_moz_embed_common_get_component_list(&aLength, pluginArray);
  return (gint)aLength;
}

gboolean idle_reload(void* data)
{
  PRInt32 winCount = 0;
  if (EmbedPrivate::sWindowList)
    winCount = EmbedPrivate::sWindowList->Count();
  for (gint i = 0; i < winCount; i++) {
    EmbedPrivate *tmpPrivate = static_cast<EmbedPrivate *>
                                             (EmbedPrivate::sWindowList->ElementAt(i));
    nsCOMPtr<nsIDOMDocument> domDoc;
    if (!tmpPrivate->mNavigation) continue;
    nsresult rv = tmpPrivate->mNavigation->GetDocument(getter_AddRefs(domDoc));
    if (NS_FAILED(rv))
      continue;
    nsCOMPtr<nsIPluginDocument> plug = do_QueryInterface(domDoc, &rv);
    if (plug)
      tmpPrivate->Reload(nsIWebNavigation::LOAD_FLAGS_CHARSET_CHANGE);
  }
  return FALSE;
}

void
gtk_moz_embed_common_reload_plugins(gboolean full_reload)
{
  nsresult rv;
  nsCOMPtr<nsIPluginHost> pluginHost(do_GetService(MOZ_PLUGIN_HOST_CONTRACTID, &rv));
  pluginHost->ReloadPlugins(PR_TRUE); //FIXME XXX MEMLEAK
  if (full_reload)
    g_idle_add(idle_reload, nsnull);
}

guint
gtk_moz_embed_common_get_security_mode(guint sec_state)
{
  GtkMozEmbedSecurityMode sec_mode;

  const guint wpl_security_bits = nsIWebProgressListener::STATE_IS_SECURE |
                                  nsIWebProgressListener::STATE_IS_BROKEN |
                                  nsIWebProgressListener::STATE_IS_INSECURE |
                                  nsIWebProgressListener::STATE_SECURE_HIGH |
                                  nsIWebProgressListener::STATE_SECURE_MED |
                                  nsIWebProgressListener::STATE_SECURE_LOW;

  /* sec_state is defined as a bitmask that may be extended in the future.
   * We filter out any unknown bits before testing for known values.
   */
  switch (sec_state & wpl_security_bits) {
    case nsIWebProgressListener::STATE_IS_INSECURE:
      sec_mode = GTK_MOZ_EMBED_NO_SECURITY;
      //g_print("GTK_MOZ_EMBED_NO_SECURITY\n");
      break;
    case nsIWebProgressListener::STATE_IS_BROKEN:
      sec_mode = GTK_MOZ_EMBED_NO_SECURITY;
      //g_print("GTK_MOZ_EMBED_NO_SECURITY\n");
      break;
    case nsIWebProgressListener::STATE_IS_SECURE|
      nsIWebProgressListener::STATE_SECURE_HIGH:
      sec_mode = GTK_MOZ_EMBED_HIGH_SECURITY;
      //g_print("GTK_MOZ_EMBED_HIGH_SECURITY");
      break;
    case nsIWebProgressListener::STATE_IS_SECURE|
      nsIWebProgressListener::STATE_SECURE_MED:
      sec_mode = GTK_MOZ_EMBED_MEDIUM_SECURITY;
      //g_print("GTK_MOZ_EMBED_MEDIUM_SECURITY\n");
      break;
    case nsIWebProgressListener::STATE_IS_SECURE|
      nsIWebProgressListener::STATE_SECURE_LOW:
      sec_mode = GTK_MOZ_EMBED_LOW_SECURITY;
      //g_print("GTK_MOZ_EMBED_LOW_SECURITY\n");
      break;
    default:
      sec_mode = GTK_MOZ_EMBED_UNKNOWN_SECURITY;
      //g_print("GTK_MOZ_EMBED_UNKNOWN_SECURITY\n");
      break;
  }
  return sec_mode;
}

gint
gtk_moz_embed_common_clear_cache(void)
{
  nsCacheStoragePolicy storagePolicy;

  nsCOMPtr<nsICacheService> cacheService = do_GetService(NS_CACHESERVICE_CONTRACTID);

  if (cacheService)
  {
    //clean disk cache and memory cache
    storagePolicy = nsICache::STORE_ANYWHERE;
    cacheService->EvictEntries(storagePolicy);
    return 0;
  }
  return 1;
}
