/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Nokia code.
 *
 * The Initial Developer of the Original Code is Novell.
 * Portions created by the Initial Developer are Copyright (C) 2008
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Aiken Tie <ext-tie.aiken@nokia.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#ifndef TESTGTKMOZEMBED_COMMON_H
#define TESTGTKMOZEMBED_COMMON_H

#include <cppunit/extensions/HelperMacros.h>
#include <gtk/gtk.h>
#include <glib.h>

#include "gtkmozembed_common.h"

class TestGtkMozEmbedCommon : public CppUnit::TestFixture
{
	CPPUNIT_TEST_SUITE( TestGtkMozEmbedCommon );
	CPPUNIT_TEST(testConstructor);
	CPPUNIT_TEST(testDestructor);
	CPPUNIT_TEST(testSetPref1);
	CPPUNIT_TEST(testSetPref2);
	CPPUNIT_TEST(testSetPref3);
	CPPUNIT_TEST(testGetPref1);
	CPPUNIT_TEST(testGetPref2);
	CPPUNIT_TEST(testGetPref3);
	CPPUNIT_TEST(testSavePref);
	CPPUNIT_TEST(testGetLogins);
	CPPUNIT_TEST(remove_passwords);
	CPPUNIT_TEST(testGetHistoryList);
	CPPUNIT_TEST(testRemoveHistory);
	CPPUNIT_TEST(testGetCookieList);
	CPPUNIT_TEST(testDeleteAllCookies);
	CPPUNIT_TEST(testNSX509toRaw);
	CPPUNIT_TEST(testGetPluginsList);
	CPPUNIT_TEST(testGetPluginsListWithNULL);
	CPPUNIT_TEST(testReloadPlugins);
	CPPUNIT_TEST(testGetSecurityMode);
	CPPUNIT_TEST(testClearCache);
	CPPUNIT_TEST_SUITE_END();
	public:

	void testConstructor();
	void testDestructor();
	void testSetPref1();
	void testSetPref2();
	void testSetPref3();
	void testGetPref1();
	void testGetPref2();
	void testGetPref3();
	void testSavePref();
	void testGetLogins();
	void remove_passwords();
	void testGetHistoryList();
	void testRemoveHistory();
	void testGetCookieList();
	void testDeleteAllCookies();
	void testNSX509toRaw();
	void testGetPluginsList();
	void testGetPluginsListWithNULL();
	void testReloadPlugins();
	void testGetSecurityMode();
	void testClearCache();


	GtkWidget* mWidget;
	GtkMozEmbedCommon *mEmbed;

	private:
	void initGtkMozEmbedCommon();
};


#endif //TESTGTKMOZEMBED_COMMON_H
